﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_GoodsTopList, HTShop.WebUI" %>
<div class="<%=StyleClass%>">
    <asp:Repeater ID="RP_List" runat="server">
        <HeaderTemplate>
            <ul class="product-list">
        </HeaderTemplate>
        <ItemTemplate>
            <li class="product">
                <h3>
                    <%# DataBinder.Eval(Container.DataItem, "ProductName")%>
                </h3>
                <div class="info">
                    <div class="pic">
                        <a href="/d<%# DataBinder.Eval(Container.DataItem, "ProductId")%>.html" target="_blank">
                            <img src="/uppic/product_medium/<%# DataBinder.Eval(Container.DataItem, "PicUrl")%>" alt="<%# DataBinder.Eval(Container.DataItem, "ProductName")%>" /></a>
                    </div>
                    <div class="price">
                        <div class="now-price">
                            <em>
                                <%# DataBinder.Eval(Container.DataItem, "SalePrice","{0:c}")%>
                            </em>
                        </div>
                        <div class="market-price">
                            <span>市场价：</span> <del>
                                <%# DataBinder.Eval(Container.DataItem, "MarketPrice","{0:c}")%></del>
                        </div>
                    </div>
                    <div class="name">
                        <a href="/d<%# DataBinder.Eval(Container.DataItem, "ProductId")%>.html" target="_blank">
                            <%# DataBinder.Eval(Container.DataItem, "ProductName")%>
                        </a>
                    </div>
                    <div class="promotion">
                        <ul class="promotion-list">
                            <li><span>
                            <%# (Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "SalePrice")) / Convert.ToDecimal(DataBinder.Eval(Container.DataItem, "MarketPrice")) * 10).ToString("#.#")%>
                                折</span> </li>
                            <li><span>积<%# DataBinder.Eval(Container.DataItem, "Point")%>分</span> </li>
                            <li><span><a href="###" onclick="addToCompare(this,<%# DataBinder.Eval(Container.DataItem, "ProductId")%>,'<%# DataBinder.Eval(Container.DataItem, "ProductName")%>')">
                                对比</a></span></li>
                        </ul>
                    </div>
                </div>
            </li>
        </ItemTemplate>
        <FooterTemplate>
            </ul></FooterTemplate>
    </asp:Repeater>
</div>
