﻿<%@ control language="C#" autoeventwireup="true" inherits="Controls_Manage_PromoteSales_Products, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="ManagerPager.ascx"%>
商品ID：<input id="ProductId" type="text" runat="server" /> 
商品摘要：<input id="Summary" type="text" class="text w200" runat="server" /> 
<asp:Button ID="BTN_AddProduct" runat="server" Text=" 添加 " OnClick="BTN_AddProduct_Click" CausesValidation="false" />
             <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True"
            AutoGenerateColumns="False" BackColor="White" BorderColor="#DEDFDE" BorderStyle="solid"
            BorderWidth="1px" CellPadding="4" EmptyDataText="没有找到任何数据" ForeColor="Black"
            GridLines="Vertical" DataKeyNames="ProductId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID" SortExpression="ProductId">
                    <ItemTemplate>
                        <%# Eval("ProductId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品名称">
                    <ItemTemplate>
                        <div class="title"><a href="/d<%# Eval("ProductId") %>.html" target="_blank">
                            <%# Eval("ProductName") %>
                        </a></div>
                        <div class="summary">摘要：<%# Eval("Summary") %></div>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left"/>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品价格(销售价)">
                    <ItemTemplate>
                    <%# Eval("SalePrice","{0:C2}") %>
                    </ItemTemplate>
                </asp:TemplateField>                            
                <asp:TemplateField HeaderText="库存">
                    <ItemStyle Width="40px" />
                    <ItemTemplate>
                        <%#HTShop.BLL.Product.GetStocks(Convert.ToInt32(Eval("Stocks")))%>
                    </ItemTemplate>
                </asp:TemplateField>                 
                <asp:TemplateField HeaderText="添加日期">
                    <ItemStyle Width="60px" />
                    <ItemTemplate>
                        <%# Eval( "AddDate", "{0:d}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemStyle HorizontalAlign="Center" Width="80px"></ItemStyle>
                    <ItemTemplate>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"
                            OnClientClick="return confirm('确认删除选择的商品吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
            <HeaderStyle Font-Bold="True" HorizontalAlign="Center" Height="20px" ForeColor="#FFFFFF" VerticalAlign="Middle" BackColor="#6B696B"></HeaderStyle>
            <PagerSettings Mode="NumericFirstLast" />
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:Pagination>