﻿<%@ Application Language="C#" %>

<script runat="server">

    void Application_Start(object sender, EventArgs e) 
    {
        //在应用程序启动时运行的代码
        HTShop.BLL.ProductCategory category = new HTShop.BLL.ProductCategory();
        category.ResetProductCategories();

        System.Timers.Timer t = new System.Timers.Timer(1000 * 3600 * 1);//每1小时触发一次

        t.AutoReset = true;
        t.Enabled = true;
        t.Elapsed += new System.Timers.ElapsedEventHandler(TimerService);

    }
    
    void Application_End(object sender, EventArgs e) 
    {
        //在应用程序关闭时运行的代码

    }

    void Application_AuthenticateRequest(object sender, EventArgs e)
    {
        HttpApplication app = (HttpApplication)sender;
        HTShop.BLL.UserPrincipal.TrySetUserInfo(app.Context);
        //HTShop.Common.WriterLog.ToText(HTShop.Common.WriterLog.LogType.Debug, "HTShop.BLL.UserPrincipal.TrySetUserInfo", ".......");
    }

        
    void Application_Error(object sender, EventArgs e) 
    { 
        //在出现未处理的错误时运行的代码
        Exception objErr = Server.GetLastError().GetBaseException();
        string error = string.Empty;
        string addr = "发生异常页: " + Request.Url.ToString();
        string info = "异常信息: " + objErr.Message;
        string source = "错误源:" + objErr.Source;
        string trace = "堆栈信息:" + objErr.StackTrace;

        error += "发生异常页: <a href=" + Request.Url.ToString() + ">" + Request.Url.ToString() + "</a><br/>";
        error += "异常信息: " + objErr.Message + "<br>";

        //Server.ClearError();
        Application["error"] = error;
        // 写入日志
        HTShop.Common.WriterLog.ToText(HTShop.Common.WriterLog.LogType.Error, "System", addr + " " + info + " " + source + " " + trace + " 用户IP:" + Request.UserHostAddress);
        //Server.Transfer("~/system_error/apperror_500.html");
    }

    void Session_Start(object sender, EventArgs e) 
    {
        //在新会话启动时运行的代码

    }

    void Session_End(object sender, EventArgs e) 
    {
        //在会话结束时运行的代码。 
        // 注意: 只有在 Web.config 文件中的 sessionstate 模式设置为
        // InProc 时，才会引发 Session_End 事件。如果会话模式 
        //设置为 StateServer 或 SQLServer，则不会引发该事件。

    }

    void TimerService(object sender, System.Timers.ElapsedEventArgs e)
    {
        //if(DateTime.Now.Hour>1 || DateTime.Now.Hour<3)
        //{
        // do...
        //}
        HTShop.BLL.TimerWorker worker = new HTShop.BLL.TimerWorker();
        worker.Start();
        
    }
       
</script>
