﻿<%@ page language="C#" autoeventwireup="true" inherits="GoodsComment, HTShop.WebUI" %>
<%@ Register TagPrefix="skm" Namespace="ActionlessForm" Assembly="ActionlessForm" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="Controls/Header.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="Controls/Footer.ascx" %>
<%@ Register TagPrefix="UC" TagName="GoodsInfo" Src="Controls/GoodsInfo.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserBrowseHistory" Src="Controls/UserBrowseHistory.ascx" %>
<%@ Register TagPrefix="UC" TagName="QuickPager" Src="Controls/QuickPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>商品评论 -</title>
    <link href="/css/base.css" rel="stylesheet" type="text/css" />
    <link href="/css/base.ex.css" rel="stylesheet" type="text/css" />
    <link href="/css/comment.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.metadata.js"></script>
    <script type="text/javascript" src="/scripts/jquery.validate.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.validate.messages.cn.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/common.pack.js"></script>
    <script type="text/javascript" src="/scripts/comment.pack.js"></script>
    <script type="text/javascript">
   $(function() {
            checkUserInfo();
            $("#form1").validate({
		rules: {
			Title:"required",
			Pros: "required",
			Cons: "required",
			Content: "required"
		}
	});      
});
    </script>
</head>
<body>
    <UC:Header ID="Header1" runat="Server"></UC:Header>
    <skm:Form ID="form1" runat="server">
        <div class="container">
            <div class="sidebar">
                <div class="sideheader clearfix">
                    <h3>当前评论商品</h3>
                </div>
                <div class="sidecontent">
                    <UC:GoodsInfo ID="GoodsInfo1" runat="Server"></UC:GoodsInfo>
                </div>
                <div class="sideheader clearfix">
                    <h3>最近浏览过的商品</h3>
                    <p><a href="javascript:clearBrowseHistory('.goodsbrowsehistory')">清除</a></p>
                </div>
                <div class="sidecontent">
                    <UC:UserBrowseHistory ID="UserBrowseHistory1" runat="Server"></UC:UserBrowseHistory>
                </div>
            </div>
            <div class="maincontent">
                <asp:Literal ID="EmptyDataText" runat="server"></asp:Literal>
                <asp:PlaceHolder ID="PH_DataList" runat="server">
                    <asp:Repeater ID="RP_List" runat="server" OnItemDataBound="RP_List_ItemDataBound">
                        <ItemTemplate>
                            <div class="comment-item clearfix">
                                <div class="user">
                                    <div class="u-icon">
                                        <a href="#">
                                            <img src="/uppic/users/face/<%# Eval("FacePic")%>" /></a></div>
                                    <div class="u-name">
                                        <a href="#">
                                            <%# Eval("Nickname")%></a></div>
                                    <div class="u-level">
                                        <%# Eval("GroupName")%></div>
                                    <div class="u-address">
                                        (北京)</div>
                                </div>
                                <div class="i-detail">
                                    <div class="o-topic">
                                        <strong><a name="c<%# Eval("CommentId")%>"></a><a href="reply-comment<%# Eval("CommentId")%>.html">
                                            <%# Eval("Title")%>
                                        </a></strong>
                                        <span class="star<%# Eval("Star")%>"></span>
                                        <span class="c-date"><%# Eval("AddDate")%></span>
                                    </div>
                                    <div class="c-content">
                                        <dl>
                                            <dt>优点：</dt><dd><%# Eval("Pros")%></dd></dl>
                                        <dl>
                                            <dt>不足：</dt><dd><%# Eval("Cons")%></dd></dl>
                                        <dl>
                                            <dt>总结：</dt><dd><%# Eval("Content")%></dd></dl>
                                    </div>
                                    <div class="btns">
                                    <div class="userreply">
                                        <a href="reply-comment<%# Eval("CommentId")%>-d<%# Eval("ProductId")%>.html" class="btn-reply">回复(<%# Eval("ReplyNum")%>)</a> 
                                        <span class="date"><%# Eval("BuyDate")%></span>
                                       </div>
                                        <div class="userful">
                                            <span class="note">此评价对我</span> 
                                            <a href="javascript:evaluation(<%# Eval("CommentId")%>,1)" class="btn-agree">有用(<span id="agree_<%# Eval("CommentId")%>"><%# Eval("Agree")%></span>)</a>
                                            <a href="javascript:evaluation(<%# Eval("CommentId")%>,2)" class="btn-oppose">没用(<span id="oppose_<%# Eval("CommentId")%>"><%# Eval("Oppose")%></span>)</a></div>
                                    </div>
                                    <div class="replies">
                                        <asp:Repeater ID="Reply_List" runat="server">
                                            <ItemTemplate>
                                                <div class="reply clearfix">
                                                    <div class="reply-no">
                                                        <em>
                                                            <%#Container.ItemIndex+1%><span>楼</span></em></div>
                                                    <div class="reply-bd clearfix">
                                                        <div class="name">
                                                            <a href="UserInfo.aspx?id=<%# Eval("UserId")%>">
                                                                <%# Eval("Nickname")%></a> 回复说：</div>
                                                        <div class="group"><%# Eval("GroupName")%></div>
                                                        <div class="date">
                                                            <%# Eval("AddDate")%>
                                                        </div>
                                                        <div class="s5">
                                                        </div>
                                                        <%# Eval("ReplyContent")%>
                                                    </div>
                                                </div>
                                            </ItemTemplate>
                                        </asp:Repeater>
                                    </div>
                                </div>
                                <div class="corner tl">
                                </div>
                                <div class="corner tr">
                                </div>
                                <div class="corner b">
                                </div>
                                <div class="corner bl">
                                </div>
                                <div class="corner br">
                                </div>
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>
                    <UC:QuickPager ID="Pager" runat="Server"></UC:QuickPager>
                </asp:PlaceHolder>
                <a name="review"></a>
                <table cellspacing="0" cellpadding="0" class="addcomments">
                    <thead>
                        <tr>
                            <th>
                                给商品评分并发表评价：
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                    <tr>
                        <td>
                            <strong>评分：</strong><div class="s5">
                            </div>
                            <ul class="stargroups">
                                <li>
                                    <input id="star5" type="radio" name="star" value="5" validate="required:true" /><label for="star5"><div class="star5">
                                    </div>
                                    </label></li>
                                <li>
                                    <input id="star4" type="radio" name="star" value="4" /><label for="star4"><div class="star4">
                                    </div>
                                    </label></li>
                                <li>
                                    <input id="star3" type="radio" name="star" value="3" /><label for="star3"><div class="star3">
                                    </div>
                                    </label></li>
                                <li>
                                    <input id="star2" type="radio" name="star" value="2" /><label for="star2"><div class="star2">
                                    </div>
                                    </label></li>
                                <li>
                                    <input id="star1" type="radio" name="star" value="1" /><label for="star1"><div class="star1">
                                    </div>
                                    </label></li>
                            </ul>
                            <label for="star" style="display: none;" class="error">请选择评分</label>
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>标题：</strong><div class="s5">
                            </div>
                            <input id="Title" type="text" class="text" runat="server" />
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>您认为该商品的优点是：</strong><div class="s5">
                            </div>
                            <textarea id="Pros" cols="20" rows="2" class="text" onpaste="return onCharsChange(this,200,'tip3');"
                                onkeyup="return onCharsChange(this,200,'tip3');" runat="server"></textarea>
                            (还可输入<span id="tip3">200</span>个字)
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>您认为该商品的不足是：</strong><div class="s5">
                            </div>
                            <textarea id="Cons" cols="20" rows="2" class="text" onpaste="return onCharsChange(this,200,'tip2');"
                                onkeyup="return onCharsChange(this,200,'tip2');" runat="server"></textarea>
                            (还可输入<span id="tip2">200</span>个字)
                        </td>
                    </tr>
                    <tr>
                        <td>
                            <strong>总结：</strong><div class="s5">
                            </div>
                            <textarea id="Content" cols="20" rows="2" class="text" onpaste="return onCharsChange(this,200,'tip1');"
                                onkeyup="return onCharsChange(this,200,'tip1');" runat="server"></textarea>
                            (还可输入<span id="tip1">200</span>个字)
                        </td>
                    </tr>
                    </tbody>
                    <tfoot>
                    <tr>
                        <td>
                             <input id="BTN_Submit" type="submit" value=" "  runat="server" onserverclick="BTN_Submit_ServerClick"/>
                        </td>
                    </tr>
                    <tr>
                        <td class="note">
                            声明：<br />
                            1、欢迎您在此发表与商品质量、使用情况、心得体验相关的内容和评价，以帮助其他用户了解商品；<br />
                            2、商品评价采用先发布后审核原则，如果我们认为您的评价不能给其他用户带来帮助或违反国家有关规定，我们有权删除您的评价；<br />
                            3、只有购买过该商品且在半年内的用户才能进行评价，每条通过审核的评价均能获得一定积分奖励（赠品不给分，同一商品仅能评价一次），查看具体规则
                        </td>
                    </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </skm:Form>
    <UC:Footer ID="Footer1" runat="Server"></UC:Footer>
    <%=HTShop.Global.StatCode()%>  
</body>
</html>
