﻿<%@ page language="C#" autoeventwireup="true" inherits="GoodsQA, HTShop.WebUI" %>
<%@ Register TagPrefix="skm" Namespace="ActionlessForm" Assembly="ActionlessForm" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="Controls/Header.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="Controls/Footer.ascx" %>
<%@ Register TagPrefix="UC" TagName="GoodsInfo" Src="Controls/GoodsInfo.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserBrowseHistory" Src="Controls/UserBrowseHistory.ascx" %>
<%@ Register TagPrefix="UC" TagName="QuickPager" Src="Controls/QuickPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>商品咨询 -</title>
    <link href="/css/base.css" rel="stylesheet" type="text/css" />
    <link href="/css/base.ex.css" rel="stylesheet" type="text/css" />
    <link href="/css/comment.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.metadata.js"></script>
    <script type="text/javascript" src="/scripts/jquery.validate.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.validate.messages.cn.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/common.pack.js"></script>
    <script type="text/javascript">
        $.metadata.setType("attr", "validate");
        function evaluation(id, t) {
            var url = "/XHttpService/XHR_Comment.ashx?t=qa-evaluation&id=" + id + "&type=" + t + "&dt=" + new Date();
            $.getJSON(url, function(data) {
                if (data.errmsg == "") {
                    if (t == 1) {
                        $('#agree_' + id).text(data.num);
                    }
                    else if (t == 2) {
                        $('#oppose_' + id).text(data.num);
                    }
                }
            });
        };

        function checkUserInfo() {
           
                    var url = "/XHttpService/XHR_Common.ashx?t=userinfo&dt=" + new Date();
                    $.getJSON(url, function(data) {
                        if (data.nickname == "") {
                            alert("请登录后再进行咨询.");
                            $.colorbox({ iframe: true, overlayClose: false, width: "520px", height: "430px", href: "LoginLite.aspx" });
                        }
                    });
        };

        $(function() {
            checkUserInfo();
            $("#form1").validate({
                rules: {Content: "required"}
            });
        });
    </script>

</head>
<body>
    <UC:Header ID="Header1" runat="Server"></UC:Header>
    <skm:Form ID="form1" runat="server">
        <div class="container">
            <div class="sidebar">
            <div class="sideheader clearfix">
                    <h3>当前咨询商品</h3>
                </div>
                <div class="sidecontent">
                    <UC:GoodsInfo ID="GoodsInfo1" runat="Server"></UC:GoodsInfo>
                </div>
                <div class="sideheader clearfix">
                    <h3>最近浏览过的商品</h3>
                    <p><a href="javascript:clearBrowseHistory('.goodsbrowsehistory')">清除</a></p>
                </div>
                <div class="sidecontent">
                    <UC:UserBrowseHistory ID="UserBrowseHistory1" runat="Server"></UC:UserBrowseHistory>
                </div>
            </div>
            <div class="maincontent">
                <asp:Literal ID="EmptyDataText" runat="server"></asp:Literal>
                <asp:PlaceHolder ID="PH_DataList" runat="server">
                    <asp:Repeater ID="RP_List" runat="server">
                        <ItemTemplate>
                            <div class="qa-item clearfix">
                                <div class="user clearfix">
                                    <div class="u-name"><a href="#"><%# Eval("Nickname")%></a></div>
                                    <div class="c-date"><%# Eval("AddDate")%></div>
                                    <div class="u-level"><%# Eval("GroupName")%></div>
                                    
                                </div>
                                <div class="qa-detail clearfix">
                                    <dl>
                                        <dt>咨询内容：</dt><dd><%# Eval("Description")%></dd></dl>
                                    <dl>
                                        <dt>客服回复：</dt><dd><%# Eval("ReplyContent")%></dd></dl>
                                </div>
                                <div class="btns clearfix">
                                    <div class="userful">
                                        <span class="note">此回复对我</span> 
                                        <a href="javascript:evaluation(<%# Eval("QAId")%>,1)">有用(<span id="agree_<%# Eval("QAId")%>"><%# Eval("Agree")%></span>)</a>
                                        <a href="javascript:evaluation(<%# Eval("QAId")%>,2)">没用(<span id="oppose_<%# Eval("QAId")%>"><%# Eval("Oppose")%></span>)</a>
                                    </div>
                                </div>
                            </div>
                        </ItemTemplate>
                        <AlternatingItemTemplate>
                        <div class="qa-item alt clearfix">
                                <div class="user clearfix">
                                    <div class="u-name"><a href="#"><%# Eval("Nickname")%></a></div>                                    
                                    <div class="c-date"><%# Eval("AddDate")%></div>
                                    <div class="u-level"><%# Eval("GroupName")%></div>
                                </div>
                                <div class="qa-detail clearfix">
                                    <dl>
                                        <dt>咨询内容：</dt><dd><%# Eval("Description")%></dd></dl>
                                    <dl>
                                        <dt>客服回复：</dt><dd><%# Eval("ReplyContent")%></dd></dl>
                                </div>
                                <div class="btns clearfix">
                                    <div class="userful">
                                        <span class="note">此回复对我</span> 
                                        <a href="javascript:evaluation(<%# Eval("QAId")%>,1)">有用(<span id="agree_<%# Eval("QAId")%>"><%# Eval("Agree")%></span>)</a>
                                        <a href="javascript:evaluation(<%# Eval("QAId")%>,2)">没用(<span id="oppose_<%# Eval("QAId")%>"><%# Eval("Oppose")%></span>)</a>
                                    </div>
                                </div>
                            </div>
                        </AlternatingItemTemplate>
                    </asp:Repeater>
                    <UC:QuickPager ID="Pager" runat="Server"></UC:QuickPager>
                </asp:PlaceHolder>
                <a name="review"></a>
                <table cellspacing="0" cellpadding="0" class="addcomments">
                    <thead>
                        <tr>
                            <th>
                                发表咨询：
                            </th>
                        </tr>
                    </thead>
                    <tbody>
                        <tr>
                            <td>
                                <div class="note">
                                    声明：您可在购买前对产品包装、颜色、运输、库存等方面进行咨询，我们有专人进行回复！因厂家随时会更改一些产品的包装、颜色、产地等参数，所以该回复仅在当时对提问者有效，其他网友仅供参考！</div>
                               <div class="s10"></div>
                               <strong>咨询类型：</strong><div class="s5"></div>
                                <ul class="stargroups">
                                    <li>
                                        <input id="qa1" type="radio" name="qa" value="1" validate="required:true" /><label
                                            for="qa1">商品咨询</label></li>
                                    <li>
                                        <input id="qa2" type="radio" name="qa" value="2" /><label for="qa2">库存及配送</label></li>
                                    <li>
                                        <input id="qa3" type="radio" name="qa" value="3" /><label for="qa3">支付问题</label></li>
                                    <li>
                                        <input id="qa4" type="radio" name="qa" value="4" /><label for="qa4">发票及保修</label></li>
                                    <li>
                                        <input id="qa5" type="radio" name="qa" value="5" /><label for="qa5">促销及赠品</label></li>
                                </ul>
                                <label for="qa" style="display: none;" class="error">
                                    请选择咨询类型！</label>
                            </td>
                        </tr>
                        <tr>
                            <td>
                                <strong>咨询内容：</strong><div class="s5">
                                </div>
                                <textarea id="Content" cols="20" rows="2" class="text" onpaste="return onCharsChange(this,500,'tip3');"
                                    onkeyup="return onCharsChange(this,500,'tip3');" runat="server"></textarea>
                                (还可输入<span id="tip3">500</span>个字)
                            </td>
                        </tr>
                    </tbody>
                    <tfoot>
                        <tr>
                            <td>
                                <input id="BTN_Submit" type="submit" value=" " runat="server" onserverclick="BTN_Submit_ServerClick" />
                                <input type="hidden" name="BTN_Submit" value="chrome_formsubmit补丁" /> 
                            </td>
                        </tr>
                    </tfoot>
                </table>
            </div>
        </div>
    </skm:Form>
    <UC:Footer ID="Footer1" runat="Server"></UC:Footer>
    <%=HTShop.Global.StatCode()%>  
</body>
</html>
