﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_AdStat, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="ManagerPager" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>广告浏览统计列表</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(function () {
            $(".list").rowStyle("tr1", "tr2", "tr3");
        });
    </script>
    <style type="text/css">
        .preview img
        {
            max-width: 300px;
            max-height: 80px;
            padding: 2px;
            border: solid 1px #ccc;
        }
    </style>
</head>
<body>
    <UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
        <fieldset class="obox">
            <legend>查询条件 </legend>
            <div class="skin clearfix">
                <div class="filter">
                    每页<input class="text w20" value="20" id="PageSize" runat="server" />条记录 <span class="sp">|</span> 关键字：<input id="Keyword" type="text" runat="server" class="text" />&nbsp;
                    <asp:DropDownList ID="FieldList" runat="server" CssClass="ddl">
                        <asp:ListItem Value="AdId">广告ID</asp:ListItem>
                        <asp:ListItem Value="VisitedIP">IP地址</asp:ListItem>
                        <asp:ListItem Value="VisitedRef">参考数据</asp:ListItem>
                        <asp:ListItem Value="FromRef">来源</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;<input id="BTN_Search" type="submit" runat="server" value=" 查 询 " onserverclick="BTN_Search_ServerClick" />
                </div>
                <div class="add">
                    分组统计：TOP<input class="tbx w20" value="50" id="TopNum" runat="server" />条记录 按<asp:DropDownList ID="Date" runat="server" CssClass="ddl">
                        <asp:ListItem Value="Day">今天</asp:ListItem>
                        <asp:ListItem Value="Week">本周</asp:ListItem>
                        <asp:ListItem Value="Month">本月</asp:ListItem>
                        <asp:ListItem Value="Quarter">季度</asp:ListItem>
                        <asp:ListItem Value="Year">年</asp:ListItem>
                        <asp:ListItem Value="">所有</asp:ListItem>
                    </asp:DropDownList>
                    <input id="BTN_ShowTopList" type="submit" runat="server" value="显示" onserverclick="BTN_ShowTopList_ServerClick" />
                </div>
            </div>
        </fieldset>
        <asp:PlaceHolder ID="PH_List" runat="server">
            <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="AdId"
                PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
                <Columns>
                    <asp:TemplateField HeaderText="选择">
                        <ItemTemplate>
                            <asp:CheckBox ID="cb_select" runat="server" />
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Center" Width="30px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="广告" SortExpression="AdId">
                        <ItemStyle HorizontalAlign="Left" Width="200px" />
                        <ItemTemplate>
                            <a href="AdsList.aspx?id=<%#Eval("AdId")%>" target="_blank">
                                <%#Eval("AdName")%></a> (<%#Eval("AdId")%>)
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="IP地址" SortExpression="VisitedIP">
                        <ItemStyle HorizontalAlign="Left" />
                        <ItemTemplate>
                            <%# Eval("VisitedIP")%>
                            (<%# HTShop.Common.IPLocationSearch.GetIPAllLocation(Eval("VisitedIP").ToString())%>)
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="来源" SortExpression="VisitedRef">
                        <ItemStyle Wrap="true" HorizontalAlign="left" />
                        <ItemTemplate>
                            <%# Eval("VisitedRef")%><br />
                            <%# Eval("FromRef")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="访问时间" SortExpression="VisitedDateTime">
                        <ItemStyle Width="120px" />
                        <ItemTemplate>
                            <%# Eval("VisitedDateTime")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <ItemStyle Width="30px" />
                        <ItemTemplate>
                            <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的资讯吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
            <UC:ManagerPager ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:ManagerPager>
            <div class="obox">
                <div class="skin">
                    <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
                    全选 | 功能操作：
                    <select id="ManageStatus" name="ManageStatus">
                        <option value="Delete">删除</option>
                    </select>
                    <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定" OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
                </div>
            </div>
        </asp:PlaceHolder>
    </div>
    <div class="container">
        <asp:Repeater ID="RP_List" runat="server" Visible="false">
            <HeaderTemplate>
                <table cellspacing="1" cellpadding="0" class="list">
                    <tr>
                        <th class="title">
                            广告ID
                        </th>
                        <th class="title">
                            广告标题
                        </th>
                        <th class="title">
                            广告链接
                        </th>
                        <th class="title">
                            点击次数
                        </th>
                    </tr>
            </HeaderTemplate>
            <ItemTemplate>
                <tr>
                    <td>
                        <a href="AdsList.aspx?id=<%#Eval("AdId")%>" target="_blank" class="a_blue">
                            <%#Eval("AdId")%></a>
                    </td>
                    <td>
                        <%# Eval("AdName")%>
                    </td>
                    <td>
                        <%# Eval("AdUrl")%>
                    </td>
                    <td>
                        <%# Eval("Num")%>
                        次
                    </td>
                </tr>
            </ItemTemplate>
            <FooterTemplate>
                </table></FooterTemplate>
        </asp:Repeater>
    </div>
    </form>
</body>
</html>
