﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_AfficheList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="ManagerPager" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>网站公告列表</title>    
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/> 
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.zh_CN.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            bindSort();
            //设置datetime
            $("#StartDate").date_input();
            $("#EndDate").date_input();
            $(".list").rowStyle("tr1", "tr2", "tr3");
        });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
         <fieldset class="obox"><legend>查询条件</legend>
            <div class="skin">
            <strong>状态：</strong> <asp:DropDownList ID="Status" runat="server">
            <asp:ListItem Value="">所有</asp:ListItem>
                    <asp:ListItem Value="1">审核通过</asp:ListItem>
                    <asp:ListItem Value="0">审核中</asp:ListItem>
                </asp:DropDownList>
              <span class="sp">|</span>
             <strong>属性：</strong> 
                <asp:CheckBox ID="CB_HighLight" runat="server" Text="标题醒目">
                </asp:CheckBox>
                <asp:CheckBox ID="CB_Commend" runat="server" Text="文章推荐">
                </asp:CheckBox>     
              <div class="s5"></div>
              <strong>日期：</strong> <input class="text w80" id="StartDate" runat="server" /> 至 <input class="text w80" id="EndDate" runat="server" />
              <span class="sp">|</span>
                <strong>关键字：</strong>
            <input class="text w200" name="Keyword" id="Keyword" runat="server" />
                <span class="sp">|</span> <strong>查询列：</strong>
                <asp:DropDownList ID="FieldList" runat="server" CssClass="ddl">
                    <asp:ListItem Value="Title">标题</asp:ListItem>
                    <asp:ListItem Value="Source">来源</asp:ListItem>
                    <asp:ListItem Value="Description">内容</asp:ListItem>                    
                </asp:DropDownList>
              &nbsp;&nbsp;每页<input class="text w20" value="20" id="PageSize" name="PageSize"/>条记录
                <input type="submit" value=" 查 询 " id="BTN_Search" runat="server" onserverclick="BTN_Search_ServerClick"  CausesValidation="false"/>
                <!--<asp:Literal ID="L_Result" runat="server"></asp:Literal>-->
            </div>
        </fieldset>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="AutoId" PageSize="20" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID">
                    <ItemTemplate>
                        <%# Eval("AutoId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="标题" SortExpression="Title">
                    <ItemTemplate>
                        <a href="/Affiche/n<%# Eval("AutoId")%>.html" target="_blank">
                            <%# Eval("Title") %>
                        </a></ItemTemplate>
                        <ItemStyle HorizontalAlign="Left"/>
                </asp:TemplateField>
               
                <asp:TemplateField HeaderText="添加日期" SortExpression="AddDate">
                    <ItemStyle Width="120px" />
                    <ItemTemplate>
                        <%# Eval("AddDate")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="浏览数" SortExpression="Hit">
                    <ItemStyle Width="40px" />
                    <ItemTemplate>
                        <%# Eval("Hit")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="属性">
                    <ItemTemplate>                      
                        <%# Eval("HighLight").ToString() == "True" ? "<strong>标题醒目</strong>" : ""%>
                        <%# Eval("Commend").ToString() == "True" ? "<strong>推荐</strong>" : ""%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态" SortExpression="Status">
                    <ItemTemplate>
                        <%# HTShop.BLL.Util.ReturnStatus(DataBinder.Eval(Container, "DataItem.Status").ToString())%>
                        <%# DataBinder.Eval(Container, "DataItem.Locked").ToString()=="True"?"<span class=locked title=已被锁定>锁定</span>":""%>
                    </ItemTemplate>
                    <ItemStyle Width="60px" />
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                     <a id="sort_up_<%# Eval("AutoId")%>" href="AfficheList.aspx?sort=up&id=<%# Eval("AutoId")%>" class="move-up">上移</a>
                     <a id="sort_down_<%# Eval("AutoId")%>" href="AfficheList.aspx?sort=down&id=<%# Eval("AutoId")%>" class="move-down">下移</a>
                    </ItemTemplate>
                    <ItemStyle Width="60px" />
                </asp:TemplateField>
                <asp:TemplateField>
                    <ItemStyle HorizontalAlign="Center" Width="80px"></ItemStyle>
                    <ItemTemplate>                   
                        <a href="AddAffiche.aspx?id=<%# Eval("AutoId") %>" target="_blank">修改</a>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的资讯吗？删除后无法恢复！');"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:ManagerPager ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:ManagerPager>
        <div class="obox">
        <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus"  onchange="changeManageStatus()">
            <option value="Pass">审核通过</option>           
                <option value="InAuditing">审核中</option>
                <option value="HighLight">标题醒目</option>
                <option value="CancelHighLight">取消-标题醒目</option>
                <option value="Commend">推荐</option>
                <option value="CancelCommend">取消-推荐</option>
                <option value="Locked">锁定</option>
                <option value="UnLocked">解除-锁定</option>
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定" OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
        </div>
       </div>
       </div>
    </form>
</body>
</html>
