﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_AppSettings, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>程序配置</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.query.js"></script>
    <script type="text/javascript" src="/scripts/jquery.validate.min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(function () {
            showActionStatus();
            $(".item").rowStyle("bg1", "bg2", "bg3", "div.row");

            $("#form1").validate({
                rules: {
                    Domain: { required: true },
                    CacheDependencyFile: { required: true },
                    DefaultPage: { required: true },
                    SignInTimeout: { required: true, digits: true },
                    CartTimeout: { required: true, digits: true },
                    BrowseHistoryTimeout: { required: true, digits: true },
                    MaxFileSize: { required: true, digits: true },
                    MaxImgSize: { required: true, digits: true },
                    GoodsListPageSize: { required: true, digits: true }

                },
                messages: {
                    Domain: { required: '请输入网站Domain!' },
                    CacheDependencyFile: { required: '请输入缓存依赖文件地址!' }
                },

                submitHandler: function (form) {
                    $(form).find(":submit").attr("disabled", true).attr("value", "保存中..");
                    form.submit();
                }
            });

        });
    </script>
</head>
<body>
  <UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server" class="validate">
    <div class="container w900">
        <div id="flash-msg"></div>
        <table cellspacing="1" cellpadding="0" class="tf">
            <thead>
                <tr>
                    <th>
                        程序配置
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="item">
                                <div class="row clearfix">
                                    <div class="label">
                                        网站Domain：</div>
                                    <div class="field">
                                        <input id="Domain" type="text" runat="server" class="text w200" disabled="disabled" />
                                        <span class="n">(网站域名，格式：xxx.com，程序可以自动获取当前域名。）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                        软件授权密匙：</div>
                                    <div class="field">
                                        <input id="PrivateKey" type="text" runat="server" class="text w200" />
                                        <div class="n">（授权密匙KEY，购买软件授权后，可登录HTShop授权中心<a href="http://store.htshop.cn" target="_blank">http://store.htshop.cn</a>查看自己的授权密匙。）</div></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                        软件授权密匙2：</div>
                                    <div class="field">
                                        <input id="PrivateIV" type="text" runat="server" class="text w200" />
                                        <div class="n">（授权密匙KEY2，购买软件授权后，可登录HTShop授权中心<a href="http://store.htshop.cn" target="_blank">http://store.htshop.cn</a>查看自己的授权密匙。）</div></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                        软件授权码：</div>
                                    <div class="field">
                                       <textarea id="LicenseCode" rows="4" cols="80" runat="server"></textarea>
                                        <div class="n">（授权码，购买软件授权后，可登录HTShop授权中心<a href="http://store.htshop.cn" target="_blank">http://store.htshop.cn</a>查看自己的授权码。）</div></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        显示产品版权信息：</div>
                                    <div class="field">
                                       <asp:RadioButtonList ID="CopyrightEnabled" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="true" Selected="True">是</asp:ListItem>
                                            <asp:ListItem Value="false">否</asp:ListItem>
                                        </asp:RadioButtonList>
                                        <div class="n">（可显示或隐藏网站标题和页面底部中的软件版权信息，注意：只有授权密匙和授权码验证通过的情况，此项功能才生效。）</div></div>
                                </div>
                               <div class="row clearfix">
                                    <div class="label">
                                        缓存依赖文件：</div>
                                    <div class="field">
                                        <input id="CacheDependencyFile" type="text" runat="server" class="text w200" />
                                        <span class="n">（缓存依赖文件名，网站运行正常情况下请勿修改。)</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        网站默认首页：</div>
                                    <div class="field">
                                     <input id="DefaultPage" type="text" runat="server" class="text w200" />
                                        <span class="n">（网站默认首页文件名）</span></div>
                                </div>                               
                                <div class="row clearfix">
                                    <div class="label">
                                        登录超时时间：</div>
                                    <div class="field">
                                        <input id="SignInTimeout" type="text" runat="server" class="text w200" />
                                        <span class="n">（用户登录系统的有效期限，单位：小时）</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                       购物车超时时间：</div>
                                    <div class="field">
                                        <input id="CartTimeout" type="text" runat="server" class="text w200" />
                                        <span class="n">（购物车内商品信息保存超时时间，单位：小时）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                       历史浏览超时时间：</div>
                                    <div class="field">
                                        <input id="BrowseHistoryTimeout" type="text" runat="server" class="text w200" />
                                        <span class="n">（浏览商品的历史记录保存超时时间，单位：小时）</span></div>
                                </div>                               
                                <div class="row clearfix">
                                    <div class="label">
                                       最大上传文件容量：</div>
                                    <div class="field">
                                        <input id="MaxFileSize" type="text" runat="server" class="text w200" />
                                        <span class="n">（网站允许的上传文件的最大容量，单位：MB）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                       最大上传图片容量：</div>
                                    <div class="field">
                                        <input id="MaxImgSize" type="text" runat="server" class="text w200" />
                                        <span class="n">（网站允许的上传图片的最大容量，单位：MB）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                       列表页显示商品数量：</div>
                                    <div class="field">
                                        <input id="GoodsListPageSize" type="text" runat="server" class="text w200" />
                                        <span class="n">（列表页面显示的商品数量）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                        记录管理员访问日志：</div>
                                    <div class="field">
                                        <asp:CheckBox ID="AdminLogs" runat="server" />
                                        <span class="n">（勾选此项，将记录所有网站后台访问信息）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                        记录程序调试日志：</div>
                                    <div class="field">
                                        <asp:CheckBox ID="DebugLogs" runat="server" />
                                        <span class="n">（勾选此项，将记录所有程序中的标记为调试的日志信息）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                        记录在线支付日志：</div>
                                    <div class="field">
                                        <asp:CheckBox ID="DebugPayLogs" runat="server" />
                                        <span class="n">（勾选此项，将记录所有在线支付的日志信息）</span></div>
                                </div>                               
                                <div class="row clearfix">
                                    <div class="label">
                                        价格范围：</div>
                                    <div class="field">
                                        <textarea id="PriceRanges" rows="6" cols="20" runat="server"></textarea>
                                        <span class="n">（前台筛选商品的价格范围，每行一个数字范围，数字间用“-”分隔；）</span></div>
                                </div>
                                 <div class="row clearfix">
                                    <div class="label">
                                        积分范围：</div>
                                    <div class="field">
                                        <textarea id="PointRanges" rows="6" cols="20" runat="server"></textarea>
                                        <span class="n">（前台筛选商品的积分范围，每行一个数字范围，数字间用“-”分隔；）</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        折扣范围：</div>
                                    <div class="field">
                                        <textarea id="AgioRanges" rows="6" cols="20" runat="server"></textarea>
                                        <span class="n">（前台筛选商品的折扣范围，每行一个数字范围，数字间用“-”分隔；）</span></div>
                                </div>
                    </td>
                </tr> 
                </tbody>
            <tfoot>
                <tr>
                    <td>
                        <input id="BTN_Submit" type="submit" value=" 保 存 " runat="server" onserverclick="BTN_Submit_ServerClick" />
                        <input type="hidden" name="BTN_Submit" value="chrome_formsubmit补丁" /> 
                    </td>
                </tr>
            </tfoot>
        </table>
    </div>
    </form>
</body>
</html>
