﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_BalanceLogs, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>会员余额记录列表</title>
   <link href="/css/manager.css" type="text/css" rel="stylesheet"/> 
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
    $(document).ready(function(){
   listInit();
    });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
       <fieldset class="obox"><legend>查询条件 </legend>
            <div class="skin">每页显示<input class="text w20" value="20" id="PageSize" name="PageSize" />条记录 <span class="sp">|</span> 
            <strong>关键字：</strong> 
            <input id="Keyword" type="text" runat="server" class="text w120" />
            <strong>查询列：</strong>
                 <asp:DropDownList ID="FieldList" runat="server" CssClass="ddl">               
                    <asp:ListItem Value="Nickname">会员昵称</asp:ListItem>
                     <asp:ListItem Value="UserId">会员ID</asp:ListItem>       
                </asp:DropDownList>
            <input type="submit" value="查 询" id="BTN_Search" runat="server" onserverclick="BTN_Search_ServerClick" />
      </div>
        </fieldset>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="BalanceId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
            <Columns>                
                <asp:TemplateField HeaderText="操作金额" SortExpression="OperationMoney">
                    <ItemTemplate>
                       <%# Eval("OperationMoney", "{0:C2}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="订单编号" SortExpression="OrderId">
                    <ItemTemplate><a href="ViewOrder.aspx?id=<%# Eval("OrderId")%>" target="_blank">
                        <%# Eval("OrderId")%>
                    </a></ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="所属会员" SortExpression="UserId">
                    <ItemTemplate>
                        <a href="ViewUser.aspx?id=<%# Eval("UserId")%>" target="_blank"><%# Eval("Nickname")%></a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作时间" SortExpression="OperationDate">
                    <ItemTemplate>
                        <%# Eval("OperationDate")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="摘要" SortExpression="Summary">
                    <ItemTemplate>
                        <%# Eval("Summary")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作者" SortExpression="Operator">
                    <ItemTemplate>
                        <%# HTShop.BLL.Util.ReturnOperator(Convert.ToInt32(Eval("Operator")))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="记录时间" SortExpression="AddDate">
                    <ItemTemplate>
                        <%# Eval("AddDate")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemTemplate>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick">
        </UC:Pagination>
        <div class="obox">
        <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" class="ddl">
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
        </div>
        </div>
        </div>
    </form>
</body>
</html>
