﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_Config, HTShop.WebUI" validaterequest="false" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>系统全局配置</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.query.js"></script>
    <script type="text/javascript" src="/scripts/jquery.poshytip.min.js"></script>
     <script type="text/javascript" src="/system_webeditor/kindeditor/kindeditor-min.js"></script>
    <script type="text/javascript" src="/system_webeditor/kindeditor/lang/zh_CN.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(function () {
            setEditorLite('#CopyRightInfo');
            showActionStatus();
            $(".switchbox").switchBox();
            $('.help').poshytip({
                className: 'tip-darkgray',
                bgImageFrameSize: 11,
                offsetX: -25
            });
            $(".item").rowStyle("bg1", "bg2", "bg3", "div.row");
            $(".tip-password").html("（如不修改密码，请保留星号）");
            $("#SmtpServerPassword").val("************");
        });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container w900">
        <div id="flash-msg"></div>
        <table cellspacing="1" cellpadding="0" class="tf">
            <thead>
                <tr>
                    <th>
                        网站全局设置信息
                    </th>
                </tr>
            </thead>
            <tbody>
                <tr>
                    <td class="item">
                        <div class="switchbox">
                            <h3>
                                基本信息设置</h3>
                            <div class="detail">
                                <div class="row clearfix">
                                    <div class="label">
                                        网站地址：</div>
                                    <div class="field">
                                        <input id="SiteUrl" type="text" runat="server" class="text w200" />
                                        <span class="n">(输入本站的网址，必须以http://开头)</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        网站名称：</div>
                                    <div class="field">
                                        <input id="SiteName" type="text" runat="server" class="text w200" />
                                        <span class="n">(输入网站的中英文名称)</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        网站Logo：</div>
                                    <div class="field">
                                      <img id="SiteLogo" style="margin:5px 0;padding:1px;border:solid 1px #ccc;" runat="server" alt="logo" /><br/>
                                        <input id="SiteLogoUpload" class="text" type="file" runat="server" />
                                        <span class="n">(选择一张图片作为网站Logo)</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        网站邮箱：</div>
                                    <div class="field">
                                        <input id="SiteEmail" type="text" runat="server" class="text w200" />
                                        <span class="n">(将公开显示在网站前台页面)</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        热线电话：</div>
                                    <div class="field">
                                        <input id="SiteHotLine" type="text" runat="server" class="text w200" />
                                        <span class="n">(将公开显示在网站前台页面)</span></div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="item">
                        <div class="switchbox">
                            <h3>
                                邮件服务器设置</h3>
                            <div class="detail">
                                <div class="row clearfix">
                                    <div class="label">
                                        SMTP服务器：</div>
                                    <div class="field">
                                        <input id="SmtpServer" type="text" runat="server" class="text w200" /></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        邮箱用户名：</div>
                                    <div class="field">
                                        <input id="SmtpServerUserName" type="text" runat="server" class="text w200" /></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        邮箱密码：</div>
                                    <div class="field">
                                        <input id="SmtpServerPassword" type="text" runat="server" class="text w200" />
                                        <span class="tip-password n"></span>
                                     </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        服务器端口：</div>
                                    <div class="field">
                                        <input id="SmtpServerPort" type="text" runat="server" class="text w40" /></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        安全连接(SSL)：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="SmtpServerEnableSsl" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">是</asp:ListItem>
                                            <asp:ListItem Value="0">否</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="item">
                        <div class="switchbox">
                            <h3>
                                程序功能设置</h3>
                            <div class="detail">
                                <strong>订单功能</strong>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        <a href="javascript:void(0)" title="选择此项后，如果订单付款方式采用的是支付宝，则根据支付宝交易状态结果自动更改订单的交易状态；不选择此项，需要完全手工更改订单状态；"
                                            class="help"></a>支付宝交易状态自动处理订单：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="AlipayOrderProcess" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        <span class="n">（建议开启）</span></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        <a href="javascript:void(0)" title="适用于有大量会员及订单需要多人管理的情形，后台需要添加多个订单管理员，程序会将注册会员随机平分给订单管理员，每个订单管理员只能看到和处理分配给自己的会员、会员订单以及其它信息；"
                                            class="help"></a>将会员平均分配给订单管理员：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="UserDistribution" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        <a href="javascript:void(0)" title="检测会员填写的收货区域是否能够送达（根据送货区域范围进行匹配），此项不建议开启，应根据物流公司配送范围处理；" class="help">
                                        </a>购物车检测会员配送区域：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="CheckDeliveryArea" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        <span class="n">（建议关闭）</span>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        订单是否提供发票：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="EnabledInvoice" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">提供</asp:ListItem>
                                            <asp:ListItem Value="0">不提供</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        提供发票内容：</div>
                                    <div class="field">
                                        <input class="text w160" id="InvoiceType" type="text" runat="server" />
                                        <div class="n">
                                            （本项在提供发票功能开启后生效；多个内容用逗号分隔，前台页面将以选项样式显示）</div>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        订单过期时间：</div>
                                    <div class="field">
                                        <input class="text w40" id="OrderExpired" type="text" runat="server" value="7" /> 天
                                        <div class="n">
                                            （大于过期时间的未支付的订单，将被设置为无效订单）</div>
                                    </div>
                                </div>
                                <strong>商品功能</strong>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        前端商品图片放大镜功能：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="ZoomPic" runat="server" RepeatDirection="Horizontal" RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        <a href="javascript:void(0)" title="填写正则表达式，程序会根据正则表达式自动生成不重复的商品编号，留空则不启用；" class="help"></a>自动生成商品编号表达式：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="AutoProductNo" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        &nbsp;&nbsp;&nbsp;&nbsp;表达式：<input class="text w160" id="AutoProductNoPattern" type="text"
                                            runat="server" />
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        商品低于最小库存量报警：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="MinStocksAlert" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        &nbsp;&nbsp;&nbsp;&nbsp;最小库存量：<input id="MinStocks" type="text" runat="server" class="text w20" />
                                    </div>
                                </div>
                                <strong>商品评论功能</strong>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        商品页面显示审核后的评论：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="ShowComment" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        评论需要审核才能显示：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="AuditingComment" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        <span class="n">（建议开启）</span>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        评论回复需要审核才能显示：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="AuditingReplyComment" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        <span class="n">（建议开启）</span>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        <a href="javascript:void(0)" title="会员购买过商品后才能评价打分，此项用于设置购买商品后最长可评价打分的天数，超过此天数则无法评价打分，设置为-1表示不进行限制；"
                                            class="help"></a>商品评论仅限于购买天数内</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="BuyCommentTimeout" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        &nbsp;&nbsp;&nbsp;&nbsp;购买天数：<input id="CommentTimeout" type="text" runat="server"
                                            class="text w20" value="180" />
                                    </div>
                                </div>
                                <strong>会员功能</strong>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        会员注册后默认的会员组：</div>
                                    <div class="field">
                                        <asp:DropDownList ID="DDL_UserGroups" runat="server">
                                        </asp:DropDownList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        会员注册后赠送积分数：</div>
                                    <div class="field">
                                        <input id="InitPoints" type="text" runat="server" class="text w20" /></div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        会员最多可收藏商品数：</div>
                                    <div class="field">
                                        <input id="FavoriteNum" type="text" runat="server" class="text w20" /></div>
                                </div>
                                <strong>系统功能</strong>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        网站显示在线客服：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="OnlineService" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                        <span class="n">（建议开启 <a href="OnlineService.aspx" target="_blank">点此设置客服信息</a>）</span>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        搜索关键词设置：</div>
                                    <div class="field">
                                        <textarea id="CommendKeywords" style="width:500px;" class="text" cols="10" rows="4" runat="server"></textarea>
                                        <div class="n">（设置网站前台搜索区域显示的热门关键词，多个关键词用英文逗号“,”分隔）</div>
                                    </div>
                                </div>
                                
                               <div class="row clearfix">
                        <div class="label" style="width:200px;">首页META自定义设置：</div>
                        <div class="field">
                        <textarea id="MetaConfig" style="width:500px;" class="text" cols="10" rows="4" runat="server"></textarea>
                        <div class="n">（设置网站首页源代码中META区的内容，有些第三方程序需要在META里添加代码进行身份验证，<br />可填写在此处。）</div>
                        </div>
               </div>
                                
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="item">
                        <div class="switchbox">
                            <h3>
                                搜索引擎优化设置（SEO）</h3>
                            <div class="detail">
                                <strong>标题关键字：</strong><br />
                                <input type="text" id="SeoTitleKeywords" style="width: 80%;" class="text" runat="server" />
                                <div class="n">
                                    （显示在商品页面标题栏中商品标题的后面，如果留空则不显示；建议5个关键字内，而且与商品内容相关，每个关键字用“,”分隔）</div>
                                <div class="s8">
                                </div>
                                <strong>Meta关键字：</strong><br />
                                <textarea id="SeoMetaKeywords" style="width: 80%;" class="text" cols="10" rows="4"
                                    runat="server"></textarea>
                                <div class="n">
                                    （在商品页面原代码的Meta区显示，建议10个关键字内，每个关键字用“,”分隔）</div>
                                <div class="s8">
                                </div>
                                <strong>Meta描述：</strong><br />
                                <textarea id="SeoMetaDescription" style="width: 80%;" class="text" cols="10" rows="4"
                                    runat="server"></textarea>
                                <div class="n">
                                    （在商品页面原代码的Meta区显示，建议30个字内，简述页面功能作用，不要刻意叠加关键字）</div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="item">
                        <div class="switchbox">
                            <h3>
                                图片相关设置</h3>
                            <div class="detail">
                                <div class="tips">
                                    一张原始商品图片上传后，会自动生成三张尺寸的图片，分别出现在商店的以下几个页面：<br />
                                    1：显示在商品列表页、首页商品列表内的图片，使用<strong>中型图</strong>，一般叫做“列表页商品图”；<br />
                                    2：显示在商品详细页内的图片，使用<strong>大型图</strong>；一般叫做“详细页商品图”；<br />
                                    3：显示在商品细节页、购物车、订单等内的<strong>小型图</strong>，一般叫做“缩微图”；</div>
                                <div class="row clearfix">
                                    <div class="label">
                                        图片生成大型图：</div>
                                    <div class="field">
                                        宽度
                                        <input class="text w40" id="BigImgWidth" type="text" runat="server" />px&nbsp;&nbsp;高度
                                        <input class="text w40" id="BigImgHeight" type="text" runat="server" />px
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        图片生成中型图：</div>
                                    <div class="field">
                                        宽度
                                        <input class="text w40" id="MediumImgWidth" type="text" runat="server" />px&nbsp;&nbsp;高度
                                        <input class="text w40" id="MediumImgHeight" type="text" runat="server" />px
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        图片生成小型图：</div>
                                    <div class="field">
                                        宽度
                                        <input class="text w40" id="SmallImgWidth" type="text" runat="server" />px&nbsp;&nbsp;高度
                                        <input class="text w40" id="SmallImgHeight" type="text" runat="server" />px
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        商品图片增加水印：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="AddWaterMark" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">开启</asp:ListItem>
                                            <asp:ListItem Value="0">关闭</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        水印类型：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="RBL_WaterMarkType" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="0">文字水印</asp:ListItem>
                                            <asp:ListItem Value="1">图片水印</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        水印位置：</div>
                                    <div class="field">
                                        <asp:RadioButtonList ID="RBL_WaterMarkPosition" runat="server" RepeatDirection="Horizontal"
                                            RepeatLayout="Flow">
                                            <asp:ListItem Value="1">左上角</asp:ListItem>
                                            <asp:ListItem Value="2">顶部居中</asp:ListItem>
                                            <asp:ListItem Value="3">右上角</asp:ListItem>
                                            <asp:ListItem Value="4">水平靠左</asp:ListItem>
                                            <asp:ListItem Value="5">水平居中</asp:ListItem>
                                            <asp:ListItem Value="6">水平靠右</asp:ListItem>
                                            <asp:ListItem Value="7">左下角</asp:ListItem>
                                            <asp:ListItem Value="8">底部居中</asp:ListItem>
                                            <asp:ListItem Value="9">右下角</asp:ListItem>
                                        </asp:RadioButtonList>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        水印文字：</div>
                                    <div class="field">
                                        <textarea id="WaterMarkText" class="text w160" rows="2" cols="40" runat="server"></textarea>，文字字体：<input
                                            id="WaterMarkFontFamily" type="text" class="text w60" runat="server" />
                                        如果为空，则默认为arial
                                    </div>
                                </div>
                                <div class="s10">
                                </div>
                                <div class="row clearfix">
                                    <div class="label">
                                        水印图片：</div>
                                    <div class="field">
                                        <img id="WaterMarkImage" src="" class="watermarkimg" runat="server" /><input type="hidden"
                                            id="H_Image" runat="server" />
                                        <input id="ImgUpload" class="text" type="file" runat="server" />
                                        &lt; 选择图片
                                    </div>
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="item">
                        <div class="switchbox">
                            <h3>第三方功能集成</h3>
                            <div class="detail">
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        <a href="javascript:void(0)" title="功能：订单实时显示物流信息，支持上百家快递公司；需要填写在www.kuaidi100.com网站申请的Key密匙；<br/>
                        服务介绍：友商快递100是金蝶友商网旗下的网站，提供一站式的快递查询服务，涵盖近百家常用快递公司。" class="help"></a>友商快递100身份Key密匙：</div>
                                    <div class="field">
                                        <input type="text" id="KuaiDi100Key" class="text w200" runat="server" />
                                        <span class="n">（填写在www.kuaidi100.com网站申请的Key密匙）</span>
                                    </div>
                                </div>
                                <div class="row clearfix">
                                    <div class="label" style="width: 200px;">
                                        第三方网站统计分析代码：</div>
                                    <div class="field">
                                        <textarea id="AnalyticsCode" class="text" style="width: 500px;" rows="4" cols="20"
                                            runat="server"></textarea>
                                        <div class="n">
                                            （输入你在第三方网站申请的统计分析服务的代码）</div>
                                    </div>
                                </div>
                                <div class="s5">
                                </div>
                            </div>
                        </div>
                    </td>
                </tr>
                <tr>
                    <td class="item">
                            <h3>网站底部版权信息</h3>
                     <textarea id="CopyRightInfo" cols="100" rows="8" style="width:90%;height:120px;visibility:hidden;" runat="server"></textarea>
                     </td>
                </tr>
            </tbody>
            <tfoot>
                <tr>
                    <td>
                        <input id="BTN_Submit" type="submit" value=" 保 存 " runat="server" onserverclick="BTN_Submit_ServerClick" />
                    </td>
                </tr>
            </tfoot>
        </table>
        <asp:RegularExpressionValidator ID="RegularExpressionValidator1" runat="server" ErrorMessage="请填写完整的网站URL地址，包含Http://"
            ControlToValidate="SiteUrl" Display="None" SetFocusOnError="True" ValidationExpression="http(s)?://([\w-]+\.)+[\w-]+(/[\w- ./?%&=]*)?"></asp:RegularExpressionValidator>
        <asp:ValidationSummary ID="ValidationSummary1" runat="server" ShowMessageBox="True"
            ShowSummary="False"></asp:ValidationSummary>
    </div>
    </form>
</body>
</html>
