﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_CouponList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx" %>
<%@ Register TagPrefix="UC" TagName="ProductCategories" Src="../Controls/ProductCategories.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>优惠券列表</title>
     <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.zh_CN.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
    $(document).ready(function(){
   listInit();
    $("#StartDate").date_input();
	$("#EndDate").date_input(); 
    });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
        <fieldset class="obox"><legend>查询条件 </legend>
           <div class="skin clearfix">
            <div class="filter">
            每页显示<input class="text w20" value="20" id="PageSize" name="PageSize" />条记录 <span class="sp">|</span> 
            <%--类型：<asp:DropDownList ID="DDL_SearchType" runat="server" CssClass="ddl">
            <asp:ListItem Value="">所有</asp:ListItem>
                    <asp:ListItem Value="A">A券</asp:ListItem>
                    <asp:ListItem Value="B">B券</asp:ListItem>
                </asp:DropDownList>&nbsp;&nbsp;--%>
             状态：<asp:DropDownList ID="DDL_Status" runat="server" CssClass="ddl"></asp:DropDownList>&nbsp;&nbsp;
                <asp:CheckBox ID="CB_IsActivated" runat="server" Text="已激活" />&nbsp;&nbsp;
                <asp:CheckBox ID="CB_IsLocked" runat="server" Text="已锁定" />&nbsp;&nbsp;
               <div class="s5"></div>
            关键字：<input id="Keyword" type="text" runat="server" class="text" />
            <asp:DropDownList ID="FieldList" runat="server">
                    <asp:ListItem Value="Nickname">会员昵称</asp:ListItem>
                    <asp:ListItem Value="CouponNo">编号</asp:ListItem>                    
                    <asp:ListItem Value="Summary">摘要</asp:ListItem>
                </asp:DropDownList>&nbsp;
                <input type="submit" value="查 询" id="BTN_Search" runat="server" onserverclick="BTN_Search_ServerClick" />
                </div>
                <div class="add"><a class="add-button" href="GenerateCoupons.aspx">批量创建优惠券</a></div>
            </div>
        </fieldset>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="CouponId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting" AllowSorting="True">
            <Columns>
             <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编号/密码">
                    <ItemTemplate>
                        编号：<%# Eval("CouponNo")%><br/>
                        密码：<%# Eval("CouponPassword")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类型">
                    <ItemTemplate>
                    <%# HTShop.BLL.Coupon.ReturnType(Eval("CouponType").ToString())%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="面值" SortExpression="Money">
                    <ItemTemplate>
                        <%# Eval("Money")%>
                        元 </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="消费金额" SortExpression="ConsumptionAmount">
                    <ItemTemplate><%# Eval("ConsumptionAmount")%>元 </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="有效时间" SortExpression="StartDate">
                    <ItemTemplate>
                        <%# Eval("StartDate", "{0:d}")%>
                        ～
                        <%# Eval("EndDate", "{0:d}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="绑定会员">
                    <ItemTemplate>
                        <%# Eval("UserId").ToString()!="0"?"<a href=viewuser.aspx?id="+Eval("UserId").ToString()+" target=_blank>"+Eval("Nickname")+"</a>":""%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作者" SortExpression="Operator">
                    <ItemTemplate>
                        <%# HTShop.BLL.Util.ReturnOperator(Convert.ToInt32(Eval("Operator")))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="创建时间" SortExpression="AddDate">
                    <ItemTemplate>
                        <%# Eval("AddDate")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="激活状态" SortExpression="IsActivated">
                    <ItemTemplate>
                        <%# Eval("IsActivated").ToString()=="True"?"<span class=red>已激活</span>":"未激活"%>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="使用状态" SortExpression="Status">
                    <ItemTemplate>
                        <%# Eval("IsLocked").ToString()=="True"?"<span class=red>已锁定</span>":"未锁定"%> <%# HTShop.BLL.Coupon.ReturnStatus(Eval("Status").ToString())%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemTemplate>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick">
        </UC:Pagination>
        <div class="obox">
        <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" class="ddl">
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
        </div>
        </div>
        </div>
    </form>
</body>
</html>
