﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_DeliveryAreaList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>货到付款地区管理</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
$(document).ready(function(){
	$(".list").rowStyle("tr1","tr2","tr3");
});
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
     <fieldset class="obox"><legend>查询条件 </legend>
            <div class="skin">每页显示<input class="text w20" value="20" id="PageSize"/>条记录 <span class="sp">|</span>             
                按关键字查询：<input id="Keyword" type="text" runat="server" class="text" />
                <asp:DropDownList ID="FieldList" runat="server" CssClass="ddl">
                    <asp:ListItem Value="DistrictName">地区名称</asp:ListItem>
                    <asp:ListItem Value="CityName">城市名称</asp:ListItem>
                </asp:DropDownList>&nbsp;
                <button id="BTN_Search" runat="server" type="submit" onserverclick="BTN_Search_Click">搜 索</button>
            </div>
        </fieldset>
    <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowPaging="True"
            AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据"
            DataKeyNames="DistrictId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="地区">
                    <ItemTemplate>
                        <%# Eval("DistrictName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="所属城市">
                    <ItemTemplate>
                        <%# Eval("CityName")%>
                    </ItemTemplate>
                </asp:TemplateField>
               <asp:TemplateField HeaderText="可以配送">
                    <ItemTemplate>
                    <%# Eval("IsDelivery").ToString()=="True"?"<img src=/images/ico_right.png />":""%>                    
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemTemplate>
                            <asp:LinkButton id="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="80px" />
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick">
        </UC:Pagination>
        <div class="obox">
        <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" class="ddl">
             <option value="SetCOD">支持货到付款</option>
                <option value="CancelCOD">不支持货到付款</option>
                <option value="SetDelivery">可以配送</option>
                <option value="CancelDelivery">不可配送</option>
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
        </div>
        </div>
        </div>
    </form>
</body>
</html>
