﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_DeliveryList, HTShop.WebUI" validaterequest="false" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
 <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>配送方式管理</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
  
    <script type="text/javascript">
        $(document).ready(function() {
            bindSort();
            $(".list").rowStyle("tr1", "tr2", "tr3");
        });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="DeliveryId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
               <asp:TemplateField HeaderText="ID">
                    <ItemTemplate>
                       <%# Eval("DeliveryId")%>
                    </ItemTemplate>
                    <ItemStyle Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="名称">
                    <ItemTemplate>
                        <%# Eval("DeliveryName")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" />
                </asp:TemplateField> 
                <asp:TemplateField HeaderText="物流类型">
                    <ItemTemplate>
                        <%# Eval("DeliveryType")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="配送费用">
                    <ItemTemplate>
                        首重<%# Eval("FirstWeightPrice", "{0:C2}")%>，续重<%# Eval("SecondWeightPrice", "{0:C2}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="排序">                    
                    <ItemTemplate>
                     <a id="sort_up_<%# Eval("DeliveryId")%>" href="DeliveryList.aspx?sort=1&id=<%# Eval("DeliveryId")%>" class="move-up">上移</a>
                     <a id="sort_down_<%# Eval("DeliveryId")%>" href="DeliveryList.aspx?sort=0&id=<%# Eval("DeliveryId")%>" class="move-down">下移</a>                       
                      </ItemTemplate>
                    <ItemStyle Width="60px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态">
                    <ItemTemplate>
                    <%# Eval("Enabled").ToString() == "True" ? "启用" : "<span class=red>禁用</span>"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="支持货到付款">
                    <ItemTemplate>
                    <%# Eval("CashOnDelivery").ToString()=="True"?"<img src=/images/ico_right.png />":""%>  
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemTemplate>
                        <a href="AddDelivery.aspx?id=<%#Eval("DeliveryId")%>" class="a_blue">
                            编辑</a>
                            <asp:LinkButton id="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="65px" />
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        
      <div class="obox">
         <div class="skin clearfix">
         <div class="filter">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" class="ddl">
            <option value="Enabled">启用</option>
            <option value="CannelEnabled">禁用</option>
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="btn_ManagerState" runat="server" Text="确定" OnClientClick="return showConfirm();"
                OnClick="btn_ManagerState_Click" />
                </div>
                <div class="add"><a class="add-button" href="AddDelivery.aspx">增加配送方式</a></div>
              </div>
        </div>
</div>
    </form>
</body>
</html>
