﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_MessageList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>站内短消息管理</title>
     <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            $(".list").rowStyle("tr1", "tr2", "tr3");
            $(".add-button").colorbox({ width: "600px", height: "420px", iframe: true });
            $(".viewdetail").colorbox({ width: "600px", height: "400px", iframe: true });
        });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
    <fieldset class="obox"><legend>查询条件 </legend>
           <div class="skin clearfix">
        <div class="filter">每页显示<input class="text w20" value="20" id="PageSize" runat="server" />条记录 
            <span class="sp">|</span> 筛选条件：
            <asp:DropDownList ID="DDL_MsgType" runat="server"></asp:DropDownList>
              <span class="sp">|</span>           
                <strong>关键字：</strong> <input id="Keyword" type="text" runat="server" class="text" />
             <strong>查询列：</strong>
                <asp:DropDownList ID="FieldList" runat="server">
                    <asp:ListItem Value="Receiver">会员名</asp:ListItem>
                    <asp:ListItem Value="Title">标题</asp:ListItem>
                    <asp:ListItem Value="Content">内容</asp:ListItem>
                </asp:DropDownList>&nbsp;
                <button id="BTN_Search" runat="server" type="submit" onserverclick="BTN_Search_Click">查 询</button>
            </div>
            <div class="add"><a class="add-button" href="AddMessage.aspx">发送新消息</a></div>
            </div>
        </fieldset>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="MsgId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="类型" SortExpression="MsgType">
                    <ItemTemplate>
                        <%# HTShop.BLL.Message.ReturnMsgType(int.Parse(Eval("MsgType").ToString()))%>
                    </ItemTemplate>
                    <ItemStyle Width="60px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="接收者" SortExpression="Receiver">
                    <ItemTemplate>
                        <%# Eval("ReceiverName").ToString()=="所有会员"?Eval("ReceiverName").ToString():"<a href=\"ViewUser.aspx?id="+Eval("Receiver").ToString()+"\" target=\"_blank\">"+Eval("ReceiverName").ToString()+"</a>"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="标题">
                    <ItemTemplate>
                    <%# Eval("Title")%>
                        <%--<a class="viewdetail" href="ViewMessage.aspx?id=<%# Eval("MsgId")%>"><%# Eval("Title")%></a>--%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="内容">
                    <ItemTemplate>
                        <%# Eval("Content")%>
                    </ItemTemplate>
                </asp:TemplateField>  
                <asp:TemplateField HeaderText="日期">
                    <ItemStyle Width="120px" />
                    <ItemTemplate>
                        <%# Eval("AddDate")%>
                    </ItemTemplate>
                </asp:TemplateField>                
                <asp:TemplateField>
                    <ItemStyle HorizontalAlign="Center" Width="80px"></ItemStyle>
                    <ItemTemplate>
                   <%-- <a class="viewdetail" href="ViewMessage.aspx?id=<%# Eval("MsgId")%>">查看</a>&nbsp;&nbsp;--%>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"
                            OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:Pagination>
        <div class="obox">
         <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" class="ddl">           
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();"
                OnClick="BTN_ManagerStatus_Click" />
                </div>
        </div>
        </div>
    </form>
</body>
</html>
