﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_OnlinePayLogs, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>订单在线支付日志</title>
     <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
     <script type="text/javascript" src="/scripts/jquery.date_input.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.zh_CN.js"></script>
    <script type="text/javascript">
        $(document).ready(function () {
            //设置datetime
            $("#StartDate").date_input();
            $("#EndDate").date_input();
            $(".list").rowStyle("tr1", "tr2", "tr3");

        });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
   <fieldset class="obox">
   <legend>查询条件 </legend>
            <div class="skin">
                按日期查询： 从<input class="text w80" id="StartDate" type="text" runat="server" />
                至<input class="text w80" id="EndDate" type="text" runat="server" />
                <div class="s5"></div>
                按关键字查询：<input id="Keyword" type="text" runat="server" class="text" />
                <asp:DropDownList ID="FieldList" runat="server" CssClass="ddl">
                    <asp:ListItem Value="TradeNo">支付接口交易号</asp:ListItem>
                    <asp:ListItem Value="OrderNo">订单交易号</asp:ListItem>
                </asp:DropDownList>&nbsp;
                每页<input class="text w20" value="20" id="PageSize" runat="server" />条记录
                <button id="BTN_Search" runat="server" type="submit" onserverclick="BTN_Search_Click">查询</button>
            </div>
        </fieldset>
       
         
                <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="PayId" PageSize="20" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID" SortExpression="PayId">
                    <ItemTemplate>
                        <%# Eval("PayId")%>
                    </ItemTemplate>
                </asp:TemplateField>               
                <asp:TemplateField HeaderText="订单交易号" SortExpression="OrderNo">
                    <ItemTemplate>
                        <%# Eval("OrderNo")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="支付金额" SortExpression="TotalFee">
                    <ItemTemplate>
                        <span class="price"><%# Eval("TotalFee", "{0:C2}")%></span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="支付接口" SortExpression="PayInterface">
                    <ItemTemplate>
                        <%# Eval("PayInterface")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="接口类型" SortExpression="Service">
                    <ItemTemplate>
                        <%# Eval("Service")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="支付接口交易号" SortExpression="TradeNo">
                    <ItemTemplate>
                        <%# Eval("TradeNo")%>
                    </ItemTemplate>
                </asp:TemplateField>    
                <asp:TemplateField HeaderText="记录时间" SortExpression="AddDate">
                    <ItemTemplate>
                       <%# Eval("AddDate")%>
                    </ItemTemplate>
                </asp:TemplateField>             
                <asp:TemplateField HeaderText="交易状态" SortExpression="TradeStatus">
                    <ItemTemplate>
                       <%# Eval("TradeStatus")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" Width="60px" />
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick">
        </UC:Pagination>
                
              
        <div class="obox">
            <div class="skin">
                <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();"/>
                全选 | 功能操作：
                <select id="ManageStatus" name="ManageStatus">
                    <option value="Delete">删除</option>
                </select>
                <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
         </div>
        </div>
        
       </div>
    </form>
</body>
</html>
