﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_OnlineService, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>在线客户服务设置</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
   <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
<script type="text/javascript" src="/scripts/jquery.query.js"></script>    
<script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(function () {
            showActionStatus();
            bindSort();
            listInit();
            $("#ServiceType").bind("change", function () { changeServiceType(); });
            changeServiceType();
            if ($.query.get("id") != "") {
                var v = $("#H_ServiceStyle").val();
                $(":radio[value='" + v + "']").attr("checked", "checked");
            }
        });



        function changeServiceType() {
            if ($("#ServiceType option:selected").val() == "qq") {
                $("#row_style").show();
                $(".pic_style").hide();
                $("#ServiceStyle_qq").show();
                $("#ServiceStyle_qq :radio[name='ServiceStyle']:first").attr("checked", "checked");
                $("#svcode").html("QQ号码");
                $("#svremark").html("只能填写1个QQ号码；");
            }
            if ($("#ServiceType option:selected").val() == "msn") {
                $("#row_style").show();
                $(".pic_style").hide();
                $("#ServiceStyle_msn").show();
                $("#ServiceStyle_msn :radio[name='ServiceStyle']:first").attr("checked", "checked");
                $("#svcode").html("MSN号码");
                $("#svremark").html("只能填写1个MSN号码；");
            }
            if ($("#ServiceType option:selected").val() == "wangwang") {
                $("#row_style").show();
                $(".pic_style").hide();
                $("#ServiceStyle_wangwang").show();
                $("#ServiceStyle_wangwang :radio[name='ServiceStyle']:first").attr("checked", "checked");
                $("#svcode").html("阿里旺旺号码");
                $("#svremark").html("只能填写1个阿里旺旺号码；");
            }
            if ($("#ServiceType option:selected").val() == "skype") {
                $("#row_style").show();
                $(".pic_style").hide();
                $("#ServiceStyle_skype").show();
                $("#ServiceStyle_skype :radio[name='ServiceStyle']:first").attr("checked", "checked");
                $("#svcode").html("Skype语音电话号码");
                $("#svremark").html("只能填写1个Skype语音电话号码；");
            }
            else if ($("#ServiceType option:selected").val() == "page") {
                $("#row_style").hide();
                $("#svcode").html("在线代码");
                $("#svremark").html("请填写您在第三方在线网页客服申请的代码；");
            }
        }
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container w900">
    <div id="flash-msg"></div>
        <table cellspacing="1" cellpadding="0" class="tf">
            <thead>
                <tr>
                    <th colspan="2">添 加 在 线 客 服</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td class="label">客服类型：</td>
                <td class="field">
                    <asp:DropDownList ID="ServiceType" runat="server">
                    <asp:ListItem Value="qq" Selected="True">QQ客服</asp:ListItem>
                    <asp:ListItem Value="msn">MSN客服</asp:ListItem>
                    <asp:ListItem Value="wangwang">阿里旺旺客服</asp:ListItem>
                     <asp:ListItem Value="skype">Skype语音电话</asp:ListItem>
                    <asp:ListItem Value="page">第三方网页客服</asp:ListItem>
                    </asp:DropDownList></td>
            </tr>
            <tr id="row_style">
                <td class="label">客服图片样式：</td>
                <td class="field">
                
                <span id="ServiceStyle_qq" class="pic_style" style="display:none;">
                <input id="ServiceStyle_10" type="radio" name="ServiceStyle" value="51" /><label for="ServiceStyle_10"><img src="/images/olservice/style_51.jpg"></label>
                  <input id="ServiceStyle_0" type="radio" name="ServiceStyle" value="41" /><label for="ServiceStyle_0"><img src="/images/olservice/style_41.jpg"></label>
                  <input id="ServiceStyle_1" type="radio" name="ServiceStyle" value="42" /><label for="ServiceStyle_1"><img src="/images/olservice/style_42.jpg"></label>
                  <input id="ServiceStyle_2" type="radio" name="ServiceStyle" value="43" /><label for="ServiceStyle_2"><img src="/images/olservice/style_43.jpg"></label>
                  <input id="ServiceStyle_3" type="radio" name="ServiceStyle" value="44" /><label for="ServiceStyle_3"><img src="/images/olservice/style_44.jpg"></label>
                  <input id="ServiceStyle_4" type="radio" name="ServiceStyle" value="45" /><label for="ServiceStyle_4"><img src="/images/olservice/style_45.jpg"></label><br />
                  <input id="ServiceStyle_5" type="radio" name="ServiceStyle" value="46" /><label for="ServiceStyle_5"><img src="/images/olservice/style_46.jpg"></label>
                  <input id="ServiceStyle_6" type="radio" name="ServiceStyle" value="47" /><label for="ServiceStyle_6"><img src="/images/olservice/style_47.jpg"></label>
                  <input id="ServiceStyle_7" type="radio" name="ServiceStyle" value="48" /><label for="ServiceStyle_7"><img src="/images/olservice/style_48.jpg"></label>
                  <input id="ServiceStyle_8" type="radio" name="ServiceStyle" value="49" /><label for="ServiceStyle_8"><img src="/images/olservice/style_49.jpg"></label>
                  <input id="ServiceStyle_9" type="radio" name="ServiceStyle" value="50" /><label for="ServiceStyle_9"><img src="/images/olservice/style_50.jpg"></label>
                  
                </span>
                
                <span id="ServiceStyle_msn" class="pic_style" style="display:none;">
                  <input id="ServiceStyle_11" type="radio" name="ServiceStyle" value="60" checked="checked" /><label for="ServiceStyle_11"><img src="/images/olservice/style_60.jpg"></label>
                </span>
                
                <span id="ServiceStyle_wangwang" class="pic_style" style="display:none;">
                  <input id="ServiceStyle_12" type="radio" name="ServiceStyle" value="70" checked="checked" /><label for="ServiceStyle_12"><img src="/images/olservice/style_70.jpg"></label>
                </span>
               
                <input id="H_ServiceStyle" type="hidden" runat="server" />
                </td>
            </tr>
            <tr>
                <td class="label">客服名称/标题：</td>
                <td class="field">
                    <input id="ServiceName" type="text" runat="server" class="text w120" /></td>
            </tr>
            <tr>
                <td class="label"><span id="svcode">QQ号码</span>：</td>
                <td class="field">
                <input id="ServiceCode" type="text" runat="server" class="text w200" />
                <span id="svremark" class="n">只能填写1个QQ号码；</span>
                </td>
            </tr>
            <tr>
                <td class="label">显示顺序号：</td>
                <td class="field">
                    <input id="DisplaySequence" class="w40" type="text" runat="server" value="1"/></td>
            </tr>
            <tr>
                <td class="label">属性：</td>
                <td class="field">
                    <asp:CheckBox ID="CB_Enabled" runat="server" Text="启用" Checked="true">
                    </asp:CheckBox></td>
            </tr>
            </tbody>
            <tfoot>
            <tr>
                <td colspan="2">
                    <asp:Button ID="BTN_Submit" runat="server" Text=" 保 存 " CommandName="Add" OnClick="BTN_Submit_Click"></asp:Button></td>
            </tr>
            </tfoot>
        </table>

        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowPaging="True" AllowSorting="True" AutoGenerateColumns="False"  CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="ServiceId" PageSize="20" PageIndex="1"  OnRowDeleting="GV_List_RowDeleting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ＩＤ">
                    <ItemTemplate>
                        <%# Eval("ServiceId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="客服类型">
                    <ItemTemplate>
                        <%# Eval("ServiceType")%>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="客服名称/标题">
                    <ItemTemplate>
                        <%# Eval("ServiceName")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="客服代码">
                    <ItemTemplate>
                        <%# Eval("ServiceCode")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" />
                </asp:TemplateField>               
                <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                     <a id="sort_up_<%# Eval("ServiceId")%>" href="OnlineService.aspx?sort=1&id=<%# Eval("ServiceId")%>" class="move-up">上移</a>
                     <a id="sort_down_<%# Eval("ServiceId")%>" href="OnlineService.aspx?sort=0&id=<%# Eval("ServiceId")%>" class="move-down">下移</a>                    
                      <span class="g"><%# Eval("DisplaySequence")%></span>
                    </ItemTemplate>
                    <ItemStyle Width="60px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="属性">
                    <ItemTemplate>
                        <%# Eval("Enabled").ToString() == "True" ? "启用" : "禁用"%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="40px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemTemplate><a href="OnlineService.aspx?id=<%#Eval("ServiceId")%>" class="a_blue">编辑</a>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="80px" />
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick">
        </UC:Pagination>
        
        <asp:ValidationSummary ID="ValidationSummary2" runat="server" ShowSummary="False" ShowMessageBox="True">
        </asp:ValidationSummary>
        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="客服名称/标题必须填写！" ControlToValidate="ServiceName" Display="None"></asp:RequiredFieldValidator>
        <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="客服代码必须填写！" ControlToValidate="ServiceCode" Display="None"></asp:RequiredFieldValidator>
        </div>
    </form>
</body>
</html>
