﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_OrderFormList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="ManagerQuickPager" Src="../Controls/ManagerQuickPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>订单列表</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.zh_CN.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            //设置datetime
            $("#StartDate").date_input();
            $("#EndDate").date_input();
            $(".list").rowStyle("tr1", "tr2", "tr3");
            //$.tabs('tab-container', 1);
            if (document.URL.indexOf("?status=all") > 0) {
                $("#tab-container .tab-hd ul>li:nth-child(2)").addClass("current");
            }
            else if (document.URL.indexOf("?status=WAIT_CONFIRM") > 0) {
                $("#tab-container .tab-hd ul>li:nth-child(1)").addClass("current");
            }
            else if (document.URL.indexOf("?status=WAIT_BUYER_PAY") > 0) {
                $("#tab-container .tab-hd ul>li:nth-child(3)").addClass("current");
            }            
            else if (document.URL.indexOf("?status=WAIT_SELLER_SEND_GOODS") > 0) {
                $("#tab-container .tab-hd ul>li:nth-child(4)").addClass("current");
            }
            else if (document.URL.indexOf("?status=WAIT_BUYER_CONFIRM_GOODS") > 0) {
                $("#tab-container .tab-hd ul>li:nth-child(5)").addClass("current");
            }
            else if (document.URL.indexOf("?status=TRADE_FINISHED") > 0) {
                $("#tab-container .tab-hd ul>li:nth-child(6)").addClass("current");
            }
            else if (document.URL.indexOf("?status=TRADE_CLOSED") > 0) {
                $("#tab-container .tab-hd ul>li:nth-child(7)").addClass("current");
            }

            var url = "/XHttpService/XHR_Admin.ashx?t=GetOrderCount";
            $.getJSON(url, function(data) {
                $.each(data, function(i, o) {
                $("#" + o.name).append("<em>(" + o.count + ")</em>");
                });
            });
        });
    </script>
     <style type="text/css">
     #tab-container{ margin:5px auto;border:none;width:100%;}
    .tab-hd,.tab-bd{margin:0 auto;width: 90%;}
    .tab-hd a em{font-size:12px; font-weight:normal; font-style:normal;}
    .tab-bd{border:none;border-top: solid 1px #9DB0BC;}
    .tab-bd table{margin-top:5px;}
    .list{width: 100%;}
    .list td{height:30px;}
    </style>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
        <fieldset class="obox"><legend>查询条件 </legend>
            <div class="skin">
            <strong>状态：</strong><asp:DropDownList ID="DDL_OrderState" runat="server"></asp:DropDownList>
            <span class="sp">|</span><strong>金额：</strong> <input class="text w40" id="StartMoney" type="text" runat="server" /> 至 <input class="text w40" id="EndMoney" type="text" runat="server" />元
            <span class="sp">|</span><strong>日期：</strong> <input class="text w80" id="StartDate" type="text" runat="server" /> 至 <input class="text w80" id="EndDate" type="text" runat="server" />
            <div class="s5"></div>
                <strong>关键字：</strong> <input id="Keyword" type="text" runat="server" class="text w120" />
                <span class="sp">|</span> <strong>查询列：</strong>
                <asp:DropDownList ID="FieldList" runat="server" CssClass="ddl">
                <asp:ListItem Value="OrderNumber">订单号</asp:ListItem>       
                    <asp:ListItem Value="Nickname">会员昵称</asp:ListItem>
                    <asp:ListItem Value="Ship_RealName">收货人姓名</asp:ListItem>
                    <asp:ListItem Value="Ship_Tel">收货人电话</asp:ListItem>
                    <asp:ListItem Value="Ship_Address">收货人联系地址</asp:ListItem>
                    <asp:ListItem Value="Ship_Email">收货人电子邮件</asp:ListItem>
                </asp:DropDownList>
                &nbsp;&nbsp;每页<input class="text w20" value="20" id="PageSize" name="PageSize"/>条记录
                <button id="BTN_Search" runat="server" type="submit" onserverclick="BTN_Search_Click"> 查 询 </button>
            </div>
        </fieldset>
         <div id="tab-container" class="clearfix">
            <div class="tab-hd clearfix">
                <ul>                    
                    <li style="margin-left:10px;"><a href="OrderFormList.aspx?status=WAIT_CONFIRM" id="WAIT_CONFIRM">等待确认</a></li>
                    <li><a href="OrderFormList.aspx?status=all" id="ALL">所有状态</a></li>
                    <li><a href="OrderFormList.aspx?status=WAIT_BUYER_PAY" id="WAIT_BUYER_PAY">等待付款</a></li>                    
                    <li><a href="OrderFormList.aspx?status=WAIT_SELLER_SEND_GOODS" id="WAIT_SELLER_SEND_GOODS">正在配货</a></li>
                    <li><a href="OrderFormList.aspx?status=WAIT_BUYER_CONFIRM_GOODS" id="WAIT_BUYER_CONFIRM_GOODS">等待收货</a></li>
                    <li><a href="OrderFormList.aspx?status=TRADE_FINISHED" id="TRADE_FINISHED">交易完成</a></li>
                    <li><a href="OrderFormList.aspx?status=TRADE_CLOSED" id="TRADE_CLOSED">订单取消</a></li>
                </ul>
            </div>
            <div class="tab-bd">
                <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="OrderId" PageSize="20" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID" SortExpression="OrderId">
                 <ItemTemplate>
                        <%# Eval("OrderId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" Width="40px" />
                 </asp:TemplateField>
                <asp:TemplateField HeaderText="订单号" SortExpression="OrderNumber">
                    <ItemTemplate>
                        <a href="ViewOrder.aspx?id=<%# Eval("OrderId")%>" target="_blank"><%# Eval("OrderNumber")%></a>
                    </ItemTemplate>
                    <ItemStyle Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="下单时间" SortExpression="AddDate">
                    <ItemTemplate>
                        <%# Eval("AddDate")%>
                    </ItemTemplate>
                    <ItemStyle Width="130px"></ItemStyle>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="会员" SortExpression="UserId">
                    <ItemTemplate>
                        <%# Eval("UserId").ToString() == "0" ? "非会员" : "<a href=ViewUser.aspx?id=" + Eval("UserId").ToString() + " target=_blank class=a_blue>" + Eval("Nickname").ToString() + "</a>"%>
                    </ItemTemplate>
                     <ItemStyle Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="收货人" SortExpression="Ship_RealName">
                    <ItemTemplate>
                        <%# Eval("Ship_RealName")%>
                    </ItemTemplate>
                     <ItemStyle Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="订单金额" SortExpression="RealPrice">
                    <ItemTemplate>
                        <span class="price"><%# Eval("RealPrice", "{0:C2}")%></span>
                    </ItemTemplate>
                     <ItemStyle Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="付款方式" SortExpression="PaymentId">
                    <ItemTemplate>
                        <%# Eval("Name")%>
                    </ItemTemplate>
                    <ItemStyle Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="配送方式" SortExpression="DeliveryId">
                    <ItemTemplate>
                        <%# Eval("DeliveryName")%>
                    </ItemTemplate>
                    <ItemStyle Width="100px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="订单状态" SortExpression="TradeStatus">
                    <ItemTemplate>
                        <%#HTShop.BLL.Order.ReturnTradeStatus(Eval("TradeStatus").ToString())%>
                    </ItemTemplate>
                    <ItemStyle Width="80px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                        <a href="ViewOrder.aspx?id=<%# Eval("OrderId")%>" target="_blank">查看</a>
                                        </ItemTemplate>
                                        <ItemStyle HorizontalAlign="Center" Width="50px" />
                                    </asp:TemplateField>  
            </Columns>
        </asp:GridView>
        <UC:ManagerQuickPager ID="Pager" runat="server"></UC:ManagerQuickPager>
       
            </div>
         </div>
        <div class="obox">
            <div class="skin">
                <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
                全选 | 功能操作：
                <select id="ManageStatus" name="ManageStatus" onchange="changeManageStatus()">
                    <option value="Delete">删除订单</option>
                    <option value="ChangeTradeStatus">更改订单状态</option>
                </select>
                <select id="TradeStatus" name="TradeStatus" style="display: none;" runat="server"></select>
                <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
            </div>
        </div>
       </div>
    </form>
</body>
</html>
