﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_PointConfig, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>积分设置</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.validate.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.query.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
     <script type="text/javascript">
         function changePointType() {
             if ($("input[name='PointType']:checked").val() == "Order") {
                 $("#row1").show();
                 $("#row2").show();
             } else if ($("input[name='PointType']:checked").val() == "Product") {
                 $("#row1").hide();
                 $("#row2").show();
             } else {
                 $("#row1").hide();
                 $("#row2").hide();
             }
         }

         $(document).ready(function() {
             $("input[name='PointType']").bind("click", function() { changePointType(); });
             changePointType();
             showActionStatus();

             $("#form1").validate({

                 rules: {
                 PointRate: { required: true, number: true },
                     CouponRate: { required: true, digits: true },
                     CommentPoint: { required: true, digits: true }
                 },

                 submitHandler: function(form) {
                     $(form).find(":submit").attr("disabled", true).attr("value", "处理中...");
                     form.submit();
                 }
             });
         });
        
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server" class="validate">
    <div class="container">
    <div id="flash-msg"></div>
    <table cellspacing="1" cellpadding="0" class="tf">
    <thead>
            <tr>
                <th colspan="2">积分设置</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td class="label">积分计算方式：</td>
                <td class="field">
                <asp:RadioButtonList ID="PointType" runat="server">
                <asp:ListItem Value="None">不使用积分</asp:ListItem>
                <asp:ListItem Value="Order">按订单商品总价格计算积分</asp:ListItem>
                <asp:ListItem Value="Product">为商品单独设置积分</asp:ListItem>
                </asp:RadioButtonList>
               
                </td>
            </tr>
            <tr id="row1">
                <td class="label">积分换算比率：</td>
                <td class="field">
                    <input id="PointRate" name="PointRate" type="text" class="w40" runat="server" />
                    <div class="n">（此项针对“按订单商品总价格计算积分”设置，计算公式为：订单所得积分 = 订单商品总价格 X 积分换算比率）</div>
                </td>
            </tr>
            <tr id="row2">
                <td class="label">积分兑换优惠券：</td>
                 <td class="field">
                    <asp:CheckBox ID="CB_ExchangeCoupon" runat="server" Text="允许积分兑换优惠券"  />
                    ，积分兑换优惠券比例：<input id="CouponRate" name="CouponRate" type="text" class="w40" runat="server" />
                    <div class="n">（允许积分兑换优惠券：会员可以通过“会员中心”->“我的积分”兑换面值10元、30元、50元的优惠券；<br/>
                    兑换比例：优惠券固定比为1，此处填写10则表示为 优惠券1元:10积分，假如优惠券面值为10元，则兑换积分为100分）</div>
                </td>
            </tr>
            <tr id="row3">
                <td class="label">评论赠送积分：</td>
                <td class="field">
                    <input id="CommentPoint" name="CommentPoint" type="text" class="w40" runat="server" />
                    <div class="n">（商品评论通过审核后系统自动赠送给会员的积分）</div>
                </td>
            </tr>
            </tbody>
            <tfoot>
            <tr>
                <td colspan="2">
                    <asp:Button ID="BTN_Submit" runat="server" Text=" 保 存 " CommandName="Add" OnClick="BTN_Submit_Click"></asp:Button>
                    <input type="hidden" name="BTN_Submit" value="chrome_formsubmit补丁" /> 
                </td>
            </tr>
            </tfoot>
            </table>
            </div>
    </form>
</body>
</html>
