﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_ProductCategories, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="ProductCategories" Src="../Controls/ProductCategories.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>商品分类管理</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>   
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
     <script type="text/javascript" src="/scripts/jquery.query.js"></script> 
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
            bindSort();
            $(".list").rowStyle("tr1", "tr2", "tr3");
            //$(".list tr.sub0:odd").css("background-color", "#F2F2F2");
            $("#ConvertCategory").colorbox({ width: "500px", height: "260px", iframe: true });
            showActionStatus(); 
        });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
    <asp:ScriptManager ID="ScriptManager1" runat="server">
    </asp:ScriptManager>
     <div id="flash-msg"></div>
    <table cellspacing="1" cellpadding="0" class="tf">
        <thead>
            <tr>
                <th colspan="2">
                    分 类 管 理
                </th>
            </tr>
        </thead>
        <tbody>
            <tr>
                <td class="label">
                    上级分类：
                </td>
                <td class="field">
                    <UC:ProductCategories ID="ProductCategories" runat="server" ShowLevel="2" FunOption="AddCategory">
                    </UC:ProductCategories>
                </td>
            </tr>
            <tr>
                <td class="label">
                    分类名称：
                </td>
                <td class="field">
                    <asp:TextBox ID="CategoryName" runat="server" Cssclass="text" Width="200px"></asp:TextBox>
                </td>
            </tr>
            
            <tr>
                <td class="label">
                    商品类型：
                </td>
                <td class="field">
                    <asp:DropDownList ID="DDL_Types" runat="server">
                    </asp:DropDownList>
                </td>
            </tr>
            <tr>
                <td class="label">
                    商品规格：
                </td>
                <td class="field">
                    <asp:CheckBoxList ID="CBL_ItemSpecs" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                    </asp:CheckBoxList>
                </td>
            </tr>
            <tr>
                <td class="label">
                    分类Url：
                </td>
                <td class="field">
                <input id="Url" type="text" class="text w300" runat="server" />
                <div class="n">（定制分类栏目的页面地址，填写后，前台分类链接将使用此地址，可以填写绝对或相对路径，如：/baobao.aspx 或 http://demo.htshop.cn/baobao.aspx）</div>
                </td>
            </tr>
            <tr>
                <td class="label">
                    分类属性：
                </td>
                <td class="field">
                    <asp:CheckBox ID="CB_Commend" runat="server" Text="推荐" />
                </td>
            </tr>
           <tr>
                <td class="label">显示顺序号：</td>
                <td class="field">
                    <input id="DisplaySequence" class="w40" type="text" runat="server" value="1"/></td>
            </tr>
        </tbody>
        <tfoot>
            <tr>
                <td colspan="2">
                    <asp:Button ID="BTN_Submit" runat="server" OnClick="BTN_Submit_Click" Text=" 保 存 "
                        CommandName="Add" ValidationGroup="add" />
                </td>
            </tr>
        </tfoot>
    </table>
    <div class="s10">
    </div>
   <fieldset class="obox"><legend>分类查找、转换</legend>
            <div class="skin">
            查找：输入分类名称：<input id="Keyword" type="text" runat="server" class="text" />
            <input type="submit" value="查 询" id="BTN_Search" runat="server" onserverclick="BTN_Search_ServerClick" validationgroup="search" />
            <span class="sp">|</span> <a id="ConvertCategory" class="convert" href="ConvertProductCategory.aspx">将分类商品转换到其它分类中</a>
    </div>
   </fieldset>
    <table id="CategoryTable" cellspacing="0" cellpadding="0" class="list" runat="server">
        <tr>
            <th>
                选择
            </th>
            <th>
                分类ID
            </th>
            <th>
                分类名称
            </th>
            <th>
                类型
            </th>
             <th>
                规格
            </th>
            <th>
                显示顺序[正序]
            </th>
            <th>
                操作
            </th>
        </tr>
    </table>
    <div class="system-msg">
        <asp:Literal ID="SystemMsg" runat="server"></asp:Literal></div>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="分类名称不能为空！"
        ControlToValidate="CategoryName" Display="None" SetFocusOnError="True" ValidationGroup="add"></asp:RequiredFieldValidator>
    <asp:ValidationSummary ID="ValidationSummary2" runat="server" ShowMessageBox="True"
        ShowSummary="False" ValidationGroup="add"></asp:ValidationSummary>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ErrorMessage="分类名称不能为空！"
        ControlToValidate="Keyword" Display="None" SetFocusOnError="True" ValidationGroup="search"></asp:RequiredFieldValidator>
    <asp:ValidationSummary ID="ValidationSummary1" runat="server" ShowMessageBox="True"
        ShowSummary="False" ValidationGroup="search"></asp:ValidationSummary>
        </div>
    </form>
</body>
</html>
