﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_ProductCommentReplies, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>评论回复管理</title>
     <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
    $(document).ready(function(){
    $(".list").rowStyle("tr1", "tr2", "tr3");
    $(".ViewCommentReply").colorbox({ width: "600px", height: "400px", iframe: true });
    });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
        <fieldset class="obox"><legend>查询条件 </legend>
         <div class="skin">
            每页<input class="text w20" value="20" id="PageSize" runat="server" />条记录 <span class="sp">|</span>             
               <strong>关键字：</strong> <input id="Keyword" type="text" runat="server" class="text" />
             <strong>查询列：</strong>
                <asp:DropDownList ID="FieldList" runat="server">
                    <asp:ListItem Value="Nickname">会员昵称</asp:ListItem>
                    <asp:ListItem Value="Content">回复内容</asp:ListItem>
                </asp:DropDownList>
            <asp:Button ID="BTN_Search" runat="server" Text="查 询" OnClick="BTN_Search_Click">
            </asp:Button>
        </div>
        </fieldset>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True"
            AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="ReplyId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting"
            OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="评论标题" SortExpression="CommentId">
                    <ItemTemplate>
                        <%# Eval("Title")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="评分" SortExpression="Star">
                <ItemStyle Width="30px" HorizontalAlign="Center"/>
                    <ItemTemplate>
                        <%# Eval("Star")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="回复内容">
                    <ItemTemplate>
                        <%# Eval("ReplyContent")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="回复者" SortExpression="Nickname">
                    <ItemTemplate>
                        <%# Eval("Nickname")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="回复日期" SortExpression="AddDate">
                    <ItemStyle Width="120px" />
                    <ItemTemplate>
                        <%# Eval("AddDate")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="推荐" SortExpression="Commend">
                    <ItemStyle Width="30px" HorizontalAlign="Center"/>
                    <ItemTemplate>
                        <%# Eval("Commend").ToString() == "True" ? "是" : "否"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态" SortExpression="Status">
                    <ItemStyle Width="30px" HorizontalAlign="Center"/>
                    <ItemTemplate>
                        <%# HTShop.BLL.Util.ReturnStatus(Eval("Status").ToString())%>
                    </ItemTemplate>                   
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemStyle HorizontalAlign="Center" Width="80px"></ItemStyle>
                    <ItemTemplate>
                        <a class="ViewCommentReply" href="ViewCommentReply.aspx?id=<%# Eval("ReplyId")%>"  title="[查看回复信息]">查看</a>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"
                            OnClientClick="return confirm('确认删除选择的评论回复吗？删除后无法恢复！');"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:Pagination>
        <div class="obox">
        <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus">
            <option value="Show">显示</option>
            <option value="Hidden">隐藏</option>
            <option value="Commend">推荐</option>
                <option value="CancelCommend">取消推荐</option>
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();"
                OnClick="BTN_ManagerStatus_Click" />
        </div>
        </div>
        </div>
    </form>
</body>
</html>
