﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_ProductList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="ProductCategories" Src="../Controls/ProductCategories.ascx" %>
<%@ Register TagPrefix="UC" TagName="ManagerPager" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>商品列表</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(function () {
            bindSort();
            listInit();
            $("a.big").popImage();
        });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">   
       <fieldset class="obox"><legend>查询条件 </legend>
           <div class="skin clearfix">
             <div class="filter">分类：<UC:ProductCategories ID="ProductCategories" runat="server" ShowLevel="3" FunOption="Search"></UC:ProductCategories>
            <span class="sp">|</span> 属性：<asp:DropDownList ID="Property" runat="server" CssClass="ddl">
                <asp:ListItem Value="">选择属性</asp:ListItem>
                <asp:ListItem Value="Commend">推荐</asp:ListItem>
                <asp:ListItem Value="Hot">热点</asp:ListItem>
                <asp:ListItem Value="HotSales">热卖</asp:ListItem>
                <asp:ListItem Value="Delisting">下架</asp:ListItem>
            </asp:DropDownList>
            <span class="sp">|</span> 关键字：<input id="Keyword" type="text" runat="server" class="text" />&nbsp;
            <asp:DropDownList ID="FieldList" runat="server">
                <asp:ListItem Value="ProductName">商品名称</asp:ListItem>
                <asp:ListItem Value="ProductNo">商品编号</asp:ListItem>
                <asp:ListItem Value="LongDescription">商品详细介绍</asp:ListItem>
            </asp:DropDownList>
            &nbsp;&nbsp;每页<input class="text w20" value="20" id="PageSize" name="PageSize"/>条记录
            <asp:Button ID="BTN_Search" runat="server" Text="搜索" OnClick="BTN_Search_Click" CausesValidation="false"></asp:Button>
                <!--<span class="g"><asp:Literal ID="L_Where" runat="server"></asp:Literal></span>-->
                </div>
                <div class="add"><a class="add-button" href="AddProduct_Step1.aspx">添加商品</a></div>
        </div>
        </fieldset>
        
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" EmptyDataText="没有找到任何数据"  GridLines="None" CellSpacing="1" DataKeyNames="ProductId" PageSize="20" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID">
                    <ItemTemplate>
                        <%# Eval("ProductId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="商品名称" SortExpression="ProductName">
                    <ItemTemplate>
                    <a href="/d<%# Eval("ProductId") %>.html" target="_blank" class="a_blue"><%# Eval("ProductName") %></a>
                    <div class="preview"><a href="/uppic/product_big/<%# Eval("PicUrl") %>" class="big"><img src="/uppic/product_medium/<%# Eval("PicUrl") %>" alt="pic1" class="goods"/></a></div>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left"/>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="分类" SortExpression="Category1">
     <ItemTemplate>
			<%#Eval("Category1Name")%>
		<%#Eval("Category2Name").ToString()==""?"":" - "+Eval("Category2Name").ToString()%>
		<%#Eval("Category3Name").ToString()==""?"":" - "+Eval("Category3Name").ToString()%>
		</ItemTemplate>
	</asp:TemplateField>
	<asp:TemplateField HeaderText="售价" SortExpression="SalePrice">
                     <ItemStyle Width="60px" HorizontalAlign="Left" />
                    <ItemTemplate>
                        <%# Eval("SalePrice", "{0:C2}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="最后更新" SortExpression="LastUpdatedDate">
                    <ItemStyle Width="120px" />
                    <ItemTemplate>
                        <%# Eval("LastUpdatedDate")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="浏览" SortExpression="Hit">
                    <ItemStyle Width="30px" />
                    <ItemTemplate>
                        <%# Eval("Hit")%>
                    </ItemTemplate>
                </asp:TemplateField>
               <asp:TemplateField HeaderText="排序">
                    <ItemTemplate>
                     <a id="sort_up_<%# Eval("ProductId")%>" href="ProductList.aspx?sort=up&id=<%# Eval("ProductId")%>" class="move-up">上移</a>
                     <a id="sort_down_<%# Eval("ProductId")%>" href="ProductList.aspx?sort=down&id=<%# Eval("ProductId")%>" class="move-down">下移</a>
                    </ItemTemplate>
                    <ItemStyle Width="60px" HorizontalAlign="Center" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="属性">
                     <ItemTemplate>
                     <%# Eval("Commend").ToString()=="True"?"<span class=commend title=已被推荐>推荐</span>":""%>
                     <%# Eval("HotSales").ToString()=="True"?"<span class=hotsales title=热销商品>热销</span>":""%>
                     <%# Eval("Hot").ToString()=="True"?"<span class=hot title=热点商品>热点</span>":""%>
                     <%# Eval("Delisting").ToString()=="True"?"<span class=delisting title=下架>下架</span>":""%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="库存" SortExpression="Stocks">
                    <ItemStyle Width="40px" />
                    <ItemTemplate>
                        <%#GetStocks(Convert.ToInt32(Eval("Stocks")))%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemStyle HorizontalAlign="Center" Width="60px"></ItemStyle>
                    <ItemTemplate>
                        <a href="AddProduct_Step2.aspx?id=<%# Eval("ProductId") %>&cid=<%# Eval("Category1") %>,<%# Eval("Category2") %>,<%# Eval("Category3") %>" target="_blank" class="a_blue">修改</a>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"
                            OnClientClick="return confirm('确认删除选择的商品吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:ManagerPager ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:ManagerPager>
       <div class="obox">
            <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" onchange="changeManageStatus()">
                <option value="Commend">推荐</option>
                <option value="CancelCommend">取消推荐</option>
                <option value="New">新品</option>
                <option value="CancelNew">取消新品</option>              
                <option value="Delisting">商品下架</option>
                <option value="CancelDelisting">商品上架</option>
                <option value="ToCategory">转换分类到</option>
                <option value="Delete">删除</option>
            </select>
            <span id="ToCategory" style="display: none;">将所选商品的分类更改为--><UC:ProductCategories ID="ProductCategories1" runat="server" ShowLevel="3" FunOption="AddProduct"></UC:ProductCategories></span>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();"
                OnClick="BTN_ManagerStatus_Click" />
                </div>
        </div>
        </div>
    </form>
</body>
</html>
