﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_ProductTypeProperty, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>商品类型属性管理</title>    
	 <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
   <script type="text/javascript">
       $(document).ready(function() {
           $(".list").rowStyle("tr1", "tr2", "tr3");
           bindSort();
       });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
        <div class="obox">
        <div class="skin clearfix">
        <div class="filter">
            每页<input class="text w20" value="20" id="PageSize" runat="server" />条记录 
            <span class="sp">|</span> 
             <asp:DropDownList ID="DDL_Types" runat="server"></asp:DropDownList>
            <span class="sp">|</span>
             关键字：<input id="Keyword" type="text" runat="server" class="text" />&nbsp;
            <asp:DropDownList ID="FieldList" runat="server">
                <asp:ListItem Value="PropertyName">属性名称</asp:ListItem>
            </asp:DropDownList>&nbsp;<asp:Button ID="BTN_Search" runat="server" Text="搜索" OnClick="BTN_Search_Click" CausesValidation="false"></asp:Button>
            </div>
            <div class="add"><a class="add-button" href="AddProductTypeProperty.aspx">添加类型属性</a></div>
        </div>
      </div>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="PropertyId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting"  OnSorting="GV_List_Sorting">
            <Columns>
      <asp:TemplateField HeaderText="选择">
        <ItemTemplate>
          <asp:CheckBox ID="cb_select" runat="server" />
        </ItemTemplate>
        <ItemStyle HorizontalAlign="Center" Width="30px"/>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="ID">
        <ItemTemplate>
         <%# Eval("PropertyId")%>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="类型名称" SortExpression="TypeName">
        <ItemTemplate>
         <%# Eval("TypeName")%>
        </ItemTemplate>
      </asp:TemplateField>
       <asp:TemplateField HeaderText="属性名称">
        <ItemTemplate>
       <%# Eval("PropertyName")%>
        </ItemTemplate>
      </asp:TemplateField>
       <asp:TemplateField HeaderText="属性显示控件" SortExpression="PropertyControlType">
        <ItemTemplate>
         <%# HTShop.BLL.Util.ReturnControlName(Eval("PropertyControlType").ToString())%>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="筛选形式" SortExpression="ShowStyle">
        <ItemTemplate>
       <%# HTShop.BLL.ProductTypeProperty.ReturnShowStyle(Convert.ToInt32(Eval("ShowStyle")))%>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="排序">
        <ItemTemplate>
        <a id="sort_up_<%# Eval("PropertyId")%>" class="move-up" href="ProductTypeProperty.aspx?sort=up&id=<%# Request.QueryString["t"]!=null?Eval("PropertyId").ToString()+"&t="+Request.QueryString["t"]:Eval("PropertyId").ToString() %>">上移</a>
        <a id="sort_down_<%# Eval("PropertyId")%>" class="move-down" href="ProductTypeProperty.aspx?sort=down&id=<%# Request.QueryString["t"]!=null?Eval("PropertyId").ToString()+"&t="+Request.QueryString["t"]:Eval("PropertyId").ToString() %>">下移</a>
        <span class="gray"><%# Eval("Sort")%></span>
        </ItemTemplate>
      </asp:TemplateField>
      <asp:TemplateField HeaderText="操作">
		<ItemTemplate>
		<a href="AddProductTypeProperty.aspx?id=<%# Eval("PropertyId") %>" class="a_blue">修改</a>
			<asp:LinkButton id="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
		</ItemTemplate>
	 </asp:TemplateField>
      </Columns>
        </asp:GridView>
			<UC:PAGINATION id="Pager" runat="server" onnavigationclick="Pager_NavigationClick"></UC:PAGINATION>

            <div class="obox">
			<div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" class="ddl">
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="btn_ManagerState" runat="server" Text="确定" OnClientClick="return showConfirm();" OnClick="btn_ManagerState_Click" />
        </div>
        </div>		

			</div>
    </form>
</body>
</html>
