﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_PromoteSalesList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
     <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>商品促销列表管理</title>
     <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
    $(document).ready(function(){
    $(".list").rowStyle("tr1", "tr2", "tr3");
    $(".viewdetail").colorbox({ width: "500px", height: "400px", iframe: true });
    });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
    <asp:ScriptManager ID="ScriptManager1" runat="server"></asp:ScriptManager>
       <fieldset class="obox"><legend>查询条件</legend>
        <div class="skin">
            每页<input class="text w20" value="20" id="PageSize" runat="server" />条记录           
            <span class="sp">|</span> 
            状态：<asp:DropDownList ID="DDL_Status" runat="server">
                <asp:ListItem Value="">所有促销活动</asp:ListItem>
                <asp:ListItem Value="1">正在进行的促销活动</asp:ListItem>
                <asp:ListItem Value="0">已经停止的促销活动</asp:ListItem>
            </asp:DropDownList>
            <span class="sp">|</span>
            关键字：<input id="Keyword" type="text" runat="server" class="text" />&nbsp;
            <asp:DropDownList ID="FieldList" runat="server">
                <asp:ListItem Value="HTShop_PromoteSales.Name">促销活动名称</asp:ListItem>
                <asp:ListItem Value="HTShop_PromoteSales.Description">促销活动详细信息</asp:ListItem>
            </asp:DropDownList>&nbsp;<asp:Button ID="BTN_Search" runat="server" Text="搜索" OnClick="BTN_Search_Click"></asp:Button>
        </div>
       </fieldset>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True"
            AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="ActivityId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID">
                    <ItemTemplate>
                        <%# Eval("ActivityId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" Width="40px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="活动名称">
                    <ItemTemplate>
                        <a class="viewdetail" href="ViewPromoteSales.aspx?t=<%# Eval("PromoteType") %>&id=<%# Eval("ActivityId") %>">
                            <%# Eval("Name") %>
                        </a>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="活动类型" SortExpression="PromoteType">
                    <ItemTemplate>
                    <%#HTShop.BLL.PromoteSales.ReturnPromoteSalesTypeName(Eval("PromoteType").ToString())%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="活动日期" SortExpression="EndDate">
                    <ItemStyle Width="160px" />
                    <ItemTemplate>
                        <%# Eval("StartDate", "{0:d}")%> 至 <%# Eval("EndDate", "{0:d}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="添加日期" SortExpression="AddDate">
                    <ItemStyle Width="80px" />
                    <ItemTemplate>
                        <%# Eval( "AddDate", "{0:d}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="状态" SortExpression="Enabled">
                    <ItemStyle Width="40px" />
                    <ItemTemplate>
                        <%# Eval("Enabled").ToString()=="True"?"<span class=green>运行中</span>":"<span class=red>已终止</span>"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField>
                    <ItemStyle HorizontalAlign="Center" Width="60px"></ItemStyle>
                    <ItemTemplate>
                        <a href="<%#HTShop.BLL.PromoteSales.ReturnPromoteSalesTypeUrl(Eval("PromoteType").ToString())%>?id=<%#Eval("ActivityId")%>" target="_blank">修改</a>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"
                            OnClientClick="return confirm('确认删除选择的数据吗？删除后无法恢复！');"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:Pagination>
        <div class="obox2">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus">
                <option value="Close">终止活动</option>
                <option value="Open">启用活动</option>
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();"
                OnClick="BTN_ManagerStatus_Click" />
        </div>
        </div>
    </form>
</body>
</html>
