﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_SearchKeywords, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="ManagerPager" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head>
<meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>搜索关键字列表</title>    
   <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.date_input.zh_CN.js"></script>
    <script type="text/javascript">
    $(document).ready(function(){	
   listInit();
	$("#StartDate").date_input();
	$("#EndDate").date_input(); 
});
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
    <fieldset class="obox"><legend>查询条件</legend>
     <div class="skin">
     每页<input class="text w20" value="50" id="PageSize" runat="server" />条记录 <span class="sp">|</span>
            <input class="text" name="Keyword" id="Keyword" runat="server" />
            <input id="BTN_Search" type="submit" runat="server" value=" 查询 " onserverclick="BTN_Search_ServerClick" />
            <span class="sp">|</span> 分组统计：TOP<input class="text w20" value="50" id="TopNum" runat="server" />条记录
            <input id="BTN_ShowTopList" type="submit" runat="server" value="显示" onserverclick="BTN_ShowTopList_ServerClick" />
        </div>
     </fieldset>
   
        <asp:PlaceHolder ID="PH_List" runat="server">
            <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="KeyId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
                <Columns>
                    <asp:TemplateField HeaderText="选择">
                        <ItemTemplate>
                            <asp:CheckBox ID="cb_select" runat="server" />
                        </ItemTemplate>
                        <ItemStyle HorizontalAlign="Center" Width="30px" />
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="关键词" SortExpression="Query">
                        <ItemTemplate><%#Eval("Query") %></ItemTemplate>
                    </asp:TemplateField>                    
                    <asp:TemplateField HeaderText="IP地址" SortExpression="IPAddress">
                        <ItemTemplate>
                            <%# Eval("IPAddress")%> (<%# HTShop.Common.IPLocationSearch.GetIPAllLocation(Eval("IPAddress").ToString())%>)
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="搜索日期" SortExpression="AddDate">
                        <ItemStyle Width="120px" />
                        <ItemTemplate>
                            <%# Eval("AddDate")%>
                        </ItemTemplate>
                    </asp:TemplateField>
                    <asp:TemplateField HeaderText="操作">
                        <ItemStyle Width="30px" />
                        <ItemTemplate>
                            <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的资讯吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                        </ItemTemplate>
                    </asp:TemplateField>
                </Columns>
            </asp:GridView>
           <UC:ManagerPager ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick"></UC:ManagerPager>
            <div class="obox">
             <div class="skin">
                <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
                全选 | 功能操作：
                <select id="Manage_State" name="Manage_State" class="ddl">
                    <option value="Delete">删除</option>
                </select>
                <asp:Button ID="BTN_ManagerState" runat="server" Text="确定" OnClientClick="return confirm('确认执行选择的操作吗？');" OnClick="BTN_ManagerState_Click" />
            </div>
            </div>
        </asp:PlaceHolder>
        <asp:Repeater ID="RP_List" runat="server" Visible="false">
            <HeaderTemplate>
                <table cellspacing="1" cellpadding="0" class="list">
                    <tr>
                        <td class="title">查询关键词</td>
                        <td class="title">查询次数</td>
                    </tr>
            </HeaderTemplate>
            <ItemTemplate>
                <tr>
                    <td><%# Eval("Query")%></td>
                    <td><%# Eval("Num")%>次</td>
                </tr>
            </ItemTemplate>
            <FooterTemplate></table></FooterTemplate>
        </asp:Repeater>
        </div>
    </form>
</body>
</html>
