﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_UserGroups, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
  <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
		<title>会员组</title>
		 <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
		<script type="text/javascript" src="/scripts/jquery.query.js"></script>    
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $(document).ready(function() {
    showActionStatus();
   listInit();
    });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container w900">
    <div id="flash-msg"></div>
    <table cellspacing="1" cellpadding="0" class="tf">
    <thead>
            <tr>
                <th colspan="2">
                    会员组管理</th>
            </tr>
            </thead>
            <tbody>
            <tr>
                <td class="label">
                    会员组名：</td>
                <td class="field">
                   <input id="GroupName" type="text" runat="server" class="text w200" /></td>
            </tr>
            <tr>
                <td class="label">
                    会员组积分/消费额：</td>
                <td class="field">
                   <input id="GroupPoints" type="text" runat="server" class="text w200" />
                   <div class="s5"></div>
                   类型：<asp:RadioButtonList ID="RBL_ExpenseType" RepeatLayout="Flow" RepeatDirection="Horizontal" runat="server">
                    <asp:ListItem Value="0">积分</asp:ListItem>
                    <asp:ListItem Value="1">金额</asp:ListItem>
                    </asp:RadioButtonList>
                   <div class="n">（达到本会员组所需要累积的积分或消费额(消费额以订单成交额为准，不含运费）</div></td>
            </tr>
            <tr>
                <td class="label">
                    价格百分比：</td>
                <td class="field">
                   <input id="Discount" type="text" runat="server" class="text w60" /> % 
                   <div class="n">（例如：填写90，表示该会员以销售价90%的价格购买）</div></td>
            </tr>
            </tbody>
            <tfoot>
            <tr>
                <td colspan="2">
                    <asp:Button ID="BTN_Submit" runat="server" OnClick="BTN_Submit_Click" Text=" 保 存 " CommandName="Add" />
                    </td>
            </tr>
            </tfoot>
        </table>
        
    <asp:GridView ID="GV_List" CssClass="list" runat="server" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="GroupId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" >
            <Columns>                
                <asp:TemplateField HeaderText="会员组ID">
                    <ItemTemplate>
                        <%# Eval("GroupId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="会员组名称">
                    <ItemTemplate>
                        <%# Eval("GroupName") %>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="会员组积分/消费额">
                    <ItemTemplate>
                        <%# Eval( "GroupPoints")%> <%# Eval("ExpenseType").ToString()=="True"?"消费额":"积分"%> 
                    </ItemTemplate>
                </asp:TemplateField>
               <asp:TemplateField HeaderText="价格百分比">
                    <ItemTemplate>
                        <%# Eval("Discount")%>%
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="编辑">
                    <ItemTemplate>
                       <a href="UserGroups.aspx?id=<%# Eval("GroupId") %>">编辑</a>
                       <asp:LinkButton id="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('删除已经应用的用户组信息将会导致程序中与此用户组有关的数据出错，确认删除吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>                
            </Columns>
        </asp:GridView>
        <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ErrorMessage="会员组名称必须填写！"
        ControlToValidate="GroupName" Display="None" SetFocusOnError="True"></asp:RequiredFieldValidator>
        <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="价格百分比必须填写！"
        ControlToValidate="Discount" Display="None" SetFocusOnError="True"></asp:RequiredFieldValidator>
        <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="请选择会员组升级条件类型（消费积分或消费额）！"
        ControlToValidate="RBL_ExpenseType" Display="None" SetFocusOnError="True"></asp:RequiredFieldValidator>
        <asp:RequiredFieldValidator ID="RequiredFieldValidator4" runat="server" ErrorMessage="消费额或消费积分必须填写！"
        ControlToValidate="GroupPoints" Display="None" SetFocusOnError="True"></asp:RequiredFieldValidator>
        <asp:RegularExpressionValidator ID="RegularExpressionValidator5" runat="server" ErrorMessage="消费额或消费积分只能输入正整数！"
        ControlToValidate="GroupPoints" Display="None" SetFocusOnError="True" ValidationExpression="\d*"></asp:RegularExpressionValidator>
        <asp:RegularExpressionValidator ID="RegularExpressionValidator6" runat="server" ErrorMessage="价格百分比只能输入正整数！"
        ControlToValidate="Discount" Display="None" SetFocusOnError="True" ValidationExpression="\d*"></asp:RegularExpressionValidator>
        <asp:ValidationSummary ID="ValidationSummary1" runat="server" ShowMessageBox="True" ShowSummary="False"></asp:ValidationSummary>
        </div>
    </form>
</body>
</html>
