﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_UserList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>网站会员管理</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
   <script type="text/javascript">
       $(document).ready(function() {
           $(".list").rowStyle("tr1", "tr2", "tr3");
           $("#add-user").colorbox({ width: "500px", height: "400px", iframe: true });
           $(".view").colorbox({ width: "750px", height: "530px", iframe: true });
       });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container">
        <fieldset class="obox">
            <legend>查询条件 </legend>
            <div class="skin clearfix">
                <div class="filter">
                    每页<input class="text w20" value="20" id="PageSize" runat="server" />条记录
                    <span class="sp">|</span> 会员组：<asp:DropDownList ID="UserGroup" runat="server">
                    </asp:DropDownList>
                    <span class="sp">|</span> 
                    <asp:CheckBox ID="ValidEmail" Text="邮箱通过验证" runat="server" />
                    <asp:CheckBox ID="ValidMobile" Text="手机通过验证" runat="server" />                   
                    <span class="sp">|</span> 关键字：<input id="Keyword" type="text" runat="server" class="text" />&nbsp;
                    <asp:DropDownList ID="FieldList" runat="server">
                        <asp:ListItem Value="Nickname">会员昵称</asp:ListItem>
                        <asp:ListItem Value="Email">电子邮件</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;<asp:Button ID="BTN_Search" runat="server" Text=" 查询 " OnClick="BTN_Search_Click">
                    </asp:Button>
                </div>
                <div class="add">
                    <a id="add-user" href="AddUser.aspx" class="add-button">添加新会员</a></div>
            </div>
        </fieldset>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False"
            CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="UserId"
            PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="会员ID">
                    <ItemTemplate>
                        <%# Eval("UserId")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="会员昵称" SortExpression="Nickname">
                    <ItemTemplate>
                        <a href="ViewUser.aspx?id=<%# Eval("UserId")%>" class="view">
                            <%# Eval("Nickname")%></a>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="电子邮件" SortExpression="Email">
                    <ItemTemplate>
                        <%# Eval("ValidEmail").ToString()=="True" ? "<img src=/images/app/right.gif alt=已验证 />" : ""%> <%# Eval("Email")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="所属会员组" SortExpression="HTShop_User.GroupId">
                    <ItemTemplate>
                        <%# Eval("GroupName")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="积分" SortExpression="Points">
                    <ItemTemplate>
                        <%# Eval("Points")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="注册日期" SortExpression="AddDate">
                    <ItemTemplate>
                        <%# Eval("AddDate")%>
                    </ItemTemplate>
                    <ItemStyle Width="120px" />
                </asp:TemplateField>                
                <asp:TemplateField HeaderText="最后登录" SortExpression="LastLogOnDate">
                    <ItemTemplate>
                        <%# Eval("LastLogOnDate")%>
                    </ItemTemplate>
                    <ItemStyle Width="120px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="登录次数" SortExpression="SigninCount">
                    <ItemTemplate>
                        <%# Eval("SigninCount")%>
                    </ItemTemplate>
                </asp:TemplateField>
                 <asp:TemplateField HeaderText="信任登录">
                    <ItemTemplate>
                   <%# !string.IsNullOrEmpty(Eval("QQUserId").ToString())?"<img src=/images/app/qq_login.png alt=qq/>ＱＱ":""%>
                    <%# !string.IsNullOrEmpty(Eval("WeiboUserId").ToString()) ? "<img src=/images/app/weibo_login.png alt=weibo/>微博" : ""%>
                    <%# !string.IsNullOrEmpty(Eval("TaobaoUserId").ToString())?"<img src=/images/app/taobao_login.png alt=taobao/>淘宝":""%>
                    <%# !string.IsNullOrEmpty(Eval("AlipayUserId").ToString())?"<img src=/images/app/alipay_login.png alt=alipay/>支付宝":""%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemTemplate>
                    <a href="ViewUser.aspx?id=<%# Eval("UserId")%>" class="view a_blue">查看</a>&nbsp;&nbsp;
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false"
                            OnClientClick="return confirm('确认删除选择的内容吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick">
        </UC:Pagination>
        <div class="obox">
        <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus" class="ddl">
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定" OnClientClick="return showConfirm();"
                OnClick="BTN_ManagerStatus_Click" />
        </div>
        </div>
    </div>
    </form>
</body>
</html>
