﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_ViewOrder, HTShop.WebUI" maintainscrollpositiononpostback="true" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="AdminOrderProcess" Src="../Controls/AdminOrderProcess.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>订单 <%=OrderInfo.OrderNumber%></title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        function sendGoodsConfirm() {
            $("#delivery-info").show();
        };
        function setShipper(v) {
            $("#Shipper").val(v);
        };
        $(function () {
            var expressid = '<%=OrderInfo.OrderDeliveryInfo.Shipper%>';
            var expressno = '<%=OrderInfo.OrderDeliveryInfo.InvoiceNo%>';
            if (expressid != '' && expressno != '') {
                getKuaidiData(expressid, expressno);
            }
            $("#showexpress").click(function () {
                $.colorbox({ width: "500px", height: "450px", iframe: true, href: "/system_data/express.html" });
            });
        });
    </script>
</head>
<body>
    <UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="order-container">
        <div class="order-header">
            <strong>订单号：</strong><%=OrderInfo.OrderNumber%>&nbsp;&nbsp; <strong>订单状态：</strong><span class="g"><%=HTShop.BLL.Order.ReturnTradeStatus(Enum.GetName(typeof(HTShop.Model.TradeStatus), OrderInfo.TradeStatus))%></span>&nbsp;&nbsp;
            <strong>订单总额：</strong><%=OrderInfo.RealPrice.ToString("C")%>&nbsp;&nbsp; <strong>会员：</strong><asp:HyperLink ID="HL_UserId" runat="server" Target="_blank" CssClass="a_blue"></asp:HyperLink>&nbsp;&nbsp;
            <strong>下单时间：</strong><%=OrderInfo.AddDate%>&nbsp;&nbsp;<asp:Literal ID="L_NewOrderMsg" runat="server"></asp:Literal>
        </div>
        
        <UC:AdminOrderProcess ID="AdminOrderProcess" runat="Server"></UC:AdminOrderProcess>

        <div class="order-body">
            <div class="tit">
                <h3>订单收货信息</h3>
            </div>
            <div class="order-item">
                收货人：<%=OrderInfo.ShippingAddressInfo.RealName %><br />
                联系电话：<%=OrderInfo.ShippingAddressInfo.MobileTel%>&nbsp;&nbsp;<%=OrderInfo.ShippingAddressInfo.Tel%>
                <br />
                收货地址：<%=OrderInfo.ShippingAddressInfo.Province %>
                <%=OrderInfo.ShippingAddressInfo.City %>
                <%=OrderInfo.ShippingAddressInfo.Address %><br />
                邮政编码：<%=OrderInfo.ShippingAddressInfo.Postcode %><br />
                附带留言：<%=OrderInfo.OrderRemark %>
            </div>
            <div class="tit">
                <h3>付款信息</h3>
            </div>
            <div class="order-item">
                支付方式名称：<%=OrderInfo.PaymentInfo.Name%>
                <%if (OrderInfo.PaymentInfo.Type == 2)
                  {%>
                <br />
                在线支付交易号：<%=OrderInfo.TradeNo%>
                <% if (OrderInfo.TradeStatus == HTShop.Model.TradeStatus.WAIT_BUYER_PAY)
                   {%>
                ，正在等待买家付款.
                <%}
                   else
                   {%>
                &nbsp;&nbsp;&gt;&gt;<a href="OnlinePayLogs.aspx?order_no=<%=OrderInfo.OrderNumber%>" target="_blank" class="a_blue">查看在线支付记录</a>
                <%}%>
                <%}%>
            </div>
            <div class="tit">
                <h3>送货及支付方式</h3>
            </div>
            <div class="order-item">
                支付方式：<%=OrderInfo.PaymentInfo.Name%><br />
                送货方式：<%=OrderInfo.DeliveryInfo.DeliveryName%><br />
                所需运费：<%=OrderInfo.DeliveryPrice.ToString("C")%><br />
                是否开发票：<%=OrderInfo.Invoice?"需要发票<br/>发票抬头：" + OrderInfo.InvoiceHead + "<br/>发票类型：" + OrderInfo.InvoiceType : "不需要"%><br />
                <% if (OrderInfo.DeliveryInfo.CashOnDelivery)
                   {%>
                送货要求：<%=HTShop.BLL.Delivery.ReturnDeliveryTime(OrderInfo.DeliveryTime) + " " + (OrderInfo.TelConfirm ? "(送货前电话确认)" : "")%><br />
                <%}%>
                <% if (OrderInfo.OrderDeliveryInfo != null)
                   {%>
                配送公司：<span class="g"><%=OrderInfo.OrderDeliveryInfo.Shipper%></span><br />
                发货单号：<span class="g"><%=OrderInfo.OrderDeliveryInfo.InvoiceNo%></span>
                <%}%>
            </div>
            <div class="tit">
                <h3>订单跟踪信息</h3>
            </div>
            <div class="order-item">
                <div id="kuaidi-data">
                </div>
            </div>
            <div class="tit">
                <h3>商品清单</h3>
            </div>
            <div class="order-item">
                <table class="cart-list" cellspacing="0" cellpadding="4">
                    <tr>
                        <th>
                            商品
                        </th>
                        <th>
                            重量
                        </th>
                        <th>
                            积分
                        </th>
                        <th>
                            单价
                        </th>
                        <th>
                            数量
                        </th>
                        <th>
                            本商品小计
                        </th>
                    </tr>
                    <asp:Repeater ID="CartList" runat="server">
                        <ItemTemplate>
                            <tr>
                                <td align="left">
                                    <div class="txt">
                                        <a title='<%# Eval("ProductName") %>' href='/d<%# Eval("ProductId")%>.html' target="_blank" class="a_blue">
                                            <%# Eval("ProductName")%>
                                        </a>
                                        <br />
                                        <%# Eval("SpecItems")%>
                                    </div>
                                </td>
                                <td>
                                    <%# Eval("Weight")%>
                                    克
                                </td>
                                <td>
                                    <%# Eval("Points")%>
                                </td>
                                <td class="p">
                                    <%# Eval("RealPrice", "{0:C2}")%>
                                </td>
                                <td>
                                    <%# Eval("Quantity") %>
                                </td>
                                <td class="p">
                                    <%# Eval("SubTotalPrice", "{0:C2}")%>
                                </td>
                            </tr>
                        </ItemTemplate>
                    </asp:Repeater>
                </table>
                <div class="cart-list-price">
                    商品金额合计：<span class="p"><%=OrderInfo.ProductPrice.ToString("C")%></span></div>
            </div>
            <div class="tit">
                <h3>订单的优惠信息</h3>
            </div>
            <div class="order-item">
                <asp:Repeater ID="RP_PromoteSales" runat="server">
                    <ItemTemplate>
                        <div class="promotesales">
                            活动：<a href="/Promotion<%# Eval("ActivityId")%>.html" target="_blank" class="a_blue"><%#Eval("Name")%></a>&nbsp;&nbsp; 优惠：<%#Eval("PreferentialPrice")%>元
                        </div>
                    </ItemTemplate>
                </asp:Repeater>
            </div>
            <div class="tit">
                <h3>订单使用的优惠券</h3>
            </div>
            <div class="order-item">
                <div class="couponlist">
                    <asp:Repeater ID="RP_CouponList" runat="server">
                        <ItemTemplate>
                            <div class="coupon">
                                使用的优惠券：<%#Eval("CouponNo")%>&nbsp;&nbsp;&nbsp;&nbsp;抵价：<%#Eval("Money")%>元
                            </div>
                        </ItemTemplate>
                    </asp:Repeater>
                </div>
            </div>
            <div class="tit">
                <h3>订单费用信息</h3>
            </div>
            <div class="order-item fee">
                <table>
                    <tr>
                        <td class="label">
                            商品金额：
                        </td>
                        <td>
                            <%=OrderInfo.ProductPrice.ToString("C")%>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">
                            - 优惠券支付：
                        </td>
                        <td>
                            <%=CouponMoney%>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">
                            - 优惠金额：
                        </td>
                        <td>
                            <%=PreferentialPrice.ToString("C")%>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">
                            + 运费金额：
                        </td>
                        <td>
                            <%=OrderInfo.DeliveryPrice.ToString("C")%>
                        </td>
                    </tr>
                    <tr>
                        <td class="label">
                            订单总金额：
                        </td>
                        <td>
                            <span class="price">
                                <%=OrderInfo.RealPrice.ToString("C")%></span>
                        </td>
                    </tr>
                </table>
            </div>
            <%-- 
             <div class="tit"><h3>订单留言</h3></div>
             <div class="order-item">          
                 <a name="ordermsg"></a>
                            <div class="ordermessages">
                                <ul>
                                    <asp:Repeater ID="RP_OrderMessages" runat="server">
                                        <ItemTemplate>
                                            <li><span class="no">#<%#Container.ItemIndex+1%></span> <span class="u">
                                                <%# Eval("IsAdmin").ToString()=="True"?"<span class=admin>[管理员]</span>":""%>
                                                <%# Eval("UserName")%>
                                            </span><span class="date"><small>
                                                <%# Eval("AddDate")%>
                                            </small></span>
                                                <div class="c">
                                                    <%# Eval("Message")%>
                                                </div>
                                            </li>
                                        </ItemTemplate>
                                    </asp:Repeater>
                                </ul>
                                <div class="addmessage"><strong>留言声明：</strong>
                                    <ul>
                                        <li>1、本功能只针对订单处理方面的留言进行回复，有关具体商品的技术咨询、使用说明和各类性能参数等请到商品评论或者论坛里面提问， 本司有专门的技术人员进行回复，本处店长对此类问题一概无法进行回复。</li>
                                        <li>2、本功能不是实时交流功能，一般在12个工作小时内可以进行回复。</li>
                                        <li>3、订单一旦开始配货，则不再接受留言，如果您有其他紧急问题，可以联系客服。</li>
                                    </ul>
                                    <textarea id="AdminMessages" style="width: 300px; height: 80px;" class="text" runat="server"></textarea>
                                    <asp:Button ID="BTN_SaveMsg" runat="server" Text="发送留言" CssClass="btn-lite" OnClick="BTN_SaveMsg_Click" ValidationGroup="addmsg"></asp:Button>
                                    <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="AdminMessages" ErrorMessage="请填写留言内容！" ValidationGroup="addmsg"></asp:RequiredFieldValidator>
                                </div>
                            </div>
            </div>--%>
            <div class="tit">
                <h3>
                    订单管理操作</h3>
            </div>
            <div class="order-item trade-status">
                <fieldset class="obox">
                    <legend>设置订单状态</legend>
                    <div class="skin">
                        <span style="color: #ff0000;">注意：<br />
                            如果订单付款方式是在线支付，则系统可以根据在线支付接口返回的交易状态自动更改订单交易状态；<br />
                            以下订单交易状态也可根据实际情况手工更改，关于交易流程更多知识请访问 <a href="http://help.htshop.cn" target="_blank">http://help.htshop.cn</a></span><br />
                        <ul>
                            <li class="<%=ReturnVal(HTShop.Model.TradeStatus.WAIT_CONFIRM,"active")%>">
                                <input id="OrderTradeStatus_0" type="radio" name="OrderTradeStatus" value="WAIT_CONFIRM" <%=ReturnVal(HTShop.Model.TradeStatus.WAIT_CONFIRM,"checked=\"checked\"")%> />
                                <label for="OrderTradeStatus_0">等待确认<span class="n">（会员已提交订单，等待客服确认是否有效）</span></label>
                            </li>
                        
        <% if (!this.IsCashOnDelivery)
           {%>
                            <li class="<%=ReturnVal(HTShop.Model.TradeStatus.WAIT_BUYER_PAY,"active")%>">
                                <input id="OrderTradeStatus_1" type="radio" name="OrderTradeStatus" value="WAIT_BUYER_PAY" <%=ReturnVal(HTShop.Model.TradeStatus.WAIT_BUYER_PAY,"checked=\"checked\"")%> />
                                <label for="OrderTradeStatus_1">等待付款<span class="n">（如果付款方式是在线支付，则需等待买家付款）</span></label>
                            </li>
           <% }%>
                            <li class="<%=ReturnVal(HTShop.Model.TradeStatus.WAIT_SELLER_SEND_GOODS,"active")%>">
                                <input id="OrderTradeStatus_2" type="radio" name="OrderTradeStatus" value="WAIT_SELLER_SEND_GOODS" <%=ReturnVal(HTShop.Model.TradeStatus.WAIT_SELLER_SEND_GOODS,"checked=\"checked\"")%> />
                                <label for="OrderTradeStatus_2">正在配货<span class="n">（如果付款方式是在线支付，且买家已付款，则状态自动更改为正在配货；如果付款方式是货到付款，则需手工更改）</span></label>
                            </li>
                            <li class="<%=ReturnVal(HTShop.Model.TradeStatus.WAIT_BUYER_CONFIRM_GOODS,"active")%>">
                                <input id="OrderTradeStatus_3" type="radio" name="OrderTradeStatus" value="WAIT_BUYER_CONFIRM_GOODS" <%=ReturnVal(HTShop.Model.TradeStatus.WAIT_BUYER_CONFIRM_GOODS,"checked=\"checked\"")%> onclick="sendGoodsConfirm()" />
                                <label for="OrderTradeStatus_3">等待收货<span class="n">（卖家已发货，等待买家收货；选择此状态，必须填写配送信息）</span></label>
                                <div id="delivery-info" <%=(OrderInfo.TradeStatus==HTShop.Model.TradeStatus.WAIT_BUYER_CONFIRM_GOODS)?"style=\"display:block;\"":"style=\"display:none;\""%>>
                                    <fieldset class="obox">
                                        <legend>配送信息</legend>
                                        <div class="skin">
                                            配送公司：<input id="Shipper" type="text" class="text w200" runat="server" />
                                            <span class="n"><a id="showexpress" href="javascript:void(0)" class="a_blue">选择常见的快递公司</a></span>
                                            <div class="s5">
                                            </div>
                                            发货单号：<input id="Invoice" type="text" class="text w200" runat="server" />
                                            <span class="n">（输入快递单号）</span>
                                            <div class="s5">
                                            </div>
                                            运输类型：<asp:RadioButtonList ID="TransportType" runat="server" RepeatLayout="Flow" RepeatDirection="Horizontal">
                                                <asp:ListItem Value="EXPRESS" Selected="True">快递</asp:ListItem>
                                                <asp:ListItem Value="EMS">EMS</asp:ListItem>
                                                <asp:ListItem Value="POST">平邮</asp:ListItem>
                                            </asp:RadioButtonList>
                                            <%--
                       <div class="s5"></div>
                            <asp:Button ID="BTN_SaveDeliveryInfo" runat="server" Text="保存配送信息" OnClick="BTN_SaveDeliveryInfo_Click" ValidationGroup="delivery" CssClass="btn-orange"></asp:Button>
                            <div class="s10"></div>
                                            --%>
                                        </div>
                                    </fieldset>
                                </div>
                            </li>
                            <li class="<%=ReturnVal(HTShop.Model.TradeStatus.TRADE_FINISHED,"active")%>">
                                <input id="OrderTradeStatus_4" type="radio" name="OrderTradeStatus" value="TRADE_FINISHED" <%=ReturnVal(HTShop.Model.TradeStatus.TRADE_FINISHED,"checked=\"checked\"")%> />
                                <label for="OrderTradeStatus_4">交易完成<span class="n">（选择此项后，系统将根据订单处理会员的积分、级别等信息）</span></label>
                            </li>
                            <li class="<%=ReturnVal(HTShop.Model.TradeStatus.TRADE_CLOSED,"active")%>">
                                <input id="OrderTradeStatus_5" type="radio" name="OrderTradeStatus" value="TRADE_CLOSED" <%=ReturnVal(HTShop.Model.TradeStatus.TRADE_CLOSED,"checked=\"checked\"")%> />
                                <label for="OrderTradeStatus_5">交易关闭<span class="n">（交易失败，未成交或逾期未付款等）</span></label>
                            </li>
                        </ul>
                        <div class="s5"></div>
                        <asp:Button ID="BTN_ChangeTradeStatus" runat="server" Text="更改订单状态" OnClientClick="return changeOrderConfirm();" OnClick="BTN_ChangeTradeStatus_Click" CssClass="btn-orange"></asp:Button>
                        <div class="s10">
                        </div>
                    </div>
                </fieldset>
            </div>
            <div id="flash-msg">
            </div>
        </div>
    </div>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator2" runat="server" ErrorMessage="配送公司必须填写！" ControlToValidate="Shipper" Display="None" SetFocusOnError="True" ValidationGroup="delivery"></asp:RequiredFieldValidator>
    <asp:RequiredFieldValidator ID="RequiredFieldValidator3" runat="server" ErrorMessage="发货单号必须填写！" ControlToValidate="Invoice" Display="None" SetFocusOnError="True" ValidationGroup="delivery"></asp:RequiredFieldValidator>
    <asp:ValidationSummary ID="ValidationSummary1" runat="server" ShowMessageBox="True" ShowSummary="False" ValidationGroup="delivery"></asp:ValidationSummary>
    </form>
</body>
</html>
