﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_ViewUser, HTShop.WebUI" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>查看会员</title>
     <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.validate.min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
        $.tabs = function(containerId, start) {
            var ON_CLASS = 'current';
            var id = '#' + containerId;
            var i = (typeof start != "number") ? 1 : start;
            $(id + ' #section-' + i).show();
            $(id + ' .tab-hd ul>li:nth-child(' + i + ')').addClass(ON_CLASS);
            //切换tab的显示方法
            //$(id + ' .tab-hd ul>li>a').click(function() {
            $(id + ' .tab-hd ul>li>a').mouseover(function() {
                if (!$(this.parentNode).is('.' + ON_CLASS)) {
                    var re = /([_\-\w]+$)/i;
                    var target = $('#' + re.exec(this.href)[1]);
                    if (target.size() > 0) {
                        $(id + ' .tab-bd >div:visible').css({ display: "none" });
                        target.css({ display: "block" });
                        $(id + ' .tab-hd >ul>li').removeClass(ON_CLASS);
                        $(this.parentNode).addClass(ON_CLASS);
                    }
                    else { alert('There is no such container.'); }
                }
                return false;
            });
        };
    </script>
    <script type="text/javascript">

        //初始化分组验证
        function InitValidationGroup() {
            $('.validationGroup .causesValidation').click(Validate);
            $('.validationGroup :text').keydown(function(evt) {
                if (evt.keyCode == 13) {
                    var $nextInput = $(this).nextAll(':input:first');
                    if ($nextInput.is(':submit')) {
                        Validate(evt);
                    }
                    else {
                        evt.preventDefault();
                        $nextInput.focus();
                    }
                }
            });
        };

        function Validate(evt) {
            var $group = $(this).parents('.validationGroup');
            var isValid = true;
            $group.find(':input').each(
            function(i, item) {
                if (!$(item).valid())
                { isValid = false; }
            });
            if (!isValid)
            { evt.preventDefault(); }
        };

        function initRules() {
            //必须填写负数、正数
            jQuery.validator.addMethod("isPoint", function(value, element) {
                var point = /^[+-]?[0-9]+$/;    //电话号码格式010-12345678 
                return this.optional(element) || (point.test(value));
            }, "请填写负数或正数");

            opts = {
                rules: {

                    NewUserPassword: { required: true, maxlength: 30 },
                    NewUserPassword2: { required: true, maxlength: 30, equalTo: '#NewUserPassword' },
                    OperationPoint: { required: true, isPoint: true },
                    Point_Summary: { required: true, maxlength: 50 },
                    OperationMoney: { required: true, number: true },
                    Balance_Summary: { required: true, maxlength: 50 }

                },
                messages: {
                    NewUserPassword: { required: '请输入密码!', maxlength: '密码长度只能在6-16位字符之间' },
                    NewUserPassword2: { required: '确认重复输入密码!', maxlength: '密码长度只能在6-16位字符之间', equalTo: '两次输入的密码必须相同.' }
}//,

                    //submitHandler: function(form) {
                    //    $(form).find(":submit").attr("disabled", true).attr("value", "处理中...");
                    //    form.submit();
                    //}
                }
            }

            $(function() {
                $.tabs('tab-container', 1);
                initRules();
                var isValidationGroup = true;

                if (isValidationGroup) {
                    if (opts != undefined || opts != null) {
                        jQuery("#form1").validate(jQuery.extend(opts, { onsubmit: false }));
                    }
                    else {
                        jQuery("#form1").validate({ onsubmit: false });
                    }
                    InitValidationGroup();
                }
                else {
                    if (opts != undefined || opts != null) {
                        jQuery("#form1").validate(opts);
                    }
                    else {
                        jQuery("#form1").validate();
                    }
                }
                //pageValidate();
            });
    </script>
     <style type="text/css">
     .tab-bd{width:650px;}
     .section{width:100%;}
     .tf,.tv{width:98%;border:none;}
    .tv td{border-bottom:dotted 1px #ccc;}
    .tf .label,.tv .label{width:20%;}   
    </style>
</head>
<body>
    <form id="form1" runat="server" class="validate">
    <div class="container">
        <div id="tab-container" class="clearfix">
            <div class="tab-hd clearfix">
                <ul>
                    <li><a href="#section-1">查看信息</a></li>
                    <li><a href="#section-2">功能设置</a></li>
                </ul>
            </div>
            <div class="tab-bd">
                <div class="section" id="section-1">
                    <table cellspacing="1" cellpadding="0" class="tv">
                        <tr>
                            <td class="label">昵称：</td>
                            <td class="field"><asp:Literal ID="Nickname" runat="server"></asp:Literal></td>
                            <td rowspan="3" class="label">头像：</td>
                            <td rowspan="3" class="field"><img src="/images/app/face_default.png" id="FacePic" runat="server" style="border:solid 1px #ccc;" /></td>
                        </tr>
                        <tr>
                            <td class="label">电子邮件：</td>
                            <td class="field"><asp:Literal ID="Email" runat="server"></asp:Literal></td>
                        </tr>
                        <tr>
                            <td class="label">联系人：</td>
                            <td class="field">
                                <asp:Literal ID="RealName" runat="server"></asp:Literal></td>
                        </tr>
                        <tr>
                          <td class="label">电话：</td>
                          <td class="field"><asp:Literal ID="Tel" runat="server"></asp:Literal></td>
                          <td class="label">生日：</td>
                          <td class="field"><asp:Literal ID="Birthday" runat="server"></asp:Literal></td>
                        </tr>
                        <tr>
                            <td class="label">性别：</td>
                            <td class="field">
                                <asp:Literal ID="Sex" runat="server"></asp:Literal></td>
                            <td class="label">居住地：</td>
                            <td class="field"><asp:Literal ID="Address" runat="server"></asp:Literal></td>
                        </tr>                      
                        <tr>
                            <td class="label">注册时间：</td>
                            <td class="field">
                                <asp:Literal ID="AddDate" runat="server"></asp:Literal></td>
                            <td class="label">注册时IP地址：</td>
                            <td class="field">
                                <asp:Literal ID="RegIPAddress" runat="server"></asp:Literal></td>
                        </tr>
                        <tr>
                            <td class="label">最后登陆时间：</td>
                            <td class="field">
                                <asp:Literal ID="LastLoginDate" runat="server"></asp:Literal></td>
                            <td class="label">最后登陆IP地址：</td>
                            <td class="field">
                                <asp:Literal ID="LastLoginIPAddress" runat="server"></asp:Literal></td>
                        </tr>
                        <tr>
                            <td class="label">最后更新数据时间：</td>
                            <td class="field">
                                <asp:Literal ID="LastUpdatedDate" runat="server"></asp:Literal></td>
                            <td class="label">已登陆网站次数：</td>
                            <td class="field">
                                <asp:Literal ID="SigninCount" runat="server"></asp:Literal>次</td>
                        </tr>
                        <tr>
                            <td colspan="4" class="submit"><a href="javascript:parent.$.fn.colorbox.close();">关闭页面</a></td>
                        </tr>
                    </table>
                </div>
                <div class="section" id="section-2">
                 <table class="tf validationGroup" cellspacing="1" cellpadding="0">
                        <tr>
                            <td class="label">更改会员密码</td>
                            <td class="field">
                                新的密码：<input class="text w120" id="NewUserPassword" maxlength="30" runat="server" />
                                <div class="s10"></div>
                                重复输入：<input class="text w120" id="NewUserPassword2" maxlength="30" runat="server" />
                                <div class="s10"></div>
                                <input id="BTN_EditPassword" type="submit" value=" 修改 " runat="server" onserverclick="BTN_EditPassword_ServerClick" class="causesValidation" />
                                </td>
                        </tr>
                    </table>
                                     
                <div class="s10"></div>
                    <table class="tf validationGroup" cellspacing="1" cellpadding="0">
                        <tr>
                            <td class="label">设置会员积分</td>
                            <td class="field">
                                当前积分：<span class="price"><asp:Literal ID="L_Points" runat="server"></asp:Literal></span>
                                <div class="s10"></div>
                                设置积分：<input id="OperationPoint" type="text" class="text w40" usage="int" runat="server" /> <span class="n">（请输入负数或正数，负数：减少积分，正数：增加积分）</span>
                                <div class="s10"></div>
                                设置原因：<input id="Point_Summary" type="text" class="text" usage="notempty" runat="server" /> <span class="n">（填写操作原因，仅作为备注使用）</span>
                                <div class="s10"></div>
                                <input id="BTN_AddPoint" type="submit" value=" 修改 " onclick="return confirm('确认要修改会员积分吗？');" runat="server" onserverclick="BTN_AddPoint_ServerClick" class="causesValidation"/>
                              
                            </td>
                        </tr>
                    </table>
                    <div class="s10"></div>
                    <table class="tf validationGroup" cellspacing="1" cellpadding="0">
                        <tr>
                            <td class="label">设置会员余额</td>
                            <td class="field">
                                当前余额：<span class="price"><asp:Literal ID="L_Balance" runat="server"></asp:Literal></span>
                                <div class="s10"></div>
                                设置金额：<input id="OperationMoney" type="text" class="text w40" usage="int" runat="server" />元 <span class="n">（请输入负数或正数，小数点后2位，负数：减少金额，正数：增加金额）</span>
                                <div class="s10"></div>
                                设置原因：<input id="Balance_Summary" type="text" class="text" usage="notempty" runat="server" /> <span class="n">（填写操作原因，仅作为备注使用）</span>
                                <input id="BTN_AddBalance" type="submit" value=" 修改 " onclick="return confirm('确认要修改会员余额吗？');" runat="server" onserverclick="BTN_AddBalance_ServerClick" class="causesValidation"/>
                              
                            </td>
                        </tr>
                    </table>
                     <div class="s10"></div>
                    <table class="tf validationGroup" cellspacing="1" cellpadding="0">
                    <tr>
                            <td class="label">设置会员级别</td>
                            <td class="field">
                                <asp:DropDownList ID="UserGroup" runat="server"></asp:DropDownList>组
                                <input id="BTN_ModifyUserGroup" type="submit" check="false" value=" 修改 " onclick="return confirm('确认要修改当前会员组吗？');" runat="server" onserverclick="BTN_ModifyUserGroup_ServerClick" class="causesValidation"/>
                            </td>
                        </tr>
                     </table>   
                 <div class="s10"></div>
                   <%-- <table class="tf" cellspacing="1" cellpadding="0">
                    <tr>
                            <td class="label">设置会员登录</td>
                            <td class="field">
                                <asp:CheckBox ID="IsLock" runat="server" Text="锁定会员后使其不能登录"></asp:CheckBox>
                                <input id="BTN_SetUserLogin" type="submit" value="修改" onclick="return confirm('确认要设置会员登录状态吗？');" runat="server" onserverclick="BTN_SetUserLogin_ServerClick" />
                            </td>
                        </tr>
                     </table>   --%>
                </div>
            </div>
        </div>
        </div>
    </form>
</body>
</html>
