﻿<%@ page language="C#" autoeventwireup="true" inherits="Manager_VoteList, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/AdminHeader.ascx" %>
<%@ Register TagPrefix="UC" TagName="Pagination" Src="../Controls/ManagerPager.ascx"%>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8"/>
    <title>投票列表</title>
    <link href="/css/manager.css" type="text/css" rel="stylesheet"/>
    
    
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.megamenu.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/manager.js"></script>
    <script type="text/javascript">
    $(document).ready(function(){
   listInit();
    });
    </script>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="container w900">
   <div class="obox">
   <div class="skin">
        每页<input class="text w20" value="20" id="PageSize" runat="server" />条记录 
       <span class="sp">|</span> 关键字：<input id="Keyword" type="text" runat="server" class="text" />&nbsp;
            <asp:DropDownList ID="FieldList" runat="server">
                <asp:ListItem Value="VoteTitle">投票标题</asp:ListItem>
            </asp:DropDownList>&nbsp;<input id="BTN_Search" type="submit" runat="server" value=" 查 询 " onserverclick="BTN_Search_ServerClick" />
        </div>
        </div>
        <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" CellSpacing="1" GridLines="None" EmptyDataText="没有找到任何数据" DataKeyNames="VoteId" PageSize="20" PageIndex="1" OnRowDeleting="GV_List_RowDeleting" OnSorting="GV_List_Sorting">
            <Columns>
                <asp:TemplateField HeaderText="选择">
                    <ItemTemplate>
                        <asp:CheckBox ID="cb_select" runat="server" />
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="ID" SortExpression="VoteId">
                    <ItemTemplate>
                        <%# Eval("VoteId")%>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="30px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="投票标题" SortExpression="VoteTitle">
                    <ItemTemplate>
                        <%# Eval("VoteTitle")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="已有票数">
                    <ItemTemplate>
                        <%# GetVoteNum(Eval("VoteItems").ToString())%>票
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Center" Width="60px" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="添加日期" SortExpression="AddDate">
                    <ItemStyle HorizontalAlign="Center" Width="80px" />
                    <ItemTemplate>
                       <%# Eval("AddDate", "{0:d}")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="属性">
                    <ItemStyle Width="60px" />
                    <ItemTemplate>
                        <%# Eval("IsMulti").ToString()=="True"?"多选":""%> <%# Eval("Hidden").ToString()=="True"?"隐藏":""%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="操作">
                    <ItemStyle HorizontalAlign="Center" Width="80px"></ItemStyle>
                    <ItemTemplate><a href="AddVote.aspx?id=<%#Eval("VoteId")%>" target="_blank" class="a_blue">修改</a>
                        <asp:LinkButton ID="del" runat="server" Text="删除" CommandName="Delete" CausesValidation="false" OnClientClick="return confirm('确认删除选择的投票项目吗？删除后无法恢复！');" CssClass="a_blue"></asp:LinkButton>
                    </ItemTemplate>
                </asp:TemplateField>
            </Columns>
        </asp:GridView>
        <UC:Pagination ID="Pager" runat="server" OnNavigationClick="Pager_NavigationClick">
        </UC:Pagination>
        <div class="obox">
        <div class="skin">
            <input type="checkbox" id="selall" name="selall" onclick="selectAllCheckBox();" />
            全选 | 功能操作：
            <select id="ManageStatus" name="ManageStatus">
                <option value="Delete">删除</option>
            </select>
            <asp:Button ID="BTN_ManagerStatus" runat="server" Text="确定"  OnClientClick="return showConfirm();" OnClick="BTN_ManagerStatus_Click" />
        </div>
        </div>
        </div>
    </form>
</body>
</html>
