﻿<%@ page language="C#" autoeventwireup="true" inherits="Search, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="Controls/Header.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="Controls/Footer.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserBrowseHistory" Src="Controls/UserBrowseHistory.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>商品搜索 -</title>
    <link href="css/base.css" rel="stylesheet" type="text/css" />
    <link href="css/list.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="scripts/common.pack.js"></script>
   <script type="text/javascript" src="scripts/effects.js"></script>
    <script type="text/javascript" src="scripts/goodslist.pack.js"></script>
    <script type="text/javascript">
     function goRepeatSearch() {
        var v = $.trim($("#RepeatSearchKeyword").val());
        if (v.length > 50) {
            alert("您输入的关键字过长！");
            $('#RepeatSearchKeyword').focus();
            return false;
        }
        if (v == "" || v.substring(0, 3) == "请输入") {
            alert('请输入要搜索的关键字!');
            $('#RepeatSearchKeyword').focus();
            return false;
        }
        $('#RepeatSearchKeyword').val(v);
        return true;
};
        $(document).ready(function() {
            showListLayout('page<%=PageId%>');
        });
    </script>
</head>
<body>
 <UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
<div class="container">
           <div class="sidebar">
                <div class="category">
                    <h2><%= Keyword%></h2>
                </div>
                <div class="sideheader clearfix">
                <h3>折扣范围</h3>
            </div>
            <div class="sidecontent">
                <%=HTShop.Global.AgioRanges()%>
                <div class="clear"></div>
            </div>
            <div class="sideheader clearfix">
                <h3>积分馈赠</h3>
            </div>
            <div class="sidecontent">
                <%=HTShop.Global.PointRanges()%>
                <div class="clear"></div>
            </div>
            <div class="sideheader clearfix">
                <h3>价格区间</h3>
            </div>
            <div class="sidecontent">
                <%=HTShop.Global.PriceRanges()%>
                <div class="clear"></div>
            </div>
               <div class="sideheader">
                    <h3>最近浏览过的商品</h3>
                    <p><a href="javascript:clearBrowseHistory('.goodsbrowsehistory')">清除</a></p>
                    <div class="clear"></div>
                </div>
                <div class="sidecontent">
                    <UC:UserBrowseHistory ID="UserBrowseHistory1" runat="Server">
                    </UC:UserBrowseHistory>
                </div>
            </div>
            <div class="maincontent">
             <asp:PlaceHolder ID="PH_Products" runat="server">
                <div class="list">
                    <!--商品列表头部翻页开始-->
                    <div class="list-top">
                        <ul class="display-settings top">
                            <li class="display-mode display-mode-v2">
                              <a id="layout-row" href="javascript:changeListLayout('page<%=PageId%>','row');void(0);" class="s1">列表显示</a>
                            <a id="layout-gird" href="javascript:changeListLayout('page<%=PageId%>','grid');void(0);" class="s2-selected">图片显示</a>
                            </li>
                            <li class="sort-mode display-mode-v2">
                                <div class="sort-mode-content"><span>排序方式：</span><asp:DropDownList ID="DDL_SortDirection" runat="server"></asp:DropDownList>
                                </div>
                            </li>
                            <li class="quick-page-changer"><span>快速翻页：</span><%=QuickPrevPage%>
                                <%=QuickNextPage%>
                            </li>
                        </ul>
                    </div>
                    <!--商品列表头部翻页结束-->
                    <!--商品列表形式开始 grid-->
                    <div class="list-content grid">
                        <asp:Repeater ID="RP_Products" runat="server">
                            <HeaderTemplate>
                                <ul class="product-list">
                            </HeaderTemplate>
                            <ItemTemplate>
                                <li class="product">
                                    <h3>
                                        <%# DataBinder.Eval(Container.DataItem, "name")%>
                                    </h3>
                                    <div class="info">
                                        <div class="pic"><a href="<%# DataBinder.Eval(Container.DataItem, "path")%>" class="a_title" target="_blank">
                                            <img src="uppic/product_medium/<%# DataBinder.Eval(Container.DataItem, "pic")%>" alt="<%# DataBinder.Eval(Container.DataItem, "name")%>" /></a> </div>
                                        <div class="price">
                                            <div class="now-price"><em>
                                                <%# DataBinder.Eval(Container.DataItem, "saleprice","{0:C2}")%>
                                            </em></div>
                                            <div class="market-price"><span>市场价：</span> <del><%# DataBinder.Eval(Container.DataItem, "marketprice","{0:C2}")%></del></div>
                                        </div>
                                        <div class="name"><a href="<%# DataBinder.Eval(Container.DataItem, "path")%>" target="_blank">
                                            <%# DataBinder.Eval(Container.DataItem, "name")%>
                                        </a></div>
                                        <div class="promotion">
                                            <ul class="promotion-list">
                                                <li><span>
                                                    <%# DataBinder.Eval(Container.DataItem, "agio","{0:F1}")%>
                                                    折</span> </li>
                                                <li><span>积<%# DataBinder.Eval(Container.DataItem, "point")%>分</span> </li>
                                                <li><span><a href="###" onclick="addToCompare(this,<%# DataBinder.Eval(Container.DataItem, "id")%>,'<%# DataBinder.Eval(Container.DataItem, "name")%>')">对比</a></span></li>
                                            </ul>
                                        </div>                                        
                                    </div>                                   
                                </li>
                            </ItemTemplate>
                            <FooterTemplate></ul></FooterTemplate>
                        </asp:Repeater>
                    </div>
                    <!--商品列表形式结束-->
                    <!--商品列表页尾翻页开始-->
                    <asp:PlaceHolder ID="PH_Pager" runat="server">
                    <asp:Repeater ID="RP_Paging" runat="server">
                        <HeaderTemplate>
                            <div class="list-bottom">
                                <ul class="display-settings bottom">
                                    <li class="quick-page-changer">
                                        <%=PrevPage%>
                        </HeaderTemplate>
                        <ItemTemplate>
                            <%# DataBinder.Eval(Container.DataItem, "html") %>
                        </ItemTemplate>
                        <FooterTemplate>
                            <%=NextPage %>
                            </li></ul></div>
                        </FooterTemplate>
                    </asp:Repeater>
                </asp:PlaceHolder>
                    <!--商品列表页尾翻页结束-->
                </div>
                </asp:PlaceHolder>
                <!--商品列表结束-->
                <asp:PlaceHolder ID="PH_NoRecordCount" runat="server" Visible="false">                    
                    <div class="noresult body">
                    <h2>很抱歉，没有找到与“<%= Keyword%>”相关的内容。 </h2>
                    <strong>您可以尝试用以下方法再找一次：</strong>
                        <ul>
                            <li>一、看看输入的文字是否有错；</li>
                            <li>二、去掉不必要的词，如“的”、“吧”等；</li>
                            <li>三、去掉特殊符号，只输入单个关键词组；</li>
                            <li>四、缩短或更改搜索关键字（例：将“电动剃须刀”改为“剃须刀”后重新搜索）；</li>
                        </ul>
                       <div class="repeatsearch">
                                <input id="RepeatSearchKeyword" type="text" class="text w200" tabindex="1" value="" onfocus="this.value=''" runat="server" /> 
                            <asp:Button ID="BTN_RepeatSearch" runat="server" Text=" 重新搜索 " OnClick="BTN_RepeatSearch_Click" OnClientClick="return goRepeatSearch();" />
                        </div>
                    </div>
               </asp:PlaceHolder>
            </div>
        </div>
    </form>
<UC:Footer ID="Footer1" runat="Server"></UC:Footer>
<%=HTShop.Global.StatCode()%>  
</body>
</html>