﻿<%@ page language="C#" autoeventwireup="true" inherits="UserCenter_MyBalance, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/Header_UserCenter.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="../Controls/Footer_Lite.ascx" %>
<%@ Register TagPrefix="UC" TagName="QuickPager" Src="../Controls/QuickPager.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserMenu" Src="../Controls/UserMenu.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserCenterInfo" Src="../Controls/UserCenterInfo.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>账户余额 - <%=SiteInfo.SiteName%></title>
    <link href="/css/base.css" type="text/css" rel="stylesheet" />
    <link href="/css/usercenter.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/common.pack.js"></script>
   
</head>
<body>
    <UC:Header ID="Header1" runat="Server">
    </UC:Header>
    <form id="form1" runat="server">
<UC:UserCenterInfo ID="UserCenterInfo1" runat="Server"></UC:UserCenterInfo>
        <div class="container clearfix">
            <div class="sidebar">
                <UC:UserMenu ID="UserMenu1" runat="Server"></UC:UserMenu>
            </div>
            <div class="maincontent">
                <div class="navpath">您的位置：<a href="/default.aspx">首页</a> <small>&gt; </small><a href="Default.aspx">会员中心</a> <small>&gt; </small>账户余额</div>
                <fieldset class="obox"><legend>查询</legend>
                    <div class="skin">
                       <select id="PageSize" name="PageSize" onchange="setPageSize('<%=PAGESIZE_COOKIENAME%>',this.value)">
                        <option value="10">每页显示10条记录</option>
                        <option value="20">每页显示20条记录</option>
                        <option value="30">每页显示30条记录</option> 
                        </select>     
                    </div>
                </fieldset>
                <div class="maindata"><div class="content">您的账户余额是：<span class="price"><%=MyBalance.ToString("C")%></span>            
                &nbsp;&nbsp;<asp:Literal ID="EmptyDataText" runat="server"></asp:Literal>
                </div></div>
                <asp:PlaceHolder ID="PH_DataList" runat="server">
                <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" EmptyDataText="没有找到任何数据" GridLines="Vertical" DataKeyNames="BalanceId" PageSize="20" OnSorting="GV_List_Sorting">
                    <Columns>
                        <asp:TemplateField HeaderText="金额">
                            <ItemTemplate>
                                <%# Eval("OperationMoney", "{0:C2}")%>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Left" Width="80px" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="相关订单">
                            <ItemTemplate><a href="OrderDetail.aspx?id=<%# Eval("OrderId")%>" target="_blank">
                                <%# Eval("OrderId")%>
                            </a></ItemTemplate>
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="发生日期">
                            <ItemTemplate>
                                <%# Eval("OperationDate")%>
                            </ItemTemplate>
                            <ItemStyle HorizontalAlign="Left" Width="130px" />
                        </asp:TemplateField>
                        <asp:TemplateField HeaderText="摘要">
                            <ItemTemplate>
                                <%# Eval("Summary")%>
                            </ItemTemplate>
                        </asp:TemplateField>
                    </Columns>
                </asp:GridView>
                <UC:QuickPager ID="Pager" runat="server"></UC:QuickPager>
                </asp:PlaceHolder>
                <div class="remark"><strong>备注：</strong>
                    <ul>
                        <li>·只显示自查询之日起前60天的交易记录。 </li>
                        <li>·帐户余额是您在<%=SiteInfo.SiteName%>留下的现金。</li>
                        <li>·在订单结算时，系统将自动使用您的账户余额，您只需支付其余货款。</li>
                    </ul>
                </div>
            </div>
        </div>
        <UC:Footer ID="Footer1" runat="Server">
        </UC:Footer>
    </form>
     <script type="text/javascript">
    $(".list").rowStyle("tr1", "tr2", "tr3");
    if ($.cookie("<%=PAGESIZE_COOKIENAME%>") != null) {
        var v = $.cookie("<%=PAGESIZE_COOKIENAME%>");
        $("#PageSize").val(v);
    }
    </script>
</body>
</html>
