﻿<%@ page language="C#" autoeventwireup="true" inherits="UserCenter_MyComments, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/Header_UserCenter.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="../Controls/Footer_Lite.ascx" %>
<%@ Register TagPrefix="UC" TagName="QuickPager" Src="../Controls/QuickPager.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserMenu" Src="../Controls/UserMenu.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserCenterInfo" Src="../Controls/UserCenterInfo.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml" >
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>我的商品评价 - <%=SiteInfo.SiteName%></title>
     <link href="../css/base.css" type="text/css" rel="stylesheet" />
    <link href="../css/usercenter.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="../scripts/common.pack.js"></script>    
   <style type="text/css">
.list a.go:link{color: #ff5500;text-decoration: none;}
.list a.go:visited {color: #005AA0; text-decoration: none;}
.list a.go:hover {color: #ff5500; text-decoration: underline;}
   </style>
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
<UC:UserCenterInfo ID="UserCenterInfo1" runat="Server"></UC:UserCenterInfo>
        <div class="container clearfix">
            <div class="sidebar">
                <UC:UserMenu ID="UserMenu1" runat="Server"></UC:UserMenu>
            </div>
            <div class="maincontent">
            <div class="navpath">您的位置：<a href="/default.aspx">首页</a> <small> &gt; </small> <a href="Default.aspx">会员中心</a> <small> &gt; </small> 我的商品评价</div>
             <fieldset class="obox"><legend>查询</legend>
                    <div class="skin">
                    <select id="PageSize" name="PageSize" onchange="setPageSize('<%=PAGESIZE_COOKIENAME%>',this.value)">
                        <option value="10">每页显示10条记录</option>
                        <option value="20">每页显示20条记录</option>
                        <option value="30">每页显示30条记录</option> 
                        </select>
                    </div>
                </fieldset>
                <div class="s10"></div>
                <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False" EmptyDataText="没有找到任何数据" GridLines="Vertical" DataKeyNames="CommentId" PageSize="20" OnSorting="GV_List_Sorting">
                    <Columns>
                <asp:TemplateField HeaderText="商品名称" SortExpression="ProductName">
                    <ItemTemplate>
                        <a href="/d<%# Eval("ProductId")%>.html" target="_blank"><%# Eval("ProductName")%></a>
                    </ItemTemplate>
                    <ItemStyle HorizontalAlign="Left" />
                </asp:TemplateField>
                <asp:TemplateField HeaderText="购买时间" SortExpression="BuyDate">
                    <ItemStyle Width="80px" />
                    <ItemTemplate>
                        <span class="n"><%# Eval("BuyDate", "{0:d}")%></span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="是否评价">
                    <ItemTemplate>
                        <%# Eval("CommentId").ToString()=="0"?"<a href=\"/d"+Eval("ProductId")+".html#addcomment\" target=\"_blank\" class=\"go\">立即评价</a>":"<a href=\"/d"+Eval("ProductId")+"-comments.html#c"+Eval("CommentId")+"\" target=\"_blank\" class=\"see\">查看评价</a>"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="评价积分">
                    <ItemTemplate>
                        <%# Eval("Points")%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="回复数">
                    <ItemTemplate>
                        <%# Eval("ReplyNum").ToString()!="0"?"<a href=\"/d"+Eval("ProductId")+"-comments.html#c"+Eval("CommentId")+"\" target=\"_blank\" class=\"see\">"+Eval("ReplyNum")+"</a>":"0"%>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="用户点评">
                    <ItemTemplate>
                        <span class="n">有用(<%# Eval("Agree")%>)&nbsp;&nbsp;无用(<%# Eval("Oppose")%>)</span>
                    </ItemTemplate>
                </asp:TemplateField>
                <asp:TemplateField HeaderText="评论日期" SortExpression="AddDate">
                    <ItemStyle Width="80px" />
                    <ItemTemplate>
                        <span class="n"><%# Eval("AddDate", "{0:d}").ToString()=="1900-1-1"?"":Eval("AddDate", "{0:d}").ToString()%></span>
                    </ItemTemplate>
                </asp:TemplateField>
                    </Columns>                    
                </asp:GridView>
                <UC:QuickPager ID="Pager" runat="server"></UC:QuickPager>
                <div class="remark"><strong>写评价，送积分：</strong>
                    <ul>
<li>·只能对在半年内购买的商品进行评价；</li>
<li>·每条通过审核的商品评价均能获得5-20不等的积分奖励（赠品不给分，同一商品仅能评价一次）；</li>
<li>·所获积分与评价质量、会员级别、商品价格有关，查看具体规则；</li>
<li>·由于系统原因，较早评价的商品在该页面无法显示评价积分，您可以在<a href="MyPointLogs.aspx">积分明细</a>查看。</li>
                    </ul>
                </div>              
            </div>
        </div>
        <UC:Footer ID="Footer1" runat="Server"></UC:Footer>
    </form>
    <script type="text/javascript">
    $(".list").rowStyle("tr1", "tr2", "tr3");
    if ($.cookie("<%=PAGESIZE_COOKIENAME%>") != null) {
        var v = $.cookie("<%=PAGESIZE_COOKIENAME%>");
        $("#PageSize").val(v);
    }
   </script>
</body>
</html>
