﻿<%@ page language="C#" autoeventwireup="true" inherits="MyOrders, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/Header_UserCenter.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="../Controls/Footer_Lite.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserMenu" Src="../Controls/UserMenu.ascx" %>
<%@ Register TagPrefix="UC" TagName="QuickPager" Src="../Controls/QuickPager.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserCenterInfo" Src="../Controls/UserCenterInfo.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>我的订单列表 - <%=SiteInfo.SiteName%></title>
    <link href="/css/base.css" type="text/css" rel="stylesheet" />
    <link href="/css/usercenter.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/common.pack.js"></script>
    <script type="text/javascript" src="/scripts/jquery.litetabs.js"></script>
    

    <style type="text/css">
        .list{width: 100%;border: none;margin-top: 0px;}
        .list th
        {
            height: 25px;
            background: #EEF2F8;
        }
        .list th a
        {
            color: #333333;
        }
        .list td
        {
            color: #666666;
        }
        .list .tr1
        {
            background-color: #F8F4EE;
        }
        .list .tr2
        {
            background-color: #FFFFFF;
        }
        .list .tr3
        {
            background-color: #F7E9D4;
        }
    </style>
</head>
<body>
    <UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
<UC:UserCenterInfo ID="UserCenterInfo1" runat="Server"></UC:UserCenterInfo>
    <div class="container clearfix">
        <div class="sidebar">
            <UC:UserMenu ID="UserMenu1" runat="Server"></UC:UserMenu>
        </div>
        <div class="maincontent">
            <div class="navpath">
                您的位置：<a href="/default.aspx">首页</a> <small>&gt; </small><a href="Default.aspx">
                    会员中心</a> <small>&gt; </small>我的订单列表</div>
            <fieldset class="obox">
                <legend>查询订单</legend>
                <div class="skin">
                    <select id="PageSize" name="PageSize" onchange="setPageSize('<%=PAGESIZE_COOKIENAME%>',this.value)">
                        <option value="10">每页显示10条记录</option>
                        <option value="20">每页显示20条记录</option>
                        <option value="30">每页显示30条记录</option>
                    </select>
                    <span class="sp">|</span> 查询订单：<input id="Keyword" type="text" runat="server" class="text" />
                    <asp:DropDownList ID="FieldList" runat="server">
                        <asp:ListItem Value="OrderNumber">订单号</asp:ListItem>
                        <asp:ListItem Value="OrderProductName">商品名称</asp:ListItem>
                        <asp:ListItem Value="Ship_RealName">收货人姓名</asp:ListItem>
                        <asp:ListItem Value="Ship_Tel">收货人电话</asp:ListItem>
                        <asp:ListItem Value="Ship_Address">收货人联系地址</asp:ListItem>
                    </asp:DropDownList>
                    &nbsp;<asp:Button ID="BTN_Search" runat="server" Text=" 搜 索 " OnClick="BTN_Search_Click"
                        CssClass="btnw2" ValidationGroup="Order"></asp:Button><asp:RequiredFieldValidator ID="RequiredFieldValidator1"
                            runat="server" ErrorMessage="请输入要查询的关键字" Display="Dynamic" SetFocusOnError="true"
                            ControlToValidate="Keyword" ValidationGroup="Order"></asp:RequiredFieldValidator>
                </div>
            </fieldset>
            <div class="s10">
            </div>
            <div id="tab-container-order" class="clearfix">
                <div class="tab-hd clearfix">
                    <ul>
                        <li><a href="MyOrders.aspx?status=month #section-1">最近一个月的订单</a></li>
                        <li><a href="MyOrders.aspx?status=cancel #section-2">已取消的订单</a></li>
                        <li><a href="MyOrders.aspx?status=all #section-3">所有订单</a></li>
                    </ul>
                </div>
                <div class="tab-bd clearfix">
                    <div class="section" id="section-1">
                        <div id="contentlist">
                            <asp:GridView ID="GV_List" CssClass="list" runat="server" AllowSorting="True" AutoGenerateColumns="False"
                                EmptyDataText="没有找到任何数据" GridLines="Vertical" DataKeyNames="OrderId" PageSize="20"
                                OnSorting="GV_List_Sorting">
                                <Columns>
                                    <asp:TemplateField HeaderText="订单号" SortExpression="OrderNumber">
                                        <ItemTemplate>
                                            <a href="OrderDetail.aspx?id=<%# Eval("OrderId")%>">
                                                <%# Eval("OrderNumber")%>
                                            </a>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="收货人" SortExpression="Ship_RealName">
                                        <ItemTemplate>
                                            <%# Eval("Ship_RealName")%>
                                        </ItemTemplate>
                                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="付款方式" SortExpression="PaymentId">
                                        <ItemTemplate>
                                            <%# Eval("Name")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="配送方式" SortExpression="DeliveryId">
                                        <ItemTemplate>
                                            <%# Eval("DeliveryName")%>
                                        </ItemTemplate>
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="订单金额" SortExpression="RealPrice">
                                        <ItemTemplate>
                                            <span class="price">
                                                <%# Eval("RealPrice","{0:C2}")%>
                                            </span>
                                        </ItemTemplate>
                                        <ItemStyle HorizontalAlign="Center" Width="60px" />
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="下单时间" SortExpression="AddDate">
                                        <ItemTemplate>
                                            <%# Eval("AddDate")%>
                                        </ItemTemplate>
                                        <ItemStyle HorizontalAlign="Center" Width="80px" />
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="订单状态" SortExpression="TradeStatus">
                                        <ItemTemplate>
                                            <%#HTShop.BLL.Order.ReturnTradeStatus(Eval("TradeStatus").ToString())%>
                                        </ItemTemplate>
                                        <ItemStyle HorizontalAlign="Center" Width="80px" />
                                    </asp:TemplateField>
                                    <asp:TemplateField HeaderText="操作">
                                        <ItemTemplate>
                                        <a href="OrderDetail.aspx?id=<%# Eval("OrderId")%>">查看</a>
                                        </ItemTemplate>
                                        <ItemStyle HorizontalAlign="Center" Width="50px" />
                                    </asp:TemplateField>                                     
                                </Columns>
                            </asp:GridView>
                            <UC:QuickPager ID="Pager" runat="server"></UC:QuickPager>
                        </div>
                    </div>
                    <div class="section" id="section-2">
                    </div>
                    <div class="section" id="section-3">
                    </div>
                </div>
            </div>
        </div>
    </div>
    </form>
    <UC:Footer ID="Footer1" runat="Server"></UC:Footer>
    <script type="text/javascript">
        $(document).ready(function() {
        $.ajaxSetup({ cache: false }); //关闭AJAX相应的缓存
        
            $(".list").rowStyle("tr1", "tr2", "tr3");
            if (document.URL.indexOf("?status=all") > 0) {
                $.tabs('tab-container-order', 3);
                $("#section-3").load(document.URL + ' #section-1 #contentlist');
            }
            else if (document.URL.indexOf("?status=cancel") > 0) {
                $.tabs('tab-container-order', 2);
                $("#section-2").load(document.URL + ' #section-1 #contentlist');
            }
            else {
                $.tabs('tab-container-order', 1);
                $("#section-1").load(document.URL + ' #section-1 #contentlist');
            }

            if ($.cookie("<%=PAGESIZE_COOKIENAME%>") != null) {
                var v = $.cookie("<%=PAGESIZE_COOKIENAME%>");
                $("#PageSize").val(v);
            }
        });
    </script>
</body>
</html>
