﻿<%@ page language="C#" autoeventwireup="true" inherits="UserCenter_MyProductQA, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/Header_UserCenter.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="../Controls/Footer_Lite.ascx" %>
<%@ Register TagPrefix="UC" TagName="QuickPager" Src="../Controls/QuickPager.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserMenu" Src="../Controls/UserMenu.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserCenterInfo" Src="../Controls/UserCenterInfo.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>我的商品咨询 - <%=SiteInfo.SiteName%></title>
    <link href="../css/base.css" type="text/css" rel="stylesheet" />
    <link href="../css/usercenter.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="../scripts/common.pack.js"></script>
    <script type="text/javascript">
    
     function showReply(msgId) {
            if ($('.tr_' + msgId).css("display") == "none") {
                $('#tr-' + msgId + '-title td').css('border-bottom', 'solid 1px #F7EDDB');
                $('.tr_' + msgId).show();
            }
            else {
                $('#tr-' + msgId + '-title td').css('border-bottom', 'solid 1px #E7CA96');
                $('.tr_' + msgId).hide();
            }
        }
      
    </script>
    <style type="text/css">
        .list a.go:link
        {
            color: #ff5500;
            text-decoration: none;
        }
        .list a.go:visited
        {
            color: #005AA0;
            text-decoration: none;
        }
        .list a.go:hover
        {
            color: #ff5500;
            text-decoration: underline;
        }
    </style>
</head>
<body>
    <UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <UC:UserCenterInfo ID="UserCenterInfo1" runat="Server"></UC:UserCenterInfo>
    <div class="container clearfix">
        <div class="sidebar">
            <UC:UserMenu ID="UserMenu1" runat="Server"></UC:UserMenu>
        </div>
        <div class="maincontent">
            <div class="navpath">
                您的位置：<a href="/default.aspx">首页</a> <small>&gt; </small><a href="Default.aspx">
                    会员中心</a> <small>&gt; </small>我的商品咨询</div>
            <fieldset class="obox">
                <legend>查询</legend>
                <div class="skin">
                    <select id="PageSize" name="PageSize" onchange="setPageSize('<%=PAGESIZE_COOKIENAME%>',this.value)">
                        <option value="10">每页显示10条记录</option>
                        <option value="20">每页显示20条记录</option>
                        <option value="30">每页显示30条记录</option>
                    </select>
                </div>
            </fieldset>
            <div class="s10">
            </div>
            <table cellspacing="1" cellpadding="0" class="tv msg">
            <thead>
                <tr>
                    <th>咨询时间</th>
                    <th>商品名称</th>
                    <th>内容</th>
                    <th>回复</th>
                </tr>
              </thead>
              <tbody>
                <asp:Repeater ID="RP_List" runat="server">
                    <ItemTemplate>
                        <tr id="tr-<%# Eval("QAId")%>-title">
                            <td>
                                <%# Eval("AddDate")%>
                            </td>
                            <td>
                                <a href="/d<%# Eval("ProductId")%>.html" target="_blank">
                                    <%# Eval("ProductName")%></a>
                            </td>
                            <td>
                                <%# Eval("Description")%>
                            </td>
                            <td class="td_<%# Eval("QAId")%>_status">
                                <%# Eval("AdminId").ToString()=="0"?"未回复":"<a href=\"###\" onclick=\"showReply("+Eval("QAId").ToString()+");\" class=\"see\">查看回复</a>"%>
                            </td>
                        </tr>
                        <tr class="tr_<%# Eval("QAId")%> content" style="display: none;">
                            <td colspan="4" class="c">客服回复：<%# Eval("ReplyContent")%></td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
              </tbody>
            </table>
            <UC:QuickPager ID="Pager" runat="server"></UC:QuickPager>
            <div class="remark">
                <strong>备注：</strong>
                <ul>
                    <li>·您可在购买前对产品包装、颜色、运输、库存等方面进行咨询；</li>
                    <li>·因厂家随时会更改一些产品的包装、颜色、产地等参数，所以该回复只在当时有效；</li>
                    <li>·咨询问答并非实时回复，如因客服繁忙导致不能及时回复，请您谅解；</li>
                </ul>
            </div>
        </div>
    </div>
    <UC:Footer ID="Footer1" runat="Server"></UC:Footer>
    </form>
     <script type="text/javascript">
            $(".list").rowStyle("tr1", "tr2", "tr3");
            if ($.cookie("<%=PAGESIZE_COOKIENAME%>") != null) {
                var v = $.cookie("<%=PAGESIZE_COOKIENAME%>");
                $("#PageSize").val(v);
            }
    </script>
</body>
</html>
