﻿<%@ page language="C#" autoeventwireup="true" inherits="OrderDetail, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="../Controls/Header_UserCenter.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="../Controls/Footer_Lite.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserMenu" Src="../Controls/UserMenu.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserCenterInfo" Src="../Controls/UserCenterInfo.ascx" %>
<%@ Register TagPrefix="UC" TagName="UserOrderProcess" Src="../Controls/UserOrderProcess.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>编号<%=OrderInfo.OrderNumber%>订单 - <%=SiteInfo.SiteName%></title>
    <link href="/css/base.css" type="text/css" rel="stylesheet" />
    <link href="/css/usercenter.css" type="text/css" rel="stylesheet" />
    <link href="/css/colorbox.css" rel="stylesheet" type="text/css" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/jquery.colorbox-min.js"></script>
    <script type="text/javascript" src="/scripts/common.pack.js"></script>    
    <style type="text/css"> 
	#kuaidi-data{background:#efefef;padding:10px;line-height:18px;width: 96%;border: 0;}
	</style> 
</head>
<body>
<UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <UC:UserCenterInfo ID="UserCenterInfo1" runat="Server"></UC:UserCenterInfo>
    <div class="container clearfix">
        <div class="sidebar">
            <UC:UserMenu ID="UserMenu1" runat="Server"></UC:UserMenu>
        </div>
        <div class="maincontent">
        <div class="order-header">
          <strong>订单号：</strong><%=OrderInfo.OrderNumber%>&nbsp;&nbsp; 
          <strong>订单状态：</strong><span class="g"><%=HTShop.BLL.Order.ReturnTradeStatus(Enum.GetName(typeof(HTShop.Model.TradeStatus), OrderInfo.TradeStatus))%></span>&nbsp;&nbsp; 
          <asp:PlaceHolder ID="PH_CommandButtons" runat="server" Visible="false"> <a href="<%=PayLink%>" class="btn-pay" target="_blank">支付</a></asp:LinkButton></asp:PlaceHolder>
          <!--<strong>下单时间：</strong><asp:Literal ID="L_LastTime" runat="server"></asp:Literal>-->&nbsp;&nbsp; 
          <%if (NewOrderMsg>0){ %><a href="#ordermsg"><img src="/images/newmsg.gif" /><%=NewOrderMsg%> 条订单消息</a><%}%>
        </div>
                
        <div class="order-container">

         <UC:UserOrderProcess ID="UserOrderProcess" runat="Server"></UC:UserOrderProcess>

            <div class="order-body">
            <div class="tit"><h3>订单收货信息</h3></div>
            <div class="order-item">
            收货人：<%=OrderInfo.ShippingAddressInfo.RealName %><br/>
                                     联系电话：<%=OrderInfo.ShippingAddressInfo.Tel %>&nbsp;&nbsp;
                                    <%=OrderInfo.ShippingAddressInfo.MobileTel%><br/>
                                    收货地址：<%=OrderInfo.ShippingAddressInfo.Province %>
                                    <%=OrderInfo.ShippingAddressInfo.City %>
                                     <%=OrderInfo.ShippingAddressInfo.Address %><br/>
                                     邮政编码：<%=OrderInfo.ShippingAddressInfo.Postcode %><br/>
                                    附带留言：<%=OrderInfo.OrderRemark %>
            </div>
                            
           
            <div class="tit"><h3>付款信息</h3></div>
              <div class="order-item">
             <%=OrderInfo.PaymentInfo.Name%>
               <%if (OrderInfo.PaymentInfo.Type == 2){%>
                 <% if (OrderInfo.TradeStatus==HTShop.Model.TradeStatus.WAIT_BUYER_PAY){%>
                   ，正在等待您付款，点<a href="<%=PayLink%>" class="btn-pay" target="_blank">支付</a>立即在线付款.
                 <%}%>
               <%}else if(OrderInfo.PaymentInfo.Type==0){%>
               
                  <%if (PayStatus==1)//未到账
                  { %>
                  ，<a href="/Ajax_AddPayHistory.aspx?order=<%=OrderInfo.OrderId%>" id="add_pay_info">我已付款，填写付款确认信息</a>
                  <%}else{%>
                  <div style="width:50%;margin:5px 0;padding:5px;border:dotted 2px #ccc;">
                  付款方式：<asp:Literal ID="PaymentMethod" runat="server"></asp:Literal><br />
                  付款时间：<asp:Literal ID="PaymentDate" runat="server"></asp:Literal><br />
                  提交付款信息时间：<asp:Literal ID="PaymentAddDate" runat="server"></asp:Literal> <br />
                  客服审核确认时间：<asp:Literal ID="PaymentSucceedDate" runat="server"></asp:Literal><br />
                  </div>
                  <div class="s5"></div>
                  <%}%>
               
               <%}%>
            </div>
            
            
            
            <div class="tit"><h3>送货及支付方式</h3></div>
           <div class="order-item">支付方式：<%=OrderInfo.PaymentInfo.Name%><br/>
                            送货方式：<%=OrderInfo.DeliveryInfo.DeliveryName%><br/>
                            所需运费：<%=OrderInfo.DeliveryPrice%><br/>
                            是否开发票：<%=OrderInfo.Invoice?"需要发票<br/>发票抬头：" + OrderInfo.InvoiceHead + "<br/>发票类型：" + OrderInfo.InvoiceType : "不需要"%><br/>
                            <% if(OrderInfo.DeliveryInfo.CashOnDelivery){%>
                            送货要求：<%=HTShop.BLL.Delivery.ReturnDeliveryTime(OrderInfo.DeliveryTime) + " " + (OrderInfo.TelConfirm ? "(送货前电话确认)" : "")%><br/>
                            <%}%>
                            <% if(OrderInfo.OrderDeliveryInfo!=null){%>
                            配送公司：<span class="g"><%=OrderInfo.OrderDeliveryInfo.Shipper%></span><br/>
                            发货单号：<span class="g"><%=OrderInfo.OrderDeliveryInfo.InvoiceNo%></span>
                            <%}%>
             </div>
             
             <div class="tit"><h3>订单跟踪信息</h3></div>
             <div class="order-item"><div id="kuaidi-data"></div></div>
             
             <div class="tit"><h3>商品清单</h3></div>
              <div class="order-item">
                            <table class="cart-list" cellspacing="0" cellpadding="4">
                        <tr>
                            <th>商品</th>
                            <th>重量</th>
                            <th>积分</th>
                            <th>单价</th>
                            <th>数量</th>
                            <th>本商品小计</th>
                        </tr>
                        <asp:Repeater ID="CartList" runat="server">
                            <ItemTemplate>
                                <tr>
                                     <td style="text-align:center;width:300px;">
                                        <div class="txt"><a title='<%# Eval("ProductName") %>' href='/d<%# Eval("ProductId")%>.html' target="_blank" class="a_blue">
                                            <%# Eval("ProductName")%>
                                        </a><br/>
                                    <%# Eval("SpecItems")%>
                                        </div>
                                    </td>
                                    <td><%# Eval("Weight")%> 克</td>
                                    <td><%# Eval("Points")%></td>
                                    <td class="p"><%# Eval("RealPrice", "{0:C2}")%></td>
                                    <td><%# Eval("Quantity") %></td>
                                    <td class="p"><%# Eval("SubTotalPrice", "{0:C2}")%></td>
                                </tr>
                            </ItemTemplate>
                        </asp:Repeater>
                    </table>               
                    <div class="cart-list-price">商品金额合计：<span class="p"><%=OrderInfo.ProductPrice.ToString("C")%></span></div>  
                </div>
                       
           <div class="tit"><h3>订单的优惠信息</h3></div>
           <div class="order-item">        
                  
                                <asp:Repeater ID="RP_PromoteSales" runat="server">
                                    <ItemTemplate>
                                        <div class="promotesales">
                                            活动：<a href="/Promotion<%# Eval("ActivityId")%>.html" target="_blank" class="a_blue"><%#Eval("Name")%></a>&nbsp;&nbsp; 优惠：<%#Eval("PreferentialPrice")%>元
                                        </div>
                                    </ItemTemplate>
                                </asp:Repeater>
             </div>
             
             <div class="tit"><h3>订单使用的优惠券</h3></div>
             <div class="order-item">
             <div class="couponlist">
                                <asp:Repeater ID="RP_CouponList" runat="server">
                                    <ItemTemplate>
                                        <div class="coupon">
                                            使用的优惠券：<%#Eval("CouponNo")%>&nbsp;&nbsp;&nbsp;&nbsp;抵价：<%#Eval("Money")%>元
                                        </div>
                                    </ItemTemplate>
                                </asp:Repeater>
                            </div>
             </div>       
             
             <div class="tit"><h3>订单费用信息</h3></div>
             <div class="order-item fee">
             <table>
             <tr><td class="label">商品金额：</td><td><%=OrderInfo.ProductPrice.ToString("C")%></td><tr/>
             <tr><td class="label">- 优惠券支付：</td><td><%=CouponMoney%></td><tr/>
             <tr><td class="label">- 优惠金额：</td><td><%=PreferentialPrice.ToString("C")%></td><tr/>
             <tr><td class="label">+ 运费金额：</td><td><%=OrderInfo.DeliveryPrice.ToString("C")%></td><tr/>
             <tr><td class="label">订单总金额：</td><td><span class="price"><%=OrderInfo.RealPrice.ToString("C")%></span></td><tr/>
             </table>                           
             </div>  
            
             <%--<div class="tit"><h3>订单留言</h3></div>
             <div class="order-item">    
                   
                   <a name="ordermsg"></a>
                        <div class="ordermessages">
                        <ul>
                            <asp:Repeater ID="RP_OrderMessages" runat="server">
                                <ItemTemplate>
                                    <li><span class="no">#<%#Container.ItemIndex+1%></span> <span class="u"><%# Eval("IsAdmin").ToString()=="True"?"<span class=admin>[管理员]</span>":""%>
                                        <%# Eval("UserName")%></span>
                                        <span class="date"><small><%# Eval("AddDate")%></small></span>
                                        <div class="c">
                                        <%# Eval("Message")%>
                                        </div>
                                    </li>
                                </ItemTemplate>
                            </asp:Repeater>
                        </ul>
                        <div class="addmessage">
                        <strong>留言声明：</strong>
                        <ul>
<li>1、本功能只针对订单处理方面的留言进行回复，有关具体产品的技术咨询、使用说明和各类性能参数等请到产品评论或者论坛里面提问， 本司有专门的技术人员进行回复，本处店长对此类问题一概无法进行回复。</li>
<li>2、本功能不是实时交流功能，一般在12个工作小时内可以进行回复。</li>
<li>3、订单一旦开始配货，则不再接受留言，如果您有其他紧急问题，可以联系客服。</li>
</ul>
                            <textarea id="AdminMessages" style="width: 300px; height: 80px;" class="text" runat="server"></textarea>
                            <asp:Button ID="BTN_SaveMsg" runat="server" Text="发送留言" CssClass="btn-lite" OnClick="BTN_SaveMsg_Click"  ValidationGroup="addmsg"></asp:Button> <asp:RequiredFieldValidator ID="RequiredFieldValidator1" runat="server" ControlToValidate="AdminMessages" ErrorMessage="请填写留言内容！"  ValidationGroup="addmsg"></asp:RequiredFieldValidator>
                        </div>
                    </div>
                       </div> --%>                  
            
            </div>

            <input onclick="window.print();" type="button" value="打印订单" class="printbtn" />
            <div class="s10"></div>

        </div>
       

    </div>
   </div>
       
    </form>
    <UC:Footer ID="Footer1" runat="Server"></UC:Footer>
    <script type="text/javascript">
        function getKuaidiData(expressid, expressno) {
            $("#kuaidi-data").html('正在获取物流信息...');
            $.get("/XHttpService/api_kuaidi.ashx", { com: expressid, nu: expressno },
				function (data) {
				    $("#kuaidi-data").html(data);
				});
        };
        $(function () {
            $("#add_pay_info").colorbox({ width: "500px", height: "600px", iframe: true });
            var expressid = '<%=OrderInfo.OrderDeliveryInfo.Shipper%>';
            var expressno = '<%=OrderInfo.OrderDeliveryInfo.InvoiceNo%>';
            if (expressid != '' && expressno != '') {
                getKuaidiData(expressid, expressno);
            }
        });
    </script>
</body>
</html>
