﻿<%@ WebHandler Language="C#" Class="UploadCommentPicHandler" %>

using System;
using System.Web;
using System.Web.SessionState;
using System.Collections.Generic;
using HTShop.Common;
using HTShop.BLL;

public class UploadCommentPicHandler : IHttpHandler, IRequiresSessionState
{

    public void ProcessRequest(HttpContext context)
    {

        HTShop.BLL.User user = new HTShop.BLL.User();
        HTShop.Model.User userInfo = user.GetUserLoginInfoByCache();
        if (userInfo != null)
        {
            string UPKEY = "u" + userInfo.UserId + "_upload_commentpic";

            if (context.Request.Form["folder"] != null && context.Request.Form["folder"] == "/uppic") //上传商品图片
            {
                HttpPostedFile postedFile = context.Request.Files["uploadify"];
                string picPartUrl = Util.UploadPic(postedFile, Util.CommentPicPath, true, true, true,300,0);
                SessionHelper.AddToList<string>(UPKEY, picPartUrl);
                
                WriteTo(context, "success");

            }
            else if (context.Request.QueryString["t"] != null && context.Request.QueryString["t"] == "get")
            {
                string result = string.Empty;
                List<string> list = SessionHelper.Get<List<string>>(UPKEY);
                if (list != null)
                {
                    foreach (string s in list)
                    {
                        result += s + ",";
                    }
                }
                if (!string.IsNullOrEmpty(result))
                {
                    result = result.TrimEnd(',');
                }
                WriterLog.ToText(WriterLog.LogType.Debug, "up", result);
                //string data = (new JavaScriptSerializer()).Serialize(list);
                context.Response.Write(result);
                context.Response.End();
            }
            else if (context.Request.QueryString["t"] != null && context.Request.QueryString["t"] == "remove")
            {
                string result = "success";
                string n = Utility.InputText(context.Request.QueryString["n"]);
                try
                {
                    List<string> list = SessionHelper.Get<List<string>>(UPKEY);
                    if (list != null && list.Contains(n))
                    {
                        list.Remove(n);

                        SessionHelper.UpdateList<string>(UPKEY, list);

                        Utility.DeleteFile(System.Web.HttpContext.Current.Server.MapPath(Util.CommentPicPath) + n.Replace("/", "\\"));
                        Utility.DeleteFile(System.Web.HttpContext.Current.Server.MapPath(Util.GetThumbPath(Util.CommentPicPath)) + n.Replace("/", "\\"));
                    }
                }
                catch (Exception e)
                {
                    WriterLog.ToText(WriterLog.LogType.Error, context.Request.RawUrl, e.Message);
                    result = "fail";
                }

                context.Response.Write(result);
                context.Response.End();
            }
            else if (context.Request.QueryString["t"] != null && context.Request.QueryString["t"] == "clear")
            {
                SessionHelper.Clear(UPKEY);
            }

        }
        else
        {
            context.Response.ContentType = "text/plain";
            context.Response.Write("您没有权限进行这个操作，请登录后再试.");
            context.Response.End();
        }

    }



    private void WriteTo(HttpContext context, string result)
    {
        context.Response.Clear();
        context.Response.Write(result);
        context.Response.Flush();
        context.Response.Close();
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

}