﻿jQuery.cookie = function (name, value, options) {
    if (typeof value != 'undefined') { // name and value given, set cookie
        options = options || {};
        if (value === null) {
            value = '';
            options.expires = -1;
        }
        var expires = '';
        if (options.expires && (typeof options.expires == 'number' || options.expires.toUTCString)) {
            var date;
            if (typeof options.expires == 'number') {
                date = new Date();
                date.setTime(date.getTime() + (options.expires * 24 * 60 * 60 * 1000));
            } else {
                date = options.expires;
            }
            expires = '; expires=' + date.toUTCString(); // use expires attribute, max-age is not supported by IE
        }
        // CAUTION: Needed to parenthesize options.path and options.domain
        // in the following expressions, otherwise they evaluate to undefined
        // in the packed version for some reason...
        var path = options.path ? '; path=' + (options.path) : '';
        var domain = options.domain ? '; domain=' + (options.domain) : '';
        var secure = options.secure ? '; secure' : '';
        document.cookie = [name, '=', encodeURIComponent(value), expires, path, domain, secure].join('');
    } else { // only name given, get cookie
        var cookieValue = null;
        if (document.cookie && document.cookie != '') {
            var cookies = document.cookie.split(';');
            for (var i = 0; i < cookies.length; i++) {
                var cookie = jQuery.trim(cookies[i]);
                // Does this cookie string begin with the name we want?
                if (cookie.substring(0, name.length + 1) == (name + '=')) {
                    cookieValue = decodeURIComponent(cookie.substring(name.length + 1));
                    break;
                }
            }
        }
        return cookieValue;
    }
};

$.fn.popImage = function(options){
		var s = $.extend({}, $.fn.popImage.defaultSettings, options || {});
		if ($("#popImage_cache").length == 0){
			$("<div id='popImage_cache'></div><div class='popImage_close'></div>").appendTo("body");
		}
		var item_num = $("#popImage_cache img").length;
		return this.each(function(index){
			var $$ = $(this),
			iw = $$.outerWidth(),
			ih = $$.outerHeight(),
			imgUrl = this[s.tagName],
			index = item_num + index,
			this_id = "slide" + index;

			$('<img src="'+imgUrl+'" class="popImage_cached '+this_id+'" title="click to close"/>').appendTo("#popImage_cache").hide();
			$$.click(function(e){
				var animate_image = $('#popImage_cache .'+this_id),
				w_w = $(window).width(),
				w_h = $(window).height(),
				st = $(window).scrollTop();
				$('.popImage_close').hide();
				e.preventDefault();
				position = $$.offset(),
				o_h = animate_image.height(),
				o_w = animate_image.width();

				var t = st + (w_h - o_h)/2,
				l = (w_w - o_w)/2;

				animate_image.css({'left':position.left, 'top':position.top,'height':ih,'width':iw});
				$('.popImage_cached').hide();
				animate_image.show().fadeTo(0,0.9);
				animate_image.animate({'left':l,'top':t,'height':o_h,'width':o_w,'opacity':1},s.timeOut,function(){
					var position2 = animate_image.offset();
					$('.popImage_close').css({'left':position2.left+o_w-6, 'top':position2.top-15}).show();
				});
			});
			$('.popImage_close,.popImage_cached').bind('click',function(a){
				$('.popImage_close').hide();
				$('.popImage_cached').fadeOut(400);
				a.preventDefault();
			});
		});
};
$.fn.popImage.defaultSettings = {
		"tagName":"href",
		"timeOut":"600"
};

//判断是否为IE浏览器
function isTrueIE() {
    if (navigator.userAgent.indexOf("MSIE") > 0) {
        // ie 内核
        if (navigator.userAgent.indexOf("Tablet PC") > 0) {
            // x64 纯ie
            return true;
        }
        else if (navigator.userAgent.indexOf("Maxthon") > 0 || navigator.userAgent.indexOf("SE ") > 0 ||
            navigator.userAgent.indexOf("360") > 0 || navigator.userAgent.indexOf("QQ") > 0 ||
            navigator.userAgent.indexOf("Trident") > 0) {
            // IE内核非IE浏览!
            return false;
        }
        else {
            // x32 纯ie
            return true;
        }
    }
    return false;
};

//CheckBox 全选
function selectAllCheckBox() {
    var b = false;
    if ($("#selall").attr("checked"))
        b = true;
    $("input:checkbox").each(function () { $(this).attr("checked", b); });
}

//CheckBox 检测是否至少选择了一个
function checkSelectCheckBox() {
    var b = false;
    $("input:checkbox").each(function () { if ($("this").attr("checked")) b = true; });

    if (!b) {
        alert("至少要选择一条信息后才能进行操作！");
    }
    return b;
}

function changeManageStatus() {
    if ($("#ManageStatus").val() == "ToCategory") {
        $("#ToCategory").show();
    }
    else if ($("#ManageStatus").val() == "ChangeTradeStatus") {
        $("#TradeStatus").show();
    }
    else {
        $("#TradeStatus").hide();
    }
}

function changeOrderConfirm() {
    return confirm('确认要修改订单状态吗？');
}

function showConfirm() {
    return confirm('确认执行“' + $("#ManageStatus option:selected").text() + '”的操作吗？');
}

function showWaterMark() {
    if ($("#CB_AddWaterMark").attr("checked"))
    { $("#watermark").show(); }
    else { $("#watermark").hide(); }
}

function block() {
    $.blockUI({ message: '<h2><img src="/images/loading.gif" /> 处理中，请稍后...</h2>' });
}

jQuery.fn.rowStyle = function (c1, c2, c3, tag) {
    if (!(c1 && c2)) return; //判断有没得参数传入
    var css, oj;
    this.each(function () { //选中了多少个表格
        oj = jQuery((tag == undefined ? "tr" : tag), jQuery(this));
        //alert(oj[0]);
        oj.each(function (i) { // 选中表格中的 TR 加 CSS
            css = i % 2 == 0 ? c1 : c2;
            //alert(jQuery(this));
            jQuery(this).addClass(css);
        });

        if (c3) { //如果有第三个参数
            oj.hover(function () {
                jQuery(this).addClass(c3);
            },
            function () {
                jQuery(this).removeClass(c3);
            });
        }
    });

    $(".list input:checkbox").bind("click", function () {
        $(this).parent().parent().toggleClass("row-select");
    });
};

function switchTr(id) {
    $(".list tr").each(function () {
        if ($(this).attr("class").indexOf("sub" + id) != -1) {
            if ($(this).css("display") != "none") {
                $(this).hide();
            }
            else {
                $(this).show();
            }
        }
    });


    if ($(".list tr.sub" + id).length > 0) {
        if ($("#c" + id).attr("class") == "open-tr") {
            $("#c" + id).removeClass("open-tr").addClass("close-tr");
        } else {
            $("#c" + id).removeClass("close-tr").addClass("open-tr");
        }
    }
};


function getLeftChars(varField, num) {
    var i = 0;
    var counter = 0;
    var cap = num;

    var leftchars = cap - varField.value.length;

    return (leftchars);
};

function onCharsChange(varField, num) {
    var leftChars = getLeftChars(varField, num);
    if (leftChars >= 0) {
        charsmonitor.innerText = leftChars;
        return true;
    }
    else {
        charsmonitor.innerText = "0";
        window.alert("超过了系统限定字数，你只能输入" + num + "个字符！");

        var len = varField.value.length + leftChars;
        varField.value = varField.value.substring(0, len);
        leftChars = getLeftChars(varField, num);
        if (leftChars >= 0) {
            charsmonitor.innerText = leftChars;
        }
        return false;
    }
};

function showQuickAlert(msg, sender, sec) {
    $('<div class="quick-alert">' + msg + '</div>')
    .insertAfter($(sender == undefined ? "#BTN_Submit" : sender))
    .fadeIn('slow')
    .animate({ opacity: 1.0 }, (sec == undefined ? 3 * 1000 : sec * 1000))
    .fadeOut('slow', function () {
        $(this).remove();
    });
};

function showQuickAlertRefresh(msg, sender, sec) {
    $('<div class="quick-alert">' + msg + '</div>')
    .insertAfter($(sender == undefined ? "#BTN_Submit" : sender))
    .fadeIn('slow')
    .animate({ opacity: 1.0 }, (sec == undefined ? 3 * 1000 : sec * 1000))
    .fadeOut('slow', function () {
        $(this).remove();
        window.location.href = window.location.href;
    });
};



jQuery.fn.extend({
    switchBox: function () {
        $(this).find("h3:first").addClass("close");
        $(this).find("h3:first").bind('click', function () {

            if ($(this).find("~ .detail").css("display") == "block") {
                $(this).removeClass("open").addClass("close");
                //$(this).children("img").attr("src", "/images/app/icon_close_b.jpg");
            } else {
                $(this).removeClass("close").addClass("open");
                //$(this).children("img").attr("src", "/images/app/icon_open_b.jpg");
            }

            $(this).find("~ .detail").toggle();
        });
        return $(this);
    }
});




function setSort(id, d) {
    $("a.move-up").removeClass("move-up-over");
    $("a.move-down").removeClass("move-down-over");
    if (d == "up") {
        $("#" + id).addClass("move-up-over");
    }
    else if (d == "down") {
        $("#" + id).addClass("move-down-over");
    }
};

function bindSort() {
    $("a.move-up").each(function () {
        $(this).bind("mouseover", function () { setSort($(this).attr("id"), "up") });
    });
    $("a.move-down").each(function () {
        $(this).bind("mouseover", function () { setSort($(this).attr("id"), "down") });
    });
};


function showActionStatus() {
    var a = $.query.get("action");
    if (a == "success")
    { showQuickAlert("数据保存成功!", "#flash-msg"); }
    else if (a == "fail")
    { alert("数据保存失败！"); }
};

function getKuaidiData(expressid, expressno) {
    $("#kuaidi-data").html('正在获取物流信息...');
    $.get("/XHttpService/api_kuaidi.ashx", { com: expressid, nu: expressno },
				function (data) {
				    $("#kuaidi-data").html(data);
				});
};

function switchTopMenu() {
    if ($(".headcontainer").css("display") == "block") {
        $(".headcontainer").hide();
        $("#toparrow").attr({ src: "/images/app/arrow_bottom.gif", alt: "显示顶部菜单" });     

    }
    else {
        $(".headcontainer").show();
        $("#toparrow").attr({ src: "/images/app/arrow_top.gif", alt: "隐藏顶部菜单" });
    }
};

function listInit(){
	 $(".list").rowStyle("tr1", "tr2", "tr3");
};

 function setCookie(name, val) {
            $.cookie(name, val, { expires: 365 });
        };
        
function showNotice(tit,ctit,ctxt,clink){

	var b='<div class="notice" id="notice_focus"><div class="hd">';
	b = b + '<a href="javascript:;" onclick="setCookie(\'notice\',1);$(\'#notice_focus\').fadeOut(\'slow\');" class="close" title="关闭">关闭</a>';
b=b+'<h2>'+(tit==undefined?'HTShop通知':tit)+'</h2></div>';
b=b+'<div class="bd"><dl>';
b=b+'<dt><span class="tit">'+ctit+'</span></dt>';
b=b+'<dd>'+ctxt+'</dd></dl>';
b = b + '<p class="navbtn"><a href="' + clink + '" class="xi2" target="_blank">查看 »</a></p></div></div>';
$("form").after(b);

	if($.cookie("notice")==1){
$('#notice_focus').hide();
};
};

function waiting(v){
	var c="正在处理中，请稍后...";
	if(v!=undefined){
	c=v;
	}
    $.fancybox( '<div class="processing">'+c+'</div>', {
        title : null,modal:true
    });
};

function closeWaiting(){
	$.fancybox.close();
};

function desktopFun(){
if(window.location.href.toLowerCase().indexOf('desktop.aspx')!=-1){
	var o=eval("("+$("#Notice").val()+")");
	showNotice(o.tit,o.ctit,o.ctxt,o.clink);
	//alert(o.ctxt);
	showServiceNews();
}
};

function showServiceNews() {
    $.getJSON("http://www.htshop.cn/Notice.ashx?jsoncallback=?", function (data) {
         $.each(data, function (i, o) {
         	 var tit=o.title;
         	 //if(tit.length>17)
 //{tit=tit.substring(0,17);}
         	    var item='<li><a href="http://www.htshop.cn/news/n'+o.id+'.html" target="_blank">'+tit+'</a></li>';
                $("#service_info").append(item);
            });
    }); 
};

function showTemplates(ver) {
	$("#htshop_templates").append('<li><img src="/images/app/loading.gif" /> 正在获取模板列表，请稍后...</li>');
    $.getJSON("http://store.htshop.cn/Template/Get?jsoncallback=?&ver="+ver, function (data) {
    	$("#htshop_templates").empty();
         $.each(data, function (i, o) {
         	 
         	 var item='<li class="">';
    item+='<div class="pic"><img src="'+o.pic+'" alt="'+o.name+'"/></div>';
    item+='<div class="tit clearfix"><a href="http://store.htshop.cn/Template/Details/'+o.id+'" target="_blank" class="set">下载模板</a> <span class="name">'+o.name+'</span></div></li>';
  
                $("#htshop_templates").append(item);
            });
    }); 
};

function setEditor(id){
	var n='#Description';
	if(id!=undefined)
{n=id;}
	var editor;
        KindEditor.ready(function(K) {
            editor = K.create(n, {
                resizeType: 1,
                allowFileManager: true,
                filterMode: false,
                uploadJson: '/system_webeditor/kindeditor/upload_json.ashx',
                fileManagerJson: '/system_webeditor/kindeditor/file_manager_json.ashx'
            });
        });
};

function setEditorLite(id){
	var n='#Description';
	if(id!=undefined)
{n=id;}

 var editor;
         KindEditor.ready(function (K) {
             editor = K.create(n, {
                 resizeType: 1,
                 allowFileManager: true,
                 allowPreviewEmoticons: false,
                 allowImageUpload: false,
                 filterMode: false,	 
                 items: ['source', '|',
						'fontname', 'fontsize', '|', 'forecolor', 'hilitecolor', 'bold', 'italic', 'underline',
						'removeformat', '|', 'justifyleft', 'justifycenter', 'justifyright', 'insertorderedlist',
						'insertunorderedlist', '|', 'emoticons', 'image', 'link']
             });
         });

};


function initNews()
{
	var h="#H_NewsPic";
    if(window.location.search.indexOf('id')>0)
     {
     if($(h).val()!="")
        {
            $(h).show().attr("src",$(h).val());
        }else
        {
            $(h).hide();
        }
    }
    else
    {   
        $(h).hide();
    }
};

function setAuthor(v)
			{
			    $("#Author").val(v);
			};

$(function () {
    jQuery(".megamenu").megamenu();
    $("#ChangePassword").colorbox({ width: "500px", height: "310px", iframe: true });
    $("#FastSendMail").colorbox({ width: "700px", height: "580px", iframe: true, overlayClose: false });
    $("#About").colorbox({ width: "500px", height: "300px", iframe: true });
    desktopFun();
});