﻿$.validator.addMethod("validName", function (value, element) {
    var p = /(^[\u4e00-\u9fa5]{2,10}$|^[0-9a-zA-Z]{4,20}$)/;
    return this.optional(element) || (p.test(value));
}, "登录名由小写英文字母、数字或中文组成，长度为4-20个字符。");
$.validator.addMethod("validPassword", function (value, element) {
    var p = /^[0-9a-zA-Z]{6,20}$/;
    return this.optional(element) || (p.test(value));
}, "密码由大小写英文字母、数字组成，长度为6-20个字符。");

function validateReg() {

    $("#form1").validate({
        errorElement: "div",
        //errorContainer: $("#warning"),
        errorPlacement: function (error, element) {
            error.appendTo(element.parent());
        },
        success: function (label) {
            label.addClass("success");
        },
        rules: {
            RegEmail: {
                required: true,
                email: true,
                remote: {
                    url: "/WebHandler/ValidHandler.ashx?t=ck&f=mail", //后台处理程序
                    type: "get",              //数据发送方式
                    dataType: "json",          //接受数据格式    
                    data: { v: function () { return $("#RegEmail").val(); }
                    }
                }
            },
            RegNickname: {
                required: true,
                maxlength: 30,
                remote: {
                    url: "/WebHandler/ValidHandler.ashx?t=ck&f=name", //后台处理程序
                    type: "get",              //数据发送方式
                    dataType: "json",          //接受数据格式    
                    data: { v: function () { return $("#RegNickname").val(); }
                    }
                }
            },
            RegPassword: { required: true, maxlength: 30 },
            RegPassword2: { required: true, maxlength: 30, equalTo: '#RegPassword' }

        },
        messages: {
            RegEmail: { required: '请输入邮箱!', email: '邮箱格式错误.', remote: '该邮箱已被使用，请更换其它邮箱，或使用该邮箱找回<a href="/UserCenter/RetrieveUserPassword.aspx">密码</a>' },
            RegNickname: { required: '请输入昵称!', maxlength: '昵称长度只能在4-20位字符之间', remote: '该用户名已被使用，请使用其它用户名注册.' },
            RegPassword: { required: '请输入密码!', maxlength: '密码长度只能在6-16位字符之间' },
            RegPassword2: { required: '确认重复输入密码!', maxlength: '密码长度只能在6-16位字符之间', equalTo: '两次输入的密码必须相同.' }
        },

        submitHandler: function (form) {
            $(form).find(":submit").attr("disabled", true).attr("value", "注册中..");
            form.submit();
        }
    });

    $("#RegNickname").rules("add", "validName");
    $("#RegPassword").rules("add", "validPassword");
};

function validateLogin() {
    $("#form1").validate({
        errorElement: "div",
        errorPlacement: function (error, element) {
            error.appendTo(element.parent());
        },
        //success: function (label) {
        //    label.addClass("success");
        //},
        rules: {
            UserName: { required: true, maxlength: 30 },
            Password: { required: true, maxlength: 30 }
        },
        messages: {
            UserName: { required: '请输入邮箱或昵称.' },
            Password: { required: '请输入密码.' }
        },
        submitHandler: function (form) {
            $(form).find(":submit").attr("disabled", true).attr("value", "登录中..");
            form.submit();
        }
    });
}