﻿<%@ page language="C#" autoeventwireup="true" inherits="ShoppingCart, HTShop.WebUI" %>
<%@ Register TagPrefix="UC" TagName="Header" Src="Controls/Header_Lite.ascx" %>
<%@ Register TagPrefix="UC" TagName="Footer" Src="Controls/Footer_Lite.ascx" %>
<%@ Register TagPrefix="UC" TagName="MyFavorites" Src="Controls/MyFavorites.ascx" %>
<!DOCTYPE html PUBLIC "-//W3C//DTD XHTML 1.0 Transitional//EN" "http://www.w3.org/TR/xhtml1/DTD/xhtml1-transitional.dtd">
<html xmlns="http://www.w3.org/1999/xhtml">
<head runat="server">
    <meta http-equiv="Content-Type" content="text/html; charset=utf-8" />
    <title>购物车清单 -</title>
    <link href="/css/base.css" type="text/css" rel="stylesheet" />
    <link href="/css/base.ex.css" type="text/css" rel="stylesheet" />
    <link href="/css/cart.css" type="text/css" rel="stylesheet" />
    <link href="/css/cart.ex.css" type="text/css" rel="stylesheet" />
    <script type="text/javascript" src="/scripts/jquery.min.js"></script>
    <script type="text/javascript" src="/scripts/common.pack.js"></script>
    <script type="text/javascript" src="/scripts/cart.pack.js"></script>
    
</head>
<body>
    <UC:Header ID="Header1" runat="Server"></UC:Header>
    <form id="form1" runat="server">
    <div class="navpath clearfix">
        <span class="path"><strong>您的位置：</strong><a href="default.aspx">首页</a> &gt; 我的购物车</span><span class="tip"></span></div>
     <div class="container">
      <div id="buy-flow">
            <em>1. 我的购物车</em>
            <span>2. 选择支付配送方式</span>
            <span>3. 确认并提交定单</span>
      </div>
    </div>
    <div class="s10">
    </div>
    <asp:PlaceHolder ID="PH_CartEmpty" runat="server" Visible="false">
    <div class="container">
        <div class="cart-empty">
            <h2>
                您的购物车还是空的，赶紧行动吧！您可以：</h2>
            <ul>
                <li>如果您还未登录，可能导致购物车为空，请<a href="/Login.aspx?ReturnUrl=ShoppingCart.aspx">马上登录</a></li>
                <li>马上去 <a href="CategoryList.aspx">挑选商品</a></li>
                <li>看看 <a href="/UserCenter/MyOrders.aspx">已买到的商品</a></li>
            </ul>
        </div>
        </div>
    </asp:PlaceHolder>
    <asp:PlaceHolder ID="PH_CartInfo" runat="server">
        <div class="cart-skin">
            <table class="cart-list" cellspacing="0" cellpadding="0">
            <thead>
                <tr>
                    <th>&nbsp;
                        
                    </th>
                    <th scope="col">
                        商品
                    </th>
                    <th scope="col">
                        市场价
                    </th>
                    <th scope="col">
                        积分
                    </th>
                    <th scope="col">
                        优惠价
                    </th>
                    <th scope="col">
                        数量
                    </th>
                    <th scope="col">
                        本商品小计
                    </th>
                    <th scope="col">&nbsp;
                        
                    </th>
                </tr>
              </thead>
              <tbody>
              <tr id="promotion"><td colspan="8" class="promotion-info"><asp:Literal ID="L_PromoteSales" runat="server"></asp:Literal></td></tr>
                <asp:Repeater ID="CartList" runat="server">
                    <ItemTemplate>
                        <tr id="tr_<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>" align="center" style="background-color: #FCFCF1;">
                            <td style="width: 30px;">
                                <input id="cb_<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>" type="checkbox" name="cb_<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>"
                                    val="<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>" />
                            </td>
                            <td>
                                <div class="pic">
                                    <a title='<%# Eval("ProductName") %>' href='/d<%# Eval("ProductId")%>.html' target="_blank">
                                        <img src="/uppic/product_small/<%# Eval("Pic") %>" /></a></div>
                                <div class="txt">
                                    <a title='<%# Eval("ProductName") %>' href='/d<%# Eval("ProductId")%>.html' target="_blank"
                                        class="a_blue">
                                        <%# Eval("ProductName")%>
                                    </a><br/>
                                    <%# HTShop.BLL.ProductSpec.ShowProductSpecItems(Eval("Specs"))%>
                                </div>
                            </td>
                            <td>
                                <del class="price"><%# Eval("MarketPrice", "{0:C2}")%></del>
                            </td>
                            <td>
                                <%# Eval("Points")%>
                            </td>
                            <td>
                                <span id="UnitPrice_<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>"  class="price" style="color: #008000;"><%# Eval("RealPrice", "{0:C2}")%></span>
                            </td>
                            <td class="td_quantity">
                                <img src="images/icon_close.gif" alt="减少购买数量" style="cursor: pointer;" onclick="calQ('<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>','-');" />
                                <input id="Quantity_<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>" value="<%# Eval("Quantity") %>" type="text" class="text w20" style="height:16px;line-height:16px;" />
                                <img src="images/icon_open.gif" alt="增加购买数量" style="cursor: pointer;" onclick="calQ('<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>','+');" />
                            </td>
                            <td class="td_subtotal">
                                <span id="Subtotal_<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>" class="price"><%# Eval("SubTotalPrice", "{0:C2}")%></span>
                            </td>
                            <td style="width: 60px;">
                                <a onclick="return confirm('确认要从购物车里移除这个商品吗？');" class="a_blue" href="javascript:removeGoods('<%# Eval("ProductId")+"_"+(Eval("Specs.ItemId")==null?0:Eval("Specs.ItemId"))%>')">
                                    取消</a>
                            </td>
                        </tr>
                    </ItemTemplate>
                </asp:Repeater>
                </tbody>
            </table>
            <div class="cart-costsaving clearfix">
                 <div class="col-l">重量总计：<%=(float.Parse(TotalWeight.ToString())/1000).ToString("f1")%>kg<br/>
                    以上商品市场价共 <span id="MarketPrice"><%=MarketPrice.ToString("C")%></span> 元，您一共节省了
                    <span id="Economize"><%=Economize.ToString("C")%></span> 元
                 </div>
                 <div class="col-r clearfix">
                     <div class="qty">
                     <em id="QtyCount"><%=QuantityCount%></em>件商品&nbsp;&nbsp;总计：<br/>
                     返现：
                     </div>
                     <div class="total">
                     <span id="TotalMoney"><%=TotalMoney.ToString("C")%></span><br/>
                     <span id="PromoteMoney"><%="-"+PromoteMoney.ToString("C")%></span>
                     </div>
                 </div>
             </div>
             <div class="cart-price">
                   总计(不包含运费)： <span id="FinalPrice" class="price saleprice"><asp:Literal ID="L_FinalPrice" runat="server"></asp:Literal></span>
                   <br />
                  可获积分<span id="Point" class="point"><%=Points%></span>点
                </div>
        </div>
        
         <div class="cart-action clearfix">
               <div class="remove">
                        <a href="javascript:void(0)" onclick="clearGoods();" class="del">删除所选项</a>
                    </div>
              <div class="go">
              <a href="javascript:void(0)" onclick="goContinue();" class="continue">继续购物</a> 
                    <a href="PayAndDelivery.aspx" class="checkout">立即购买</a>
              </div>
            </div>
    </asp:PlaceHolder>
    <div class="container">
    <UC:MyFavorites ID="MyFavorites1" runat="Server"></UC:MyFavorites>
    </div>
    <div style="padding-bottom: 50px;">
    </div>
    
    </form>
    <UC:Footer ID="Footer1" runat="Server"></UC:Footer>
    <%=HTShop.Global.StatCode()%> 
</body>
</html>
