﻿<%@ webhandler Language="C#" class="kindeditor_Upload" %>

//2011-09-10 已更改,判断是否为管理员,去掉了原有的上传命名,改为htshop的上传方法

using System;
using System.Collections;
using System.Web;
using System.IO;
using System.Globalization;
using System.Web.SessionState;
using LitJson;
using HTShop.Common;

public class kindeditor_Upload : IHttpHandler, IRequiresSessionState
{
	//private HttpContext context;

	public void ProcessRequest(HttpContext context)
	{
        HTShop.BLL.Admin admin = new HTShop.BLL.Admin();
        if (admin.IsAdmin())
        {
            Upload(context);
        }
        else
        {
            ShowError(context,"权限错误：只有管理员才能上传文件！");
        }
	}

    private void Upload(HttpContext context)
    {


        HttpPostedFile imgFile = context.Request.Files["imgFile"];
        if (imgFile == null)
        {
            ShowError(context, "请选择文件。");
        }

        string fileName = string.Empty;
        try
        {
            fileName = HTShop.BLL.Util.UploadPic(imgFile, HTShop.BLL.Util.ContentPicPath, true, false, false, 0, 0);
        }
        catch (Exception ex)
        {
            ShowError(context, ex.Message);
            return;
        }

        Hashtable hash = new Hashtable();
        hash["error"] = 0;
        hash["url"] = HTShop.BLL.Util.ContentPicUrl + fileName;
        context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
        context.Response.Write(JsonMapper.ToJson(hash));
        context.Response.End();
    }

	private void ShowError(HttpContext context,string message)
	{
		Hashtable hash = new Hashtable();
		hash["error"] = 1;
		hash["message"] = message;
		context.Response.AddHeader("Content-Type", "text/html; charset=UTF-8");
		context.Response.Write(JsonMapper.ToJson(hash));
		context.Response.End();
	}

	public bool IsReusable
	{
		get
		{
			return true;
		}
	}
}
