﻿<%@ WebHandler Language="C#" Class="water" %>

using System;
using System.Web;
using System.IO;
using System.Drawing;
using ImageWaterMark;
public class water : IHttpHandler
{

    XMLX xmlx = new XMLX();
    string defaultPath = "images/2.gif";
    string waterPath = "";
    string CoverPath = "~/Upload/commodity/";
    public void ProcessRequest(HttpContext context)
    {
        string path = context.Server.MapPath(CoverPath + context.Request.QueryString["pic"].ToString());
        waterPath = "~/" + xmlx.XMLRead("PicPath");
        Image Cover = null;
        if (File.Exists(path))
        {
            Cover = Image.FromFile(path);
            Image water = Image.FromFile(context.Server.MapPath(waterPath));
            Graphics g = Graphics.FromImage(Cover);
            int x = 0;
            int y = 0;
            string location = xmlx.XMLRead("WM_Location");
            if (location == "LeftTop")
            {
                x = 0;
                y = 0;
            }
            else if (location == "LeftBottom")
            {
                x = 0;
                y = Cover.Height - water.Height;
            }
            else if (location == "Center")
            {
                x = (Cover.Width - water.Width) / 2;
                y = (Cover.Height - water.Height) / 2;
            }
            else if (location == "RightTop")
            {
                x = Cover.Width - water.Width;
                y = 0;
            }
            else if (location == "RightBottom")
            {
                x = Cover.Width - water.Width;
                y = Cover.Height - water.Height;
            }
            else if (location == "CenterTop")
            {
                x = (Cover.Width - water.Width) / 2;
                y = 0;
            }
            else if (location == "CenterBottom")
            {
                x = (Cover.Width - water.Width) / 2;
                y = Cover.Height - water.Height;
            }
            else if (location == "CenterLeft")
            {
                x = 0;
                y = (Cover.Height - water.Height) / 2;
            }
            else if (location == "CenterRight")
            {

                x = Cover.Width - water.Width;
                y = (Cover.Height - water.Height) / 2;
            }
            g.DrawImage(water, new Rectangle(x, y, water.Width, water.Height), 0, 0, water.Width, water.Height, GraphicsUnit.Pixel);
            
            water.Dispose();
            g.Dispose();
        }
        else
        {
            Cover = Image.FromFile(context.Server.MapPath(defaultPath));
        }

        context.Response.ContentType = "image/jpeg";
        Cover.Save(context.Response.OutputStream, System.Drawing.Imaging.ImageFormat.Jpeg);
        Cover.Dispose();
    }

    public bool IsReusable
    {
        get
        {
            return false;
        }
    }

}