/* Import theme specific language pack */
//tinyMCE.importThemeLanguagePack();

// Variable declarations
var TinyMCE_v6bbs_autoImportCSSClasses = true;
var TinyMCE_v6bbs_foreColor = "#000000";
var TinyMCE_v6bbs_anchorName = "";
var TinyMCE_v6bbs_buttons = [
		// Control id, button img, button title, command, user_interface, value
		['bold', 'bold.gif', '', 'Bold'],
		['italic', 'italic.gif', 'б', 'Italic'],
		['underline', 'underline.gif', '»', 'Underline'],
		['justifyleft', 'left.gif', '', 'JustifyLeft'],
		['justifycenter', 'center.gif', 'ж', 'JustifyCenter'],
		['justifyright', 'right.gif', 'Ҷ', 'JustifyRight'],
		['link', 'link.gif', '/༭ ', 'mceLink', true],
		['unlink', 'unlink.gif', 'ɾ', 'unlink'],
		['removeformat', 'removeformat.gif', 'Ƴʽ', 'removeformat'],
		['image', 'image.gif', '/༭ ͼ', 'mceImage', true],
		['forecolor', 'forecolor.gif', 'ѡɫ', 'mceForeColor', true],
		['backcolor', 'backcolor.gif', 'ѡ񱳾ɫ', 'mceBackColor', true]
	];


/**
 * Returns HTML code for the specificed control.
 */
function TinyMCE_v6bbs_getControlHTML(button_name) {
	var buttonTileMap = new Array('anchor.gif','backcolor.gif','bullist.gif','center.gif','charmap.gif','cleanup.gif','code.gif','copy.gif','custom_1.gif','cut.gif','forecolor.gif','full.gif','help.gif','hr.gif','image.gif','indent.gif','left.gif','link.gif','numlist.gif','outdent.gif','paste.gif','redo.gif','removeformat.gif','right.gif','strikethrough.gif','sub.gif','sup.gif','undo.gif','unlink.gif','visualaid.gif');

	// Lookup button in button list
	for (var i=0; i<TinyMCE_v6bbs_buttons.length; i++) {
		var but = TinyMCE_v6bbs_buttons[i];
		if (but[0] == button_name) {
			// Check for it in tilemap
			for (var x=0; !tinyMCE.isMSIE && x<buttonTileMap.length; x++) {
				if (buttonTileMap[x] == but[1])
					return '<img id="{$editor_id}_' + but[0] + '" src="{$themeurl}/images/spacer.gif" style="background-image:url({$themeurl}/images/buttons.gif); background-position: ' + (0-(x*20)) + 'px 0px" title="' + but[2] + '" width="20" height="20" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="tinyMCE.execInstanceCommand(\'{$editor_id}\',\'' + but[3] + '\', ' + (but.length > 4 ? but[4] : false) + (but.length > 5 ? ', \'' + but[5] + '\'' : '') + ')">';
			}

			// Old style
			return '<img id="{$editor_id}_' + but[0] + '" src="{$themeurl}/images/' + but[1] + '" title="' + but[2] + '" width="20" height="20" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="tinyMCE.execInstanceCommand(\'{$editor_id}\',\'' + but[3] + '\', ' + (but.length > 4 ? but[4] : false) + (but.length > 5 ? ', \'' + but[5] + '\'' : '') + ')">';
		}
	}

	// Custom controlls other than buttons
	switch (button_name) {
		case "fontselect":
			return '<select id="{$editor_id}_fontNameSelect" onchange="tinyMCE.execInstanceCommand(\'{$editor_id}\',\'FontName\',false,this.options[this.selectedIndex].value);" class="mceSelectList" TabIndex="-1">\
					<option value="">Ĭ</option>\
					<option value="arial">Arial</option>\
					<option value="times new roman">Roman</option>\
					<option value="verdana">Verdana</option>\
					<option value="courier new">Courier</option>\
					<option value="tahoma">Tahoma</option>\
					<option value=""></option>\
					<option value=""></option>\
					</select>';

		case "fontsizeselect":
			return '<select id="{$editor_id}_fontSizeSelect" onchange="tinyMCE.execInstanceCommand(\'{$editor_id}\',\'FontSize\',false,this.options[this.selectedIndex].value);" class="mceSelectList" TabIndex="-1">\
					<option value="0">ֺ</option>\
					<option value="1">8 pt</option>\
					<option value="2">10 pt</option>\
					<option value="3">12 pt</option>\
					<option value="4">14 pt</option>\
					<option value="5">18 pt</option>\
					<option value="6">24 pt</option>\
					<option value="7">36 pt</option>\
					</select>';

		case "|":
		case "separator":
			return '<img src="{$themeurl}/images/spacer.gif" width="1" height="18" class="mceSeparatorLine">';

        case "spacer":
			return '<img src="{$themeurl}/images/spacer.gif" width="1" height="18" border="0" class="mceSeparatorLine" style="vertical-align: middle" />';

		case "rowseparator":
			return '<br />';

		default:
			if(button_name.substr(0, 1) == '[')
				return '<img src="{$themeurl}/images/' + button_name.substr(1, button_name.length - 2) + '.gif", width="43" height="19">';
		}

	return "";
}

/**
 * Theme specific exec command handeling.
 */
function TinyMCE_v6bbs_execCommand(editor_id, element, command, user_interface, value) {
	switch (command) {
		case "mceForeColor":
			var template = new Array();
			var inputColor = TinyMCE_v6bbs_foreColor;

			if (!inputColor)
				inputColor = "#000000";

			template['file'] = 'color_picker.htm';
			template['width'] = 320;
			template['height'] = 285;

			tinyMCE.openWindow(template, {editor_id : editor_id, command : "forecolor", input_color : inputColor});
			return true;

		case "mceBackColor":
			var template = new Array();
			var inputColor = TinyMCE_v6bbs_foreColor;

			if (!inputColor)
				inputColor = "#000000";

			template['file'] = 'color_picker.htm';
			template['width'] = 320;
			template['height'] = 285;

			tinyMCE.openWindow(template, {editor_id : editor_id, command : "HiliteColor", input_color : inputColor});
			return true;
	}

	// Default behavior
	return false;
}

/**
 * Editor instance template function.
 */
function TinyMCE_v6bbs_getEditorTemplate(settings, editor_mode, media_mode, vote_mode) {
	var template = new Array();
	var deltaHeight = 0;

	//###########################################################################################################
	// <Layout Manager Modification by SlyD, 14.1.2005>
	//###########################################################################################################

    var toolbarHTML = "";

    // Render row 1
    var buttonNamesRow1;

	switch (editor_mode.toLowerCase()) {
		case "chat":
			buttonNamesRow1 = tinyMCE.getParam("theme_v6bbs_buttons1", "fontselect,fontsizeselect,separator,bold,italic,underline,separator,forecolor,backcolor,separator,emotions", true, ',');
			break;
		case "mail":
			buttonNamesRow1 = tinyMCE.getParam("theme_v6bbs_buttons1", "fontselect,fontsizeselect,separator,bold,italic,underline,separator,forecolor,backcolor,removeformat,separator,justifyleft,justifycenter,justifyright,separator,link,unlink,emotions,image", true, ',');
			break;
		default:
			tb = "fontselect,fontsizeselect,separator,bold,italic,underline,separator,forecolor,backcolor,removeformat,separator,justifyleft,justifycenter,justifyright,[href],link,unlink,[upload],emotions,image";

			if(media_mode == "")media_mode = "yes";
			if(vote_mode == "")vote_mode = "yes";

			media_mode = media_mode.toLowerCase();
			if(media_mode == "yes" || media_mode == "on")media_mode = "yes";

			vote_mode = vote_mode.toLowerCase();
			if(vote_mode == "yes" || vote_mode == "on")vote_mode = "yes";

			//if(media_mode == "yes")tb += ",media";
			if(media_mode == "nouse")
			    tb += ",nouse_media";
			else
			    tb += ((media_mode == "yes") ? ",media" : ",no_media");

			tb += ",separator,upload,webCam";
			//if(vote_mode == "yes")tb += ",separator,vote,alipay";
									    
			if(vote_mode != "hide") 
			    if(vote_mode == "nouse") 
			        tb += ",nouse_vote";
			    else
			        tb += ((vote_mode == "yes") ? ",vote" : ",no_vote");

			tb += ",alipay";
			
	    	buttonNamesRow1 = tinyMCE.getParam("theme_v6bbs_buttons1", tb, true, ',');
    }

    for (var i=0; i<buttonNamesRow1.length; i++)
    {
        switch (buttonNamesRow1[i]){
            case "nouse_media":
                toolbarHTML += '<img id="{$editor_id}_media" src="'+ tinyMCE.baseURL + '/plugins/media/images/media.gif" title="/༭ ý Flash Ӱ" width="20" height="20" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="alert(\'趨,ڴ˰ûзýȨޣ\');">';
                break;
            case "no_media":
                toolbarHTML += '<img id="{$editor_id}_media" src="'+ tinyMCE.baseURL + '/plugins/media/images/media.gif" title="/༭ ý Flash Ӱ" width="20" height="20" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="openDialog(\'/user/userExplain.asp\',500,370,\'userExplain\');">';
                break;
            case "nouse_vote":
                toolbarHTML += '<img id="{$editor_id}_vote" src="'+ tinyMCE.baseURL + '/plugins/vote/images/vote.gif" title="/޸ͶƱ" width="20" height="20" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="alert(\'趨,ڴ˰ûзͶƱȨޣ\');">';
                break;
            case "no_vote":
                toolbarHTML += '<img id="{$editor_id}_vote" src="'+ tinyMCE.baseURL + '/plugins/vote/images/vote.gif" title="/޸ͶƱ" width="20" height="20" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="openDialog(\'/user/userExplain.asp\',500,370,\'userExplain\');">';
                break;
            default:
                toolbarHTML += tinyMCE.getControlHTML(buttonNamesRow1[i]);
        }
    }

    if (buttonNamesRow1.length > 0)
		deltaHeight -= 23;

	switch (editor_mode.toLowerCase()) {
		case "chat":
		case "mail":
		    template['html'] = '<table class="mceEditor" border="0" cellpadding="0" cellspacing="0" width="{$width}" style="height:{$height}">'
						+ '<tr><td class="mceToolbarTop" nowrap><img src="{$themeurl}/images/format.gif", width="13" height="19">' + toolbarHTML + '</td></tr>'
						+ '<tr><td height="99%"><span id="{$editor_id}"></span></td></tr></table>';
			break;
		default:
			if(typeof(bAutoFix)=='undefined')bAutoFix=false;
					    template['html'] = '<table class="mceEditor" border="0" cellpadding="0" cellspacing="0" width="{$width}">'
						+ '<tr><td height="99%"><table border="0" cellpadding="0" cellspacing="0" width="100%" style="height:{$height}" id="{$editor_id}_Design"><tr><td class="mceToolbarTop" nowrap>'
						+ '<img src="{$themeurl}/images/format.gif", width="13" height="19">' + toolbarHTML + '</td></tr>'
						+ '<tr><td height="99%"><div id="{$editor_id}_fixwidth_view"'+(bAutoFix?' class="mceEditorFixArea"':'')+'><span id="{$editor_id}"></span></div></td></tr></table>'
						+ '<textarea onChange="tinyMCE.setContent(this.value);" id="{$editor_id}_Source" rows="15" cols="100" class="mceEditorHide" style="height:{$height}"></textarea>'
						+ '<div id="{$editor_id}_fixwidth_preview"'+(bAutoFix?' class="mceEditorFixArea"':'')+'><iframe id="{$editor_id}_Preview" frameborder="0" src="/blank.htm" class="mceEditorHide" style="height:{$height}"></iframe></div></td></tr>'
						+ '<tr><td><table width="100%" border="0" cellspacing="0" cellpadding="0"><tr><td valign="top" style="padding-bottom:5px">'
						+ '<table width="100%"  border="0" cellspacing="0" cellpadding="0"><tr><td width="5" class="mceToolbarBottom">&nbsp;</td>'
						+ '<td nowrap><div id="{$editor_id}_tab_edit" class="mceTabSelect" onclick="TinyMCE_v6bbs_onTabClick(\'{$editor_id}\',0)" style="padding: 5px;">༭</div></td>'
						+ '<td nowrap><div id="{$editor_id}_tab_source" class="mceTabRight" onclick="TinyMCE_v6bbs_onTabClick(\'{$editor_id}\',1)" style="padding: 5px;"></div></td>'
						+ '<td nowrap><div id="{$editor_id}_tab_preview" class="mceTabRight" onclick="TinyMCE_v6bbs_onTabClick(\'{$editor_id}\',2)" style="padding: 5px;">Ԥ</div></td>'
						+ '<td width="25" class="mceToolbarBottom">&nbsp;</td></tr></table>'
						+ '</td><td width="78%" valign="top" class="mceToolbarBottom">'
//						+ '<input id="{$editor_id}_fixwidth" type="checkbox" name="autofix" ' + (bAutoFix ? 'checked ':'') + ' onclick="{$editor_id}_fixwidth_view.className=(this.checked?\'mceEditorFixArea\':\'\');{$editor_id}_fixwidth_preview.className={$editor_id}_fixwidth_view.className" TabIndex="-1"><label FOR="{$editor_id}_fixwidth">ԶŰ</label>'
						+ '&nbsp;</td>'
						+ '<td width="7%" valign="top" class="mceToolbarBottom" style="padding-bottom:5px">'
						+ '<table width="100%"  border="0" cellspacing="0" cellpadding="0" style="padding-top:5px;"><tr>'
						+ '<td ><img src="{$themeurl}/images/plus.gif" title="༭" width="13" height="13" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="TinyMCE_v6bbs_sizeChange(\'{$editor_id}\', 0, 150);"></td>'
                        + '<td ><img src="{$themeurl}/images/minus.gif" title="С༭" width="13" height="13" class="mceButtonNormal" onmouseover="tinyMCE.switchClass(this,\'mceButtonOver\');" onmouseout="tinyMCE.restoreClass(this);" onmousedown="tinyMCE.restoreAndSwitchClass(this,\'mceButtonDown\');" onclick="TinyMCE_v6bbs_sizeChange(\'{$editor_id}\', 0, -150);"></td>'						
						+ '<td width="5">&nbsp;</td>'
						+ '</tr></table>'
						+ '</td></tr></table></td></tr>'
						+ '</table>';
    }                        
	template['delta_width'] = 0;
	template['delta_height'] = deltaHeight;

	return template;
}

function TinyMCE_sizeChange(editor_id, size, addsize){    
	var obj = document.getElementById(editor_id);
	if (size == 0){
	    if( (parseInt(obj.style.height) + addsize) > 0)
	        obj.style.height = parseInt(obj.style.height) + addsize;	    
	}else 
	    obj.style.height = size;

	if (parseInt(obj.style.height) < 127) obj.style.height = 127;
	return parseInt(obj.style.height);
}

function TinyMCE_v6bbs_sizeChange(editor_id, size, addsize){
    if (size > 0) 
	    size = TinyMCE_sizeChange(editor_id, size) + 23;
	else
	    size = TinyMCE_sizeChange(editor_id, 0, addsize) + 23;
    
    TinyMCE_sizeChange(editor_id + '_Design', size);
	TinyMCE_sizeChange(editor_id + '_Source', size);
	TinyMCE_sizeChange(editor_id + '_Preview', size);
}

function mceEditorMode(m){TinyMCE_v6bbs_sizeChange('mce_editor_0', m>0?127:277);}

function TinyMCE_v6bbs_onTabClickDelay(editor_id, sel_id)
{
	var srcEditor = document.getElementById(editor_id + '_Source');
	var preview;

	srcEditor.value = "";

	switch(sel_id)
	{
	case 0:
		tinyMCE.switchClassSticky(editor_id + '_tab_edit', 'mceTabSelect');
		tinyMCE.switchClassSticky(editor_id + '_Design', '');

		tinyMCE.switchClassSticky(editor_id + '_tab_source', 'mceTabRight');
		tinyMCE.switchClassSticky(editor_id + '_Source', 'mceEditorHide');

		tinyMCE.switchClassSticky(editor_id + '_tab_preview', 'mceTabRight');
		tinyMCE.switchClassSticky(editor_id + '_Preview', 'mceEditorHide');

		document.getElementById(editor_id + '_Preview').src="/blank.htm";

		break;
	case 1:
		srcEditor.value = tinyMCE.getContent(editor_id);
		        
		tinyMCE.switchClassSticky(editor_id + '_tab_edit', 'mceTabLeft');
		tinyMCE.switchClassSticky(editor_id + '_Design', 'mceEditorHide');

		tinyMCE.switchClassSticky(editor_id + '_tab_source', 'mceTabSelect');
		tinyMCE.switchClassSticky(editor_id + '_Source', 'mceEditorSource');

		tinyMCE.switchClassSticky(editor_id + '_tab_preview', 'mceTabRight');
		tinyMCE.switchClassSticky(editor_id + '_Preview', 'mceEditorHide');

		document.getElementById(editor_id + '_Preview').src="/blank.htm";

		break;
	case 2:
		tinyMCE.switchClassSticky(editor_id + '_tab_edit', 'mceTabLeft');
		tinyMCE.switchClassSticky(editor_id + '_Design', 'mceEditorHide');

		tinyMCE.switchClassSticky(editor_id + '_tab_source', 'mceTabLeft');
		tinyMCE.switchClassSticky(editor_id + '_Source', 'mceEditorHide');

		tinyMCE.switchClassSticky(editor_id + '_tab_preview', 'mceTabSelect');
		tinyMCE.switchClassSticky(editor_id + '_Preview', 'mceEditorPreview');

		if(tinyMCE.isMSIE)
			preview = document.frames(editor_id + '_Preview').document;
		else preview = document.getElementById(editor_id + '_Preview').contentDocument;

		var content = tinyMCE.getContent(editor_id);
		var startPos = 0;
		var vote_number = 0;

		while ((startPos = content.indexOf('<vote', startPos)) != -1) {
			var endPos = content.indexOf('>', startPos);
			var attribs = TinyMCE.parseAttributes(content.substring(startPos + 5, endPos));

			var chunkBefore = content.substring(0, startPos);

			startPos = endPos + 1;
			endPos = content.indexOf('</vote>', startPos);

			var voteHTML = content.substring(startPos, endPos);
			var chunkAfter = content.substring(endPos + 7);

			vote_number ++;
			if(attribs['type'] == 'checkbox')
				voteHTML = voteHTML.replace(new RegExp('<item>','gi'),'<tr><td valign=top style="padding-left:10px"><input type="checkbox" name="vote_' + vote_number + '"></td><td valign=top>');
			else voteHTML = voteHTML.replace(new RegExp('<item>','gi'),'<tr><td valign=top style="padding-left:10px"><input type="radio" name="vote_' + vote_number + '"></td><td valign=top>');
			voteHTML = voteHTML.replace(new RegExp('<item>','gi'),'</td></tr>');

			content = chunkBefore + '\r\n<table border="0" cellpadding="0" cellspacing="4">' + voteHTML + '\r\n</table>\r\n' + chunkAfter;

			startPos ++;
		}

		preview.body.innerHTML = content;

		break;
	}
}

function TinyMCE_v6bbs_onTabClick(editor_id, sel_id)
{
	setTimeout("TinyMCE_v6bbs_onTabClickDelay('" + editor_id + "', " + sel_id + ");", 50);
}

/**
 * Insert link template function.
 */
function TinyMCE_v6bbs_getInsertLinkTemplate() {
	var template = new Array();

	template['file'] = 'link.htm';
	template['width'] = 320;
	template['height'] = 200;

	return template;
}

/**
 * Insert image template function.
 */
function TinyMCE_v6bbs_getInsertImageTemplate() {
	var template = new Array();

	template['file'] = 'image.htm?src={$src}';
	template['width'] = 340;
	template['height'] = 320;

	return template;
}

/**
 * Node change handler.
 */
function TinyMCE_v6bbs_handleNodeChange(editor_id, node, undo_index, undo_levels, visual_aid, any_selection) {
	function selectByValue(select_elm, value) {
		if (select_elm) {
			for (var i=0; i<select_elm.options.length; i++) {
				if (select_elm.options[i].value == value) {
					select_elm.selectedIndex = i;
					return true;
				}
			}
		}

		return false;
	}

	function getAttrib(elm, name) {
		return elm.getAttribute(name) ? elm.getAttribute(name) : "";
	}

	// No node provided
	if (node == null)
		return;

	// Get element color
	var colorElm = tinyMCE.getParentElement(node, "font", "color");
	if (colorElm)
		TinyMCE_v6bbs_foreColor = "" + colorElm.color.toUpperCase();

	// Reset old states
	tinyMCE.switchClassSticky(editor_id + '_justifyleft', 'mceButtonNormal');
	tinyMCE.switchClassSticky(editor_id + '_justifyright', 'mceButtonNormal');
	tinyMCE.switchClassSticky(editor_id + '_justifycenter', 'mceButtonNormal');
	tinyMCE.switchClassSticky(editor_id + '_bold', 'mceButtonNormal');
	tinyMCE.switchClassSticky(editor_id + '_italic', 'mceButtonNormal');
	tinyMCE.switchClassSticky(editor_id + '_underline', 'mceButtonNormal');
	tinyMCE.switchClassSticky(editor_id + '_strikethrough', 'mceButtonNormal');
	tinyMCE.switchClassSticky(editor_id + '_link', 'mceButtonDisabled', true);
	tinyMCE.switchClassSticky(editor_id + '_unlink', 'mceButtonDisabled', true);
    tinyMCE.switchClassSticky(editor_id + '_image', 'mceButtonNormal');

	// Get anchor name
	var anchorName = tinyMCE.getParentElement(node, "a", "name");
	TinyMCE_v6bbs_anchorName = "";
	if (anchorName) {
		TinyMCE_v6bbs_anchorName = anchorName.getAttribute("name");
		tinyMCE.switchClassSticky(editor_id + '_anchor', 'mceButtonSelected');
	}

	// Get link
	var anchorLink = tinyMCE.getParentElement(node, "a", "href");
	if (anchorLink || any_selection) {
		tinyMCE.switchClassSticky(editor_id + '_link', anchorLink ? 'mceButtonSelected' : 'mceButtonNormal', false);
		tinyMCE.switchClassSticky(editor_id + '_unlink', anchorLink ? 'mceButtonSelected' : 'mceButtonNormal', false);
	}

	// Handle visual aid
	tinyMCE.switchClassSticky(editor_id + '_visualaid', visual_aid ? 'mceButtonSelected' : 'mceButtonNormal', false);

	// Select fontselect
	var selectElm = document.getElementById(editor_id + "_fontNameSelect");
	if (selectElm) {
		var elm = tinyMCE.getParentElement(node, "font", "face");
		if (elm)
			selectByValue(selectElm, elm.getAttribute("face"));
		else
			selectByValue(selectElm, "");
	}

	// Select fontsize
	var selectElm = document.getElementById(editor_id + "_fontSizeSelect");
	if (selectElm) {
		var elm = tinyMCE.getParentElement(node, "font", "size");
		if (elm && getAttrib(elm, "size") != "")
			selectByValue(selectElm, elm.getAttribute("size"));
		else
			selectByValue(selectElm, "0");
	}

	// Handle align attributes
	alignNode = node;
	breakOut = false;
	do {
		if (!alignNode.getAttribute || !alignNode.getAttribute('align'))
			continue;

		switch (alignNode.getAttribute('align').toLowerCase()) {
			case "left":
				tinyMCE.switchClassSticky(editor_id + '_justifyleft', 'mceButtonSelected');
				breakOut = true;
			break;

			case "right":
				tinyMCE.switchClassSticky(editor_id + '_justifyright', 'mceButtonSelected');
				breakOut = true;
			break;

			case "middle":
			case "center":
				tinyMCE.switchClassSticky(editor_id + '_justifycenter', 'mceButtonSelected');
				breakOut = true;
			break;
		}
	} while (!breakOut && (alignNode = alignNode.parentNode));

	// Handle elements
	do {
		switch (node.nodeName.toLowerCase()) {
			case "b":
			case "strong":
				tinyMCE.switchClassSticky(editor_id + '_bold', 'mceButtonSelected');
			break;

			case "i":
			case "em":
				tinyMCE.switchClassSticky(editor_id + '_italic', 'mceButtonSelected');
			break;

			case "u":
				tinyMCE.switchClassSticky(editor_id + '_underline', 'mceButtonSelected');
			break;

            case "img":
				if (getAttrib(node, 'name').indexOf('mce_') != 0)
					tinyMCE.switchClassSticky(editor_id + '_image', 'mceButtonSelected');
            break;
		}
	} while ((node = node.parentNode));
}

// This function auto imports CSS classes into the class selection droplist
function TinyMCE_v6bbs_setupCSSClasses(editor_id) {
	if (!TinyMCE_v6bbs_autoImportCSSClasses)
		return;

	var selectElm = document.getElementById(editor_id + '_styleSelect');

	if (selectElm && selectElm.getAttribute('cssImported') != 'true') {
		var csses = tinyMCE.getCSSClasses(editor_id);
		if (csses && selectElm) {
			for (var i=0; i<csses.length; i++)
				selectElm.options[selectElm.length] = new Option(csses[i], csses[i]);
		}

		// Only do this once
		if (csses != null && csses.length > 0)
			selectElm.setAttribute('cssImported', 'true');
	}
}