﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;

using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Controls_Client_ClientContactList : System.Web.UI.UserControl
{
    public string _ClientName;
    public string _ClientID;
    public string _SelectedIndex;
    private string _CommandName;
    private int _PageIndex;
    public event EventHandler SelectedIndexChanged;
    public event GridViewCommandEventHandler RowCommand;
    public event GridViewPageEventHandler PageIndexChanging;
    public event EventHandler RowDataBound;

    protected void Init_Data()
    {
        ddlProvince.Items.Clear();
        ddlProvince.Items.Add(new ListItem("省份", "-1"));
        DataTable dtProvince = CRM.Common.InitData.GetProvinceByCid(Session["CID"].ToString());
        if (dtProvince.Rows.Count > 0)
        {
            for (int i = 0; i < dtProvince.Rows.Count; i++)
            {
                ddlProvince.Items.Add(new ListItem(dtProvince.Rows[i]["名称"].ToString(), dtProvince.Rows[i]["id"].ToString()));
            }
        }

        ddlCity.Items.Clear();
        ddlCity.Items.Add(new ListItem("地区", "-1"));
        DataTable dtCity = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        if (dtCity.Rows.Count > 0)
        {
            for (int i = 0; i < dtCity.Rows.Count; i++)
            {
                ddlCity.Items.Add(new ListItem(dtCity.Rows[i]["名称"].ToString(), dtCity.Rows[i]["id"].ToString()));
            }
        }

        ddlSales.Items.Clear();
        ddlSales.Items.Add(new ListItem("业务员", "-1"));
        DataTable dtSales = CRM.Common.InitData.GetSalesByCid(Session["CID"].ToString());
        if (dtSales.Rows.Count > 0)
        {
            for (int i = 0; i < dtSales.Rows.Count; i++)
            {
                ddlSales.Items.Add(new ListItem(dtSales.Rows[i]["姓名"].ToString(), dtSales.Rows[i]["eid"].ToString()));
            }
        }

        ClientRate clientRate = new ClientRate();
        IList<ClientRateInfo> ClientRateinfo = new List<ClientRateInfo>();
        ddlClientRate.Items.Clear();
        ddlClientRate.Items.Add(new ListItem("进度", "-1"));
        ClientRateinfo = clientRate.GetClientRateByCid(Session["CID"].ToString());
        if (ClientRateinfo.Count > 0)
        {
            for (int i = 0; i < ClientRateinfo.Count; i++)
            {
                ddlClientRate.Items.Add(new ListItem(ClientRateinfo[i].进度名称.ToString(), ClientRateinfo[i].ID.ToString()));
            }
        }

        ClientFeedbackType clientFeedbackType = new ClientFeedbackType();
        IList<ClientFeedbackTypeInfo> ClientFeedbackTypeinfo = new List<ClientFeedbackTypeInfo>();
        ddlFeedbackType.Items.Clear();
        ddlFeedbackType.Items.Add(new ListItem("联系类型", "-1"));
        ClientFeedbackTypeinfo = clientFeedbackType.GetClientFeedbackTypeByCid(Session["CID"].ToString());
        if (ClientFeedbackTypeinfo.Count > 0)
        {
            for (int i = 0; i < ClientFeedbackTypeinfo.Count; i++)
            {
                ddlFeedbackType.Items.Add(new ListItem(ClientFeedbackTypeinfo[i].联系类型.ToString(), ClientFeedbackTypeinfo[i].ID.ToString()));
            }
        }



    }
    public string CommandName
    {
        get { return _CommandName; }
    }
    public int PageIndex {
        get { return _PageIndex; }
    }
    public void Bind() {
        string[] eids = CRM.Common.InitData.GetEmployeesLookRightEids(Session["LoginID"].ToString(), Session["CID"].ToString());

        ClientContact clientContact = new ClientContact();
        GridView1.DataSource = clientContact.GetClientContactByCondition(Session["CID"].ToString(), eids, Calendar1.Text.Trim(), Calendar2.Text.Trim(), txtClientName.Text.Trim(), ddlProvince.SelectedValue.ToString(), ddlCity.SelectedValue.ToString(), ddlSales.SelectedValue.ToString(),ddlClientRate.SelectedValue.ToString(),ddlFeedbackType.SelectedValue.ToString(),ddlContactType.SelectedValue.ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();
    }
    public void Bind(string ClientID) {
        #region
        if (!String.IsNullOrEmpty(ClientID))
        {
            ClientContact clientContact = new ClientContact();
            GridView1.DataSource = clientContact.GetClientContactByClientID(Session["CID"].ToString(), ClientID);
            GridView1.DataKeyNames = new string[] { "id" };
            GridView1.DataBind();
        }
        #endregion
        else {
            string[] eids = CRM.Common.InitData.GetEmployeesLookRightEids(Session["LoginID"].ToString(), Session["CID"].ToString());

            ClientContact clientContact = new ClientContact();
            GridView1.DataSource = clientContact.GetClientContactByCondition(Session["CID"].ToString(), eids, Calendar1.Text.Trim(), Calendar2.Text.Trim(), txtClientName.Text.Trim(), ddlProvince.SelectedValue.ToString(), ddlCity.SelectedValue.ToString(), ddlSales.SelectedValue.ToString(), ddlClientRate.SelectedValue.ToString(), ddlFeedbackType.SelectedValue.ToString(), ddlContactType.SelectedValue.ToString());
            GridView1.DataKeyNames = new string[] { "id" };
            GridView1.DataBind();
        }
    }
    public void Bind(string ClientID, string ClientName,string SelectedIndex)
    {
        _ClientName = ClientName;
        _SelectedIndex = SelectedIndex;
        _ClientID = ClientID;
        #region
        if (!String.IsNullOrEmpty(ClientID))
        {
            ClientContact clientContact = new ClientContact();
            GridView1.DataSource = clientContact.GetClientContactByClientID(Session["CID"].ToString(), ClientID);
            GridView1.DataKeyNames = new string[] { "id" };
            GridView1.DataBind();
        }
        #endregion
        else {
            string[] eids = CRM.Common.InitData.GetEmployeesLookRightEids(Session["LoginID"].ToString(), Session["CID"].ToString());

            ClientContact clientContact = new ClientContact();
            GridView1.DataSource = clientContact.GetClientContactByCondition(Session["CID"].ToString(), eids, Calendar1.Text.Trim(), Calendar2.Text.Trim(), txtClientName.Text.Trim(), ddlProvince.SelectedValue.ToString(), ddlCity.SelectedValue.ToString(), ddlSales.SelectedValue.ToString(), ddlClientRate.SelectedValue.ToString(), ddlFeedbackType.SelectedValue.ToString(), ddlContactType.SelectedValue.ToString());
            GridView1.DataKeyNames = new string[] { "id" };
            GridView1.DataBind();
        }

        //txtClientName.Text = ClientList1.ClientName;
    }

    protected void Button1_Click(object sender, EventArgs e) {
        Bind();
    }
    protected void ddlProvince_TextChanged(object sender, EventArgs e)
    {
        ddlCity.Items.Clear();
        ddlCity.Items.Add(new ListItem("地区", "-1"));
        DataTable dtCity = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        if (dtCity.Rows.Count > 0)
        {
            for (int i = 0; i < dtCity.Rows.Count; i++)
            {
                ddlCity.Items.Add(new ListItem(dtCity.Rows[i]["名称"].ToString(), dtCity.Rows[i]["id"].ToString()));
            }
        }
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        _PageIndex = e.NewPageIndex;
        if (null != PageIndexChanging) {
            PageIndexChanging(this,e);
        }
        
    }
    //protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    //{
    //    //string id = GridView1.DataKeys[e.RowIndex].Values["id"].ToString();

    //    //ClientContact clientcontact = new ClientContact();
    //    //clientcontact.ClientContactDeleteByID(id);
    //    //Bind();
    //}
   
    //protected void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    //{
    //    //int index = GridView1.SelectedIndex;

    //    //IList<ClientContactInfo> ClientContactinfo = new List<ClientContactInfo>();
    //    //ClientContact clientcontact = new ClientContact();
    //    //ClientContactinfo = clientcontact.GetClientContactByID(GridView1.DataKeys[index].Values["id"].ToString());

    //    //if (ClientContactinfo.Count > 0)
    //    //{
    //    //    txtDemand.Text = ClientContactinfo[0].需求意向;
    //    //    ddlSales.SelectedValue = ClientContactinfo[0].业务员.ToString();
    //    //    ddlFeedbackType.SelectedValue = ClientContactinfo[0].联系反馈类型.ToString();
    //    //    txtTitle.Text = ClientContactinfo[0].主题;
    //    //    txtContent.Text = ClientContactinfo[0].内容描述;
    //    //    txtDateTime1.Text = ClientContactinfo[0].添加日期.ToShortDateString();
    //    //    rblImportantance.SelectedValue = ClientContactinfo[0].重要程度.ToString();
    //    //    rblIsEnd.SelectedValue = ClientContactinfo[0].是否完成.ToString();
    //    //    txtDateTime2.Text = ClientContactinfo[0].完成日期.ToShortDateString();
    //    //}

    //}
    public void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (null != RowCommand)
        {
            _CommandName = e.CommandName;
            RowCommand(this, e);
        }
    }
    public void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (null != SelectedIndexChanged)
        {
            _ClientName = GridView1.Rows[GridView1.SelectedIndex].Cells[0].Text;
            _ClientID = GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString();
            SelectedIndexChanged(this, e);
        }
    }
    protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.Header)
        {
            GridViewRow rowHeader = new GridViewRow(0, 0, DataControlRowType.Header, DataControlRowState.Normal);
            rowHeader.BackColor = System.Drawing.Color.FromName("#C1D9F3");
            rowHeader.Font.Bold = true;


            TableCellCollection cells = e.Row.Cells;
            TableCell headerCell = new TableCell();
            headerCell.ColumnSpan = cells.Count;
            headerCell.HorizontalAlign = System.Web.UI.WebControls.HorizontalAlign.Left;
            rowHeader.Cells.Add(headerCell);
            rowHeader.Visible = true;

            Button btnDel = new Button();
            btnDel.Text = "删除联系";
            btnDel.CommandName = "DEL";
            rowHeader.Cells[0].Controls.Add(btnDel);

            Button btnAdd = new Button();
            btnAdd.Text = "增加联系";
            btnAdd.CommandName = "ADD";
            rowHeader.Cells[0].Controls.Add(btnAdd);

            GridView1.Controls[0].Controls.AddAt(0, rowHeader);
            //GridView1.Controls[0].Controls.RemoveAt(0);
        }
    }

    public void GridView1_DataBound(object sender, EventArgs e)
    {
        if (null != RowDataBound)
        {
            RowDataBound(this, e);
        }
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack) {
            Init_Data();
            Bind(Request.QueryString["ClientID"]);
        }
    }
}
