﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Controls_Client_ClientInfoControl : System.Web.UI.UserControl
{
    public void InitData()
    {
        ddlProvince.Items.Clear();
        ddlProvince.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtProvince = CRM.Common.InitData.GetProvinceByCid(Session["CID"].ToString());
        if (dtProvince.Rows.Count > 0)
        {
            for (int i = 0; i < dtProvince.Rows.Count; i++)
            {
                ddlProvince.Items.Add(new ListItem(dtProvince.Rows[i]["名称"].ToString(), dtProvince.Rows[i]["id"].ToString()));
            }
        }

        ddlCity.Items.Clear();
        ddlCity.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtCity = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        if (dtCity.Rows.Count > 0)
        {
            for (int i = 0; i < dtCity.Rows.Count; i++)
            {
                ddlCity.Items.Add(new ListItem(dtCity.Rows[i]["名称"].ToString(), dtCity.Rows[i]["id"].ToString()));
            }
        }
        else {
            ddlCity.Items.Add(new ListItem("请选择", "-1"));
        }

        ddlSales.Items.Clear();
        ddlSales.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtSales = CRM.Common.InitData.GetSalesByCid(Session["CID"].ToString());
        if (dtSales.Rows.Count > 0)
        {
            for (int i = 0; i < dtSales.Rows.Count; i++)
            {
                ddlSales.Items.Add(new ListItem(dtSales.Rows[i]["姓名"].ToString(), dtSales.Rows[i]["eid"].ToString()));
            }
        }

        ddlClientType.Items.Clear();
        ddlClientType.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtClientType = CRM.Common.InitData.InitData_ClientType(Session["CID"].ToString());
        if (dtClientType.Rows.Count > 0) {
            for (int i = 0; i < dtClientType.Rows.Count; i++)
            {
                ddlClientType.Items.Add(new ListItem(dtClientType.Rows[i]["客户类型"].ToString(), dtClientType.Rows[i]["id"].ToString()));
            }
        }

        ddlClientPhase.Items.Clear();
        ddlClientPhase.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtClientPhase = CRM.Common.InitData.InitData_ClientPhase(Session["CID"].ToString());
        if (dtClientPhase.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientPhase.Rows.Count; i++)
            {
                ddlClientPhase.Items.Add(new ListItem(dtClientPhase.Rows[i]["客户阶段"].ToString(), dtClientPhase.Rows[i]["id"].ToString()));
            }
        }

        ddlClientStatus.Items.Clear();
        ddlClientStatus.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtClientStatus = CRM.Common.InitData.InitData_ClientStatus(Session["CID"].ToString());
        if (dtClientStatus.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientStatus.Rows.Count; i++)
            {
                ddlClientStatus.Items.Add(new ListItem(dtClientStatus.Rows[i]["客户状态"].ToString(), dtClientStatus.Rows[i]["id"].ToString()));
            }
        }

        ddlClientRank.Items.Clear();
        ddlClientRank.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtClientRank = CRM.Common.InitData.InitData_ClientRank(Session["CID"].ToString());
        if (dtClientRank.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientRank.Rows.Count; i++)
            {
                ddlClientRank.Items.Add(new ListItem(dtClientRank.Rows[i]["客户级别"].ToString(), dtClientRank.Rows[i]["id"].ToString()));
            }
        }

        ddlClientIndustry.Items.Clear();
        ddlClientIndustry.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtClientIndustry = CRM.Common.InitData.InitData_ClientIndustry(Session["CID"].ToString());
        if (dtClientIndustry.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientIndustry.Rows.Count; i++)
            {
                ddlClientIndustry.Items.Add(new ListItem(dtClientIndustry.Rows[i]["客户行业"].ToString(), dtClientIndustry.Rows[i]["id"].ToString()));
            }
        }
    }

    protected void ddlProvince_TextChanged(object sender, EventArgs e) {
        ddlCity.DataSource = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        ddlCity.DataTextField = "名称";
        ddlCity.DataValueField = "id";
        ddlCity.DataBind();
    }
    //protected void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e)
    //{
    //    int index = e.NewSelectedIndex;


    //    IList<ClientBasicInfo> clientbasicinfo = new List<ClientBasicInfo>();

    //    ClientBasic clientBasic = new ClientBasic();
    //    clientbasicinfo = clientBasic.GetClientBasicById(GridView1.DataKeys[index].Values["id"].ToString());

    //    if (clientbasicinfo.Count > 0)
    //    {
    //        txtClientName.Text = clientbasicinfo[0].客户名称;
    //        txtClientTel.Text = clientbasicinfo[0].客户电话;
    //        txtClientSax.Text = clientbasicinfo[0].客户传真;
    //        txtContacter.Text = clientbasicinfo[0].主联系人;
    //        txtContactMobile.Text = clientbasicinfo[0].联系手机;
    //        txtAddr.Text = clientbasicinfo[0].详细地址;
    //        txtClientEmail.Text = clientbasicinfo[0].电子邮箱;
    //        ddlSales.SelectedValue = clientbasicinfo[0].业务员.ToString();
    //        ddlClientType.SelectedValue = clientbasicinfo[0].客户类型.ToString();
    //        ddlClientPhase.SelectedValue = clientbasicinfo[0].客户阶段.ToString();
    //        ddlClientStatus.SelectedValue = clientbasicinfo[0].客户状态.ToString();
    //        ddlClientRank.SelectedValue = clientbasicinfo[0].客户级别.ToString();
    //        txtBz.Text = clientbasicinfo[0].备注;

    //        if (ddlSales.SelectedValue != Session["LoginID"].ToString())
    //        {
    //            Button2.Enabled = false;
    //        }
    //        else
    //        {
    //            Button2.Enabled = true;
    //        }

    //    }

    //}
    //protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    //{
    //    int index = e.RowIndex;
    //    ClientBasic clientBasic = new ClientBasic();
    //    clientBasic.ClientBasicDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

    //    Bind();

    //}
    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientBasicInfo clientbasicinfo = new ClientBasicInfo();

        clientbasicinfo.客户名称 = txtClientName.Text;
        clientbasicinfo.客户电话 = txtClientTel.Text;
        clientbasicinfo.客户传真 = txtClientSax.Text;
        clientbasicinfo.主联系人 = txtContacter.Text;
        clientbasicinfo.联系手机 = txtContactMobile.Text;
        clientbasicinfo.详细地址 = txtAddr.Text;
        clientbasicinfo.电子邮箱 = txtClientEmail.Text;
        clientbasicinfo.业务员 = Int32.Parse(Session["LoginID"].ToString());
        clientbasicinfo.客户类型 = Int32.Parse(ddlClientType.SelectedValue);
        clientbasicinfo.客户阶段 = Int32.Parse(ddlClientPhase.SelectedValue);
        clientbasicinfo.客户状态 = Int32.Parse(ddlClientStatus.SelectedValue);
        clientbasicinfo.客户级别 = Int32.Parse(ddlClientRank.SelectedValue);
        clientbasicinfo.备注 = txtBz.Text.Trim();
        clientbasicinfo.部门 = txtContactDepartment.Text.Trim();
        clientbasicinfo.职务 = txtContactRole.Text.Trim();
        clientbasicinfo.省份 = Int32.Parse(ddlProvince.SelectedValue);
        clientbasicinfo.地区 = Int32.Parse(ddlCity.SelectedValue);
        clientbasicinfo.CID = Int32.Parse(Session["CID"].ToString());
        clientbasicinfo.行业 = Int32.Parse(ddlClientIndustry.SelectedValue);

        string existence=CRM.Common.InitData.CheckClientExistence(Session["CID"].ToString(),txtClientName.Text.Trim());
        //if (existence=="")
        //{
            ClientBasic clientBasic = new ClientBasic();
            clientBasic.ClientBasicAdd(clientbasicinfo);

            Label1.Text = "添加成功";
            //if (!Page.ClientScript.IsClientScriptBlockRegistered("AddClient")) {
            //    Page.RegisterClientScriptBlock("AddClient","<script>alert('添加成功')</script>");
            //}
        //}
        //else {
        //    Label1.Text = "客户已存在!业务员：" + CRM.Common.InitData.GetSalesName(existence) ;
        //    //if (!Page.ClientScript.IsClientScriptBlockRegistered("ClientExistence"))
        //    //{
        //    //    Page.RegisterClientScriptBlock("ClientExistence", "<script>alert('客户已存在!业务员：" + CRM.Common.InitData.GetSalesName(existence) + "')</script>");
        //    //}
        //}

        ClearData();
        ddlSales.SelectedValue = Session["LoginID"].ToString();

    }
    protected void Button2_Click(object sender, EventArgs e)
    {        
        ClientBasicInfo clientbasicinfo = new ClientBasicInfo();

        clientbasicinfo.ID = Int32.Parse(Request.QueryString["ClientID"].ToString());
        clientbasicinfo.客户名称 = txtClientName.Text;
        clientbasicinfo.客户电话 = txtClientTel.Text;
        clientbasicinfo.客户传真 = txtClientSax.Text;
        clientbasicinfo.主联系人 = txtContacter.Text;
        clientbasicinfo.联系手机 = txtContactMobile.Text;
        clientbasicinfo.详细地址 = txtAddr.Text;
        clientbasicinfo.电子邮箱 = txtClientEmail.Text;
        clientbasicinfo.业务员 = Int32.Parse(Session["LoginID"].ToString());
        clientbasicinfo.客户类型 = Int32.Parse(ddlClientType.SelectedValue);
        clientbasicinfo.客户阶段 = Int32.Parse(ddlClientPhase.SelectedValue);
        clientbasicinfo.客户状态 = Int32.Parse(ddlClientStatus.SelectedValue);
        clientbasicinfo.客户级别 = Int32.Parse(ddlClientRank.SelectedValue);
        clientbasicinfo.备注 = txtBz.Text;
        clientbasicinfo.部门 = txtContactDepartment.Text.Trim();
        clientbasicinfo.职务 = txtContactRole.Text.Trim();
        clientbasicinfo.省份 = Int32.Parse(ddlProvince.SelectedValue);
        clientbasicinfo.地区 = Int32.Parse(ddlCity.SelectedValue);
        clientbasicinfo.行业 = Int32.Parse(ddlClientIndustry.SelectedValue);

        ClientBasic clientBasic = new ClientBasic();
        clientBasic.ClientBasicUpdateById(clientbasicinfo);

        Label1.Text = "修改成功";
    }
    protected void ClearData() {
        txtClientName.Text = "";
        txtAddr.Text = "";
        txtContacter.Text = "";
        txtContactMobile.Text = "";
        txtClientSax.Text = "";
        txtClientTel.Text = "";
        txtClientEmail.Text = "";
        InitData();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            //InitData();
            ddlCity.Items.Add(new ListItem("请选择", "-1"));
        }

    }

}
