﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Controls_Person_PersonInfoControl : System.Web.UI.UserControl
{
    public void Bind(string eid) {
        IList<EmployeesInfo> employeesinfo = new List<EmployeesInfo>();

        Employees employees = new Employees();
        employeesinfo = employees.GetEmployeesById(eid);

        if (employeesinfo.Count > 0)
        {
            txtEmployeesLoginName.Text = employeesinfo[0].登录名;
            txtEmployeesName.Text = employeesinfo[0].姓名;
            txtEmployeesPWD.Text = employeesinfo[0].密码;
            txtEmployeesPWD.Attributes.Add("Value", employeesinfo[0].密码);
            ddlDepartment.SelectedValue = employeesinfo[0].部门.ToString();
            ddlRole.SelectedValue = employeesinfo[0].角色.ToString();
            txtMobile.Text = employeesinfo[0].手机;
            txtTel.Text = employeesinfo[0].住宅电话;
            ddlRight.SelectedValue = employeesinfo[0].所属权限组.ToString();
            ddlStatus.SelectedValue = employeesinfo[0].用户状态.ToString();
            txtBz.Text = employeesinfo[0].备注;
        }
    }
    public void Init_Enable() {
        ddlDepartment.Enabled = false;
        ddlRight.Enabled = false;
        ddlRole.Enabled = false;
        ddlStatus.Enabled = false;
    }

    protected void InitData()
    {
        ddlRight.Items.Clear();
        ddlRight.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtRight = CRM.Common.InitData.GetRightByCid(Session["CID"].ToString());
        if (dtRight.Rows.Count > 0)
        {
            for (int i = 0; i < dtRight.Rows.Count; i++)
            {
                ddlRight.Items.Add(new ListItem(dtRight.Rows[i]["权限组名称"].ToString(), dtRight.Rows[i]["id"].ToString()));
            }
        }

        ddlDepartment.Items.Clear();
        ddlDepartment.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtDepartment = CRM.Common.InitData.GetDepartmentByCid(Session["CID"].ToString());
        if (dtDepartment.Rows.Count > 0)
        {
            for (int i = 0; i < dtDepartment.Rows.Count; i++)
            {
                ddlDepartment.Items.Add(new ListItem(dtDepartment.Rows[i]["部门名称"].ToString(), dtDepartment.Rows[i]["id"].ToString()));
            }
        }

        ddlRole.Items.Clear();
        ddlRole.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtRole = CRM.Common.InitData.GetRoleByCid(Session["CID"].ToString());
        if (dtRole.Rows.Count > 0)
        {
            for (int i = 0; i < dtRole.Rows.Count; i++)
            {
                ddlRole.Items.Add(new ListItem(dtRole.Rows[i]["角色名称"].ToString(), dtRole.Rows[i]["id"].ToString()));
            }
        }
    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        IList<EmployeesInfo> employeesinfos = new List<EmployeesInfo>();
        EmployeesInfo employeesinfo = new EmployeesInfo();

        Employees employees = new Employees();

        employeesinfos = employees.GetEmployeesById(Session["LoginID"].ToString());
        if (employeesinfos.Count > 0)
        {

            employeesinfo.登录名 = txtEmployeesLoginName.Text.Trim();
            employeesinfo.姓名 = txtEmployeesName.Text.Trim();
            employeesinfo.密码 = txtEmployeesPWD.Text.Trim();
            employeesinfo.部门 = employeesinfos[0].部门;
            employeesinfo.角色 = Int32.Parse(ddlRole.SelectedValue.ToString());
            employeesinfo.手机 = txtMobile.Text;
            employeesinfo.住宅电话 = txtTel.Text;
            employeesinfo.所属权限组 = employeesinfos[0].所属权限组;
            employeesinfo.用户状态 = Int32.Parse(ddlStatus.SelectedValue.ToString());
            employeesinfo.备注 = txtBz.Text;
            employeesinfo.CID = Int32.Parse(Session["CID"].ToString());
            employeesinfo.EID = Int32.Parse(Session["LoginID"].ToString());

            employees.EmployeesUpdateById(employeesinfo);
        }

    }
    protected string LoginName_TextChanged()
    {
        string temp = "";
        string existence = CRM.Common.InitData.CheckLoginNameExistence(txtEmployeesLoginName.Text.Trim());
        if (existence != "")
        {
            Lable1.Text = "登录名已存在，请修改！";
            txtEmployeesLoginName.Text = "";
            temp = "1";
        }
        else
        {
            Lable1.Text = "";
        }
        return temp;
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
            InitData();
    }
}
