﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;

using CRM.BLL;
using CRM.Model;
using CRM.Common;


public partial class Pages_Client_ClientContactInfo : System.Web.UI.Page
{
    protected void Init_Data()
    {
        ClientFeedbackType clientFeedbackType = new ClientFeedbackType();
        IList<ClientFeedbackTypeInfo> ClientFeedbackTypeinfo = new List<ClientFeedbackTypeInfo>();
        ddlFeedbackType.Items.Clear();
        ddlFeedbackType.Items.Add(new ListItem("请选择", "-1"));
        ClientFeedbackTypeinfo = clientFeedbackType.GetClientFeedbackTypeByCid(Session["CID"].ToString());
        if (ClientFeedbackTypeinfo.Count > 0)
        {
            for (int i = 0; i < ClientFeedbackTypeinfo.Count; i++)
            {
                ddlFeedbackType.Items.Add(new ListItem(ClientFeedbackTypeinfo[i].联系类型.ToString(), ClientFeedbackTypeinfo[i].ID.ToString()));
            }
        }
        

        ddlSales.Items.Clear();
        ddlSales.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtSales = CRM.Common.InitData.GetSalesByCid(Session["CID"].ToString());
        if (dtSales.Rows.Count > 0)
        {
            for (int i = 0; i < dtSales.Rows.Count; i++)
            {
                ddlSales.Items.Add(new ListItem(dtSales.Rows[i]["姓名"].ToString(), dtSales.Rows[i]["eid"].ToString()));
            }
        }

        //ddlSales.SelectedValue = Session["LoginID"].ToString();
        ClientRate clientRate = new ClientRate();
        IList<ClientRateInfo> ClientRateinfo = new List<ClientRateInfo>();
        rblClientRate.Items.Clear();
        rblClientRate.Items.Add(new ListItem("请选择", "-1"));
        ClientRateinfo = clientRate.GetClientRateByCid(Session["CID"].ToString());
        if (ClientRateinfo.Count > 0)
        {
            for (int i = 0; i < ClientRateinfo.Count; i++)
            {
                rblClientRate.Items.Add(new ListItem(ClientRateinfo[i].进度名称.ToString()+":"+ClientRateinfo[i].进度描述.ToString(), ClientRateinfo[i].ID.ToString()));
            }
        }
        rblClientRate.SelectedIndex = 0;

        txtDateTime1.Text = DateTime.Now.ToShortDateString();
        txtDateTime2.Text = DateTime.Now.ToShortDateString();

        if (rblIsEnd.SelectedValue == "0")
        {
            Panel1.Visible = false;
        }
        else
        {
            Panel1.Visible = true;
        }

        
    }
    protected void Bind()
    {
        #region  新增联系信息
        if (!String.IsNullOrEmpty(Request.QueryString["ClientContactID"]) && !Request.QueryString["ClientContactID"].Equals("-1"))
        {
            IList<ClientContactInfo> ClientContactinfo = new List<ClientContactInfo>();

            ClientContact clientContact = new ClientContact();
            ClientContactinfo = clientContact.GetClientContactByID(Request.QueryString["ClientContactID"].ToString());

            if (ClientContactinfo.Count > 0)
            {
                txtClientName.Text = CRM.Common.InitData.GetClientName(ClientContactinfo[0].客户ID.ToString()).ToString();
                txtDemand.Text = ClientContactinfo[0].需求意向;
                ddlSales.SelectedValue = ClientContactinfo[0].业务员.ToString();
                ddlSales.Enabled = false;

                ddlFeedbackType.SelectedValue = ClientContactinfo[0].联系反馈类型.ToString();
                txtTitle.Text = ClientContactinfo[0].主题;
                txtContent.Text = ClientContactinfo[0].内容描述;
                rblClientRate.SelectedValue = ClientContactinfo[0].进度.ToString();
                txtDateTime1.Text = ClientContactinfo[0].添加日期.ToShortDateString();
                txtDateTime2.Text = ClientContactinfo[0].完成日期.ToShortDateString();
                rblImportantance.SelectedValue = ClientContactinfo[0].重要程度.ToString();
                rblIsEnd.SelectedValue = ClientContactinfo[0].是否完成.ToString();

                rblContactType.SelectedValue = ClientContactinfo[0].联系方式.ToString();
                if (rblIsEnd.SelectedValue == "0")
                {
                    Panel1.Visible = false;
                }
                else
                {
                    Panel1.Visible = true;
                }

                if (ClientContactinfo[0].业务员.ToString() != Session["LoginID"].ToString())
                {
                    Button2.Visible = false;
                }
                else
                {
                    Button2.Visible = true;
                }
                Button1.Visible = false;
            }
            else {
                Button1.Visible = true;
                Button2.Visible = false;
            }
        }
        #endregion
        else
        {
            txtClientName.Text = CRM.Common.InitData.GetClientName(Request.QueryString["ClientID"]).ToString();
            ddlSales.SelectedValue = Session["LoginID"].ToString();
            ddlSales.Enabled = false;
            Button1.Visible = true;
            Button2.Visible = false;
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientContactInfo ClientContactinfo = new ClientContactInfo();

        ClientContactinfo.CID = Int32.Parse(Session["CID"].ToString());
        ClientContactinfo.客户ID = Int32.Parse(Request.QueryString["ClientID"].ToString());
        ClientContactinfo.联系反馈类型 = Int32.Parse(ddlFeedbackType.SelectedValue);
        ClientContactinfo.主题 = txtTitle.Text.Trim();
        ClientContactinfo.内容描述 = txtContent.Text.Trim();
        ClientContactinfo.进度 =Int32.Parse(rblClientRate.SelectedValue);
        ClientContactinfo.需求意向 = txtDemand.Text.Trim();
        ClientContactinfo.添加日期 = DateTime.Parse(txtDateTime1.Text.Trim());
        ClientContactinfo.重要程度 = Int32.Parse(rblImportantance.SelectedValue);
        ClientContactinfo.是否完成 = Int32.Parse(rblIsEnd.SelectedValue);
        ClientContactinfo.完成日期 = DateTime.Parse(txtDateTime2.Text.Trim());
        ClientContactinfo.创建日期 = DateTime.Parse(DateTime.Now.ToString());
        ClientContactinfo.业务员 = Int32.Parse(Session["LoginID"].ToString());
        ClientContactinfo.联系方式 = Int32.Parse(rblContactType.SelectedValue);


        ClientContact clientcontact = new ClientContact();
        clientcontact.ClientContactAdd(ClientContactinfo);

        Label1.Text = "添加成功";
        //Bind();

    }
    protected void Button2_Click(object sender, EventArgs e)
    {
        ClientContactInfo ClientContactinfo = new ClientContactInfo();

        ClientContactinfo.CID = Int32.Parse(Session["CID"].ToString());
        ClientContactinfo.客户ID = Int32.Parse(Request.QueryString["ClientID"].ToString());
        ClientContactinfo.联系反馈类型 = Int32.Parse(ddlFeedbackType.SelectedValue);
        ClientContactinfo.主题 = txtTitle.Text.Trim();
        ClientContactinfo.内容描述 = txtContent.Text.Trim();
        ClientContactinfo.进度 = Int32.Parse(rblClientRate.SelectedValue);
        ClientContactinfo.需求意向 = txtDemand.Text.Trim();
        ClientContactinfo.添加日期 = DateTime.Parse(txtDateTime1.Text.Trim());
        ClientContactinfo.重要程度 = Int32.Parse(rblImportantance.SelectedValue);
        ClientContactinfo.是否完成 = Int32.Parse(rblIsEnd.SelectedValue);
        ClientContactinfo.完成日期 = DateTime.Parse(txtDateTime2.Text.Trim());
        ClientContactinfo.创建日期 = DateTime.Parse(DateTime.Now.ToString());
        ClientContactinfo.业务员 = Int32.Parse(Session["LoginID"].ToString());
        ClientContactinfo.ID = Int32.Parse(Request.QueryString["ClientContactID"].ToString());
        ClientContactinfo.联系方式 = Int32.Parse(rblContactType.SelectedValue);

        ClientContact clientcontact = new ClientContact();
        clientcontact.ClientContactEdit(ClientContactinfo);

        Label1.Text = "修改成功！";

    }
    protected void rblIsEnd_TextChanged(object sender,EventArgs e) {
        if (rblIsEnd.SelectedValue == "0")
        {
            Panel1.Visible = false;
        }
        else
        {
            Panel1.Visible = true;
        }

    }

    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            HyperLink1.NavigateUrl = "ClientContact.aspx?ClientID=" + Request.QueryString["ClientID"]+"&ClientName="+Request.QueryString["ClientName"]+"&SelectedIndex="+Request.QueryString["SelectedIndex"];
            Init_Data();
            Bind();
        }
    }
}
