﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;
using System.Data.SqlClient;

public partial class Pages_Client_ClientModify : CRM.Common.Login
{
    private string _ClientID;
    private string _CommandName;
    private string _ClientName;
    private int _GridViewSelectedIndex;

    public event EventHandler SelectedIndexChanged;
    public event GridViewCommandEventHandler RowCommand;
    public event EventHandler RowDataBound;

    public string ClientID
    {
        get
        {
            if (GridView1.SelectedIndex > -1)
            {
                return GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString();
            }
            return "";
        }
    }
    public int GridviewSelectedIndex
    {
        get { return GridView1.SelectedIndex; }
    }
    public string ClientName
    {
        get { return _ClientName; }
        set { _ClientName = value; }
    }
    public string CommandName
    {
        get { return _CommandName; }
    }
    protected void Init_Data()
    {
        ddlProvince.Items.Clear();
        ddlProvince.Items.Add(new ListItem("省份", "-1"));
        DataTable dtProvince = CRM.Common.InitData.GetProvinceByCid(Session["CID"].ToString());
        if (dtProvince.Rows.Count > 0)
        {
            for (int i = 0; i < dtProvince.Rows.Count; i++)
            {
                ddlProvince.Items.Add(new ListItem(dtProvince.Rows[i]["名称"].ToString(), dtProvince.Rows[i]["id"].ToString()));
            }
        }

        ddlCity.Items.Clear();
        ddlCity.Items.Add(new ListItem("地区", "-1"));
        DataTable dtCity = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        if (dtCity.Rows.Count > 0)
        {
            for (int i = 0; i < dtCity.Rows.Count; i++)
            {
                ddlCity.Items.Add(new ListItem(dtCity.Rows[i]["名称"].ToString(), dtCity.Rows[i]["id"].ToString()));
            }
        }

        ddlSales.Items.Clear();
        ddlSales.Items.Add(new ListItem("业务员", "-1"));
        DataTable dtSales = CRM.Common.InitData.GetSalesByCid(Session["CID"].ToString());
        if (dtSales.Rows.Count > 0)
        {
            for (int i = 0; i < dtSales.Rows.Count; i++)
            {
                ddlSales.Items.Add(new ListItem(dtSales.Rows[i]["姓名"].ToString(), dtSales.Rows[i]["eid"].ToString()));
            }
        }

        ddlClientType.Items.Clear();
        ddlClientType.Items.Add(new ListItem("客户类型", "-1"));
        DataTable dtClientType = CRM.Common.InitData.InitData_ClientType(Session["CID"].ToString());
        if (dtClientType.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientType.Rows.Count; i++)
            {
                ddlClientType.Items.Add(new ListItem(dtClientType.Rows[i]["客户类型"].ToString(), dtClientType.Rows[i]["id"].ToString()));
            }
        }

        DropDownList4.Items.Clear();
        DropDownList4.Items.Add(new ListItem("请选择", "-1"));
        DataTable ddl4 = CRM.Common.InitData.InitData_ClientType(Session["CID"].ToString());
        if (ddl4.Rows.Count > 0)
        {
            for (int i = 0; i < ddl4.Rows.Count; i++)
            {
                DropDownList4.Items.Add(new ListItem(ddl4.Rows[i]["客户类型"].ToString(), ddl4.Rows[i]["id"].ToString()));

            }
        }



        ddlClientPhase.Items.Clear(); 
        ddlClientPhase.Items.Add(new ListItem("客户阶段", "-1"));
        DataTable dtClientPhase = CRM.Common.InitData.InitData_ClientPhase(Session["CID"].ToString());
        if (dtClientPhase.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientPhase.Rows.Count; i++)
            {
                ddlClientPhase.Items.Add(new ListItem(dtClientPhase.Rows[i]["客户阶段"].ToString(), dtClientPhase.Rows[i]["id"].ToString()));
                DropDownList3.Items.Add(new ListItem(dtClientPhase.Rows[i]["客户阶段"].ToString(), dtClientPhase.Rows[i]["id"].ToString()));

            }
        }

        DropDownList3.Items.Clear();
        DropDownList3.Items.Add(new ListItem("请选择", "-1"));
        DataTable ddl3 = CRM.Common.InitData.InitData_ClientPhase(Session["CID"].ToString());
        if (ddl3.Rows.Count > 0)
        {
            for (int i = 0; i < ddl3.Rows.Count; i++)
            {
                DropDownList3.Items.Add(new ListItem(ddl3.Rows[i]["客户阶段"].ToString(), ddl3.Rows[i]["id"].ToString()));

            }
        }



        ddlClientStatus.Items.Clear();
        ddlClientStatus.Items.Add(new ListItem("客户状态", "-1"));
        DataTable dtClientStatus = CRM.Common.InitData.InitData_ClientStatus(Session["CID"].ToString());
        if (dtClientStatus.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientStatus.Rows.Count; i++)
            {
                ddlClientStatus.Items.Add(new ListItem(dtClientStatus.Rows[i]["客户状态"].ToString(), dtClientStatus.Rows[i]["id"].ToString()));
            }
        }

        ddlClientRank.Items.Clear();
        ddlClientRank.Items.Add(new ListItem("客户级别", "-1"));
        DataTable dtClientRank = CRM.Common.InitData.InitData_ClientRank(Session["CID"].ToString());
        if (dtClientRank.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientRank.Rows.Count; i++)
            {
                ddlClientRank.Items.Add(new ListItem(dtClientRank.Rows[i]["客户级别"].ToString(), dtClientRank.Rows[i]["id"].ToString()));
            }
        }

        ddlClientIndustry.Items.Clear();
        ddlClientIndustry.Items.Add(new ListItem("行业", "-1"));
        DataTable dtClientIndustry = CRM.Common.InitData.InitData_ClientIndustry(Session["CID"].ToString());
        if (dtClientIndustry.Rows.Count > 0)
        {
            for (int i = 0; i < dtClientIndustry.Rows.Count; i++)
            {
                ddlClientIndustry.Items.Add(new ListItem(dtClientIndustry.Rows[i]["客户行业"].ToString(), dtClientIndustry.Rows[i]["id"].ToString()));
            }
        }
    }

    protected void ddlProvince_TextChanged(object sender, EventArgs e)
    {
        ddlCity.Items.Clear();
        ddlCity.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtCity = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        if (dtCity.Rows.Count > 0)
        {
            for (int i = 0; i < dtCity.Rows.Count; i++)
            {
                ddlCity.Items.Add(new ListItem(dtCity.Rows[i]["名称"].ToString(), dtCity.Rows[i]["id"].ToString()));
            }
        }
    }
    public void Bind()
    {
        string[] eids = CRM.Common.InitData.GetEmployeesLookRightEids(Session["LoginID"].ToString(), Session["CID"].ToString());
        ClientBasic clientBasic = new ClientBasic();

        GridView1.DataSource = clientBasic.GetClientBasicByConditions(eids, txtClientName.Text.Trim(), txtCantactName.Text.Trim(), ddlProvince.SelectedValue.ToString(), ddlCity.SelectedValue.ToString(), ddlSales.SelectedValue.ToString(), ddlClientType.SelectedValue.ToString(), ddlClientPhase.SelectedValue.ToString(), ddlClientStatus.SelectedValue.ToString(), ddlClientRank.SelectedValue.ToString(), ddlClientIndustry.SelectedValue.ToString());
        GridView1.DataKeyNames = new string[] { "id","客户阶段","客户类型" };
        GridView1.DataBind();
    }
    public void GridView1_RowCommand(object sender, GridViewCommandEventArgs e)
    {
        if (null != RowCommand)
        {
            _ClientID = GridView1.SelectedIndex.ToString();
            _CommandName = e.CommandName;
            RowCommand(this, e);
        }
    }
    protected void GridView1_RowCreated(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowType == DataControlRowType.Header)
        {
            GridViewRow rowHeader = new GridViewRow(0, 0, DataControlRowType.Header, DataControlRowState.Normal);
            rowHeader.BackColor = System.Drawing.Color.FromName("#C1D9F3");
            rowHeader.Font.Bold = true;


            TableCellCollection cells = e.Row.Cells;
            TableCell headerCell = new TableCell();
            headerCell.ColumnSpan = cells.Count;
            headerCell.HorizontalAlign = System.Web.UI.WebControls.HorizontalAlign.Left;
            rowHeader.Cells.Add(headerCell);
            rowHeader.Visible = true;

            Button btnDel = new Button();
            btnDel.Text = "删除客户";
            btnDel.CommandName = "DEL";
            rowHeader.Cells[0].Controls.Add(btnDel);

            //Button btnAdd = new Button();
            //btnAdd.Text = "增加客户";
            //btnAdd.CommandName = "ADD";
            //rowHeader.Cells[0].Controls.Add(btnAdd);

            //HyperLink Import = new HyperLink();
            //Import.NavigateUrl = "../../Pages/Client/ClientUpload.aspx";
            //Import.Text = "批量导入";
            //rowHeader.Cells[0].Controls.Add(Import);

            GridView1.Controls[0].Controls.AddAt(0, rowHeader);
            //GridView1.Controls[0].Controls.RemoveAt(0);
        }
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }
    public void GridView1_SelectedIndexChanged(object sender, EventArgs e)
    {
        if (null != SelectedIndexChanged)
        {
            //_ClientID = GridView1.SelectedIndex.ToString();
            _ClientName = GridView1.Rows[GridView1.SelectedIndex].Cells[0].Text;
            SelectedIndexChanged(this, e);
        }
    }
    protected void GridView1_RowDataBound(object sender, GridViewRowEventArgs e)
    {
        if (e.Row.RowIndex > -1)
        {
            string tmp = e.Row.Cells[2].Text;
            if (tmp.Length > 10)
                e.Row.Cells[1].Text = tmp.Substring(0, 10) + "...";
        }
    }

    public void GridView1_DataBound(object sender, EventArgs e)
    {
        //((CheckBox)headerRow.FindControl("CheckBox1")).Text = GridView1.Controls[0].Controls[0].Controls[0].Visible.ToString();
        //((Button)GridView1.Controls[0].FindControl("DEL")).Visible = false;
        //GridView1.Controls[0].Controls[0].Controls[0].Controls[0].Visible=false;
        //GridView1.Controls[0].Controls[0].Visible = false;
        //if (null != RowDataBound)
        //{
        //    RowDataBound(this, e);
        //}
        GridView gridview = (GridView)sender;
        if (gridview.Rows.Count > 0)
        {
            for (int j = 0; j < gridview.Rows.Count;j++ )
            {
                DropDownList ddl1 = (DropDownList)gridview.Rows[j].FindControl("DropDownList1");

                ddl1.Items.Clear();
                ddl1.Items.Add(new ListItem("请选择", "-1"));
                DataTable dtClientPhase = CRM.Common.InitData.InitData_ClientPhase(Session["CID"].ToString());
                if (dtClientPhase.Rows.Count > 0)
                {
                    for (int i = 0; i < dtClientPhase.Rows.Count; i++)
                    {
                        ddl1.Items.Add(new ListItem(dtClientPhase.Rows[i]["客户阶段"].ToString(), dtClientPhase.Rows[i]["id"].ToString()));
                    }
                }
                ddl1.SelectedValue = gridview.DataKeys[j].Values["客户阶段"].ToString();

                DropDownList ddl2 = (DropDownList)gridview.Rows[j].FindControl("DropDownList2");
                ddl2.Items.Clear();
                ddl2.Items.Add(new ListItem("请选择", "-1"));
                DataTable dtClientType = CRM.Common.InitData.InitData_ClientType(Session["CID"].ToString());
                if (dtClientType.Rows.Count > 0)
                {
                    for (int i = 0; i < dtClientType.Rows.Count; i++)
                    {
                        ddl2.Items.Add(new ListItem(dtClientType.Rows[i]["客户类型"].ToString(), dtClientType.Rows[i]["id"].ToString()));
                    }
                }

                ddl2.SelectedValue = gridview.DataKeys[j].Values["客户类型"].ToString();
            }
        }

    }

    //public void GridView1_SelectedIndexChanging(object sender, GridViewSelectEventArgs e) {
    //    if (null != SelectedIndexChanging) {
    //        SelectedIndexChanging(this,e);
    //    }
    //}
    protected void GridView1_RowDeleting(object sender, GridViewDeleteEventArgs e)
    {
        int index = e.RowIndex;
        ClientBasic clientBasic = new ClientBasic();
        clientBasic.ClientBasicDeleteById(GridView1.DataKeys[index].Values["id"].ToString());

        Bind();

    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        Bind();
    }
    protected void ClientList1_SelectedIndexChanged(object sender, EventArgs e)
    {
        //string id = ClientList1.ClientID;
        //RegisterClientScriptBlock("ClientInfo", "<script language=javascript>location.href='/Pages/Client/ClientInfo.aspx?ClientID=" + id + "';</script>");
    }
    protected void ClientList1_RowCommand(object sender, EventArgs e)
    {
        
        //新增客户
        //if (ClientList1.CommandName == "ADD")
        //{
        //    RegisterClientScriptBlock("ADD", "<script language=javascript>location.href='/Pages/Client/ClientInfo.aspx';</script>");
        //}
        //#region 删除客户 只有本人才可以删除客户资料
        //if (ClientList1.CommandName == "DEL") {
        //    for (int i = 0; i < ((GridView)ClientList1.FindControl("GridView1")).Rows.Count; i++) {
        //        CheckBox cb=(CheckBox)(((GridView)ClientList1.FindControl("GridView1")).Rows[i].FindControl("CheckBox2"));
        //        if(cb.Checked==true){
        //            string id = ((GridView)ClientList1.FindControl("GridView1")).DataKeys[i].Values["id"].ToString();
        //            IList<ClientBasicInfo> clientbasicinfo = new List<ClientBasicInfo>();

        //            ClientBasic clientBasic = new ClientBasic();
        //            clientbasicinfo = clientBasic.GetClientBasicById(id);

        //            if (clientbasicinfo.Count > 0)
        //            {
        //                if (clientbasicinfo[0].业务员.ToString() == Session["LoginID"].ToString())
        //                {
        //                    //ClientBasic clientBasic = new ClientBasic();
        //                    clientBasic.ClientBasicDeleteById(id);
        //                }                        
        //            }

        //        }
        //    }
        //    ClientList1.Bind();

        //}
        //#endregion
    }

    protected void Page_Load(object sender, EventArgs e)
    {
        CRM.Common.Login.IsLogin();
        if (!IsPostBack)
        {
            Init_Data();//注意顺序
            Bind();
        }
    }

    protected void Button2_Click(object sender,EventArgs e) {

        if (CheckBox1.Checked == true)
        {
            string[] eids = CRM.Common.InitData.GetEmployeesLookRightEids(Session["LoginID"].ToString(), Session["CID"].ToString());
            ClientBasic clientBasic = new ClientBasic();

            IList<ClientBasicInfo> clientbasicinfos= clientBasic.GetClientBasicByConditions(eids, txtClientName.Text.Trim(), txtCantactName.Text.Trim(), ddlProvince.SelectedValue.ToString(), ddlCity.SelectedValue.ToString(), ddlSales.SelectedValue.ToString(), ddlClientType.SelectedValue.ToString(), ddlClientPhase.SelectedValue.ToString(), ddlClientStatus.SelectedValue.ToString(), ddlClientRank.SelectedValue.ToString(), ddlClientIndustry.SelectedValue.ToString());


            string sql = "update 客户基本信息表 set 客户阶段=@客户阶段,客户类型=@客户类型 where id=@id";
            for (int i = 0; i <clientbasicinfos.Count; i++)
            {
                SqlParameter[] paras = new SqlParameter[3];
                paras[0] = new SqlParameter("@客户阶段", DropDownList3.SelectedValue=="-1"?clientbasicinfos[i].客户阶段.ToString():DropDownList3.SelectedValue);
                paras[1] = new SqlParameter("@客户类型", DropDownList4.SelectedValue=="-1"?clientbasicinfos[i].客户类型.ToString():DropDownList4.SelectedValue);
                paras[2] = new SqlParameter("@id", clientbasicinfos[i].ID);

                CRM.DBUtility.SqlHelper.ExecuteNonQuery(CRM.DBUtility.SqlHelper.connstr, CommandType.Text, sql, paras);

            }
        }
        else {
            string sql = "update 客户基本信息表 set 客户阶段=@客户阶段,客户类型=@客户类型 where id=@id"; for (int i = 0; i < GridView1.Rows.Count; i++)
            {
                SqlParameter[] paras = new SqlParameter[3];
                paras[0] = new SqlParameter("@客户阶段", ((DropDownList)GridView1.Rows[i].FindControl("DropDownList1")).SelectedValue.ToString());
                paras[1] = new SqlParameter("@客户类型", ((DropDownList)GridView1.Rows[i].FindControl("DropDownList2")).SelectedValue.ToString());
                paras[2] = new SqlParameter("@id", GridView1.DataKeys[i].Values["id"].ToString());

                CRM.DBUtility.SqlHelper.ExecuteNonQuery(CRM.DBUtility.SqlHelper.connstr, CommandType.Text, sql, paras);

            }
        }
        Bind();
    
    }

    protected void Button3_Click(object sender, EventArgs e)
    {

        if (CheckBox1.Checked == true)
        {
            string[] eids = CRM.Common.InitData.GetEmployeesLookRightEids(Session["LoginID"].ToString(), Session["CID"].ToString());
            ClientBasic clientBasic = new ClientBasic();

            IList<ClientBasicInfo> clientbasicinfos = clientBasic.GetClientBasicByConditions(eids, txtClientName.Text.Trim(), txtCantactName.Text.Trim(), ddlProvince.SelectedValue.ToString(), ddlCity.SelectedValue.ToString(), ddlSales.SelectedValue.ToString(), ddlClientType.SelectedValue.ToString(), ddlClientPhase.SelectedValue.ToString(), ddlClientStatus.SelectedValue.ToString(), ddlClientRank.SelectedValue.ToString(), ddlClientIndustry.SelectedValue.ToString());


            string sql = "delete from 客户基本信息表 where id=@id";
            for (int i = 0; i < clientbasicinfos.Count; i++)
            {
                SqlParameter[] paras = new SqlParameter[1];
                paras[0] = new SqlParameter("@id", clientbasicinfos[i].ID);

                CRM.DBUtility.SqlHelper.ExecuteNonQuery(CRM.DBUtility.SqlHelper.connstr, CommandType.Text, sql, paras);

            }
        }
        else
        {

            for (int i = 0; i < GridView1.Rows.Count; i++)
            {
                CheckBox cb = (CheckBox)(GridView1.Rows[i].FindControl("CheckBox2"));
                if (cb.Checked == true)
                {
                    string id = GridView1.DataKeys[i].Values["id"].ToString();
                    IList<ClientBasicInfo> clientbasicinfo = new List<ClientBasicInfo>();

                    ClientBasic clientBasic = new ClientBasic();
                    clientbasicinfo = clientBasic.GetClientBasicById(id);

                    if (clientbasicinfo.Count > 0)
                    {
                        if (clientbasicinfo[0].业务员.ToString() == Session["LoginID"].ToString())
                        {
                            //ClientBasic clientBasic = new ClientBasic();
                            clientBasic.ClientBasicDeleteById(id);
                        }
                    }

                }
            }
        }
        Bind();

    }
}
