﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;

using CRM.BLL;
using CRM.Model;
using CRM.Common;


public partial class Pages_Client_ClientRemindInfo : System.Web.UI.Page
{
    protected void Init_Data()
    {
        ddlSales.Items.Clear();
        ddlSales.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtSales = CRM.Common.InitData.GetSalesByCid(Session["CID"].ToString());
        if (dtSales.Rows.Count > 0)
        {
            for (int i = 0; i < dtSales.Rows.Count; i++)
            {
                ddlSales.Items.Add(new ListItem(dtSales.Rows[i]["姓名"].ToString(), dtSales.Rows[i]["eid"].ToString()));
            }
        }


        txtDateTime1.Text = DateTime.Now.ToShortDateString();
        txtDateTime2.Text = DateTime.Now.ToShortDateString();

        if (rblIsEnd.SelectedValue == "0")
        {
            Panel1.Visible = false;
        }
        else
        {
            Panel1.Visible = true;
        }


    }
    protected void Bind()
    {
        #region  新增联系信息
        if (!String.IsNullOrEmpty(Request.QueryString["ClientRemindID"]))
        {
            IList<ClientRemindInfo> ClientRemindinfo = new List<ClientRemindInfo>();


            ClientRemind clientRemind = new ClientRemind();
            ClientRemindinfo = clientRemind.GetClientRemindByID(Request.QueryString["ClientRemindID"].ToString());

            if (ClientRemindinfo.Count > 0)
            {
                txtClientName.Text = CRM.Common.InitData.GetClientName(ClientRemindinfo[0].客户ID.ToString()).ToString();
                ddlSales.SelectedValue = ClientRemindinfo[0].业务员.ToString();
                ddlSales.Enabled = false;

                txtContent.Text = ClientRemindinfo[0].提醒内容;
                txtDateTime1.Text = ClientRemindinfo[0].提醒日期.ToShortDateString();
                txtDateTime2.Text = ClientRemindinfo[0].完成日期.ToShortDateString();
                rblIsEnd.SelectedValue = ClientRemindinfo[0].是否完成.ToString();

                if (rblIsEnd.SelectedValue == "0")
                {
                    Panel1.Visible = false;
                }
                else
                {
                    Panel1.Visible = true;
                }

                if (ClientRemindinfo[0].业务员.ToString() != Session["LoginID"].ToString())
                {
                    Button2.Visible = false;
                }
                else
                {
                    Button2.Visible = true;
                }
                Button1.Visible = false;
            }
            else
            {
                Button1.Visible = true;
                Button2.Visible = false;
            }
        }
        #endregion
        else
        {
            txtClientName.Text = CRM.Common.InitData.GetClientName(Request.QueryString["ClientID"]).ToString();
            ddlSales.SelectedValue = Session["LoginID"].ToString();
            ddlSales.Enabled = false;
            Button1.Visible = true;
            Button2.Visible = false;
        }
    }

    protected void Button1_Click(object sender, EventArgs e)
    {
        ClientRemindInfo ClientRemindinfo = new ClientRemindInfo();

        ClientRemindinfo.CID = Int32.Parse(Session["CID"].ToString());
        ClientRemindinfo.客户ID = Int32.Parse(Request.QueryString["ClientID"].ToString());
        ClientRemindinfo.提醒内容 = txtContent.Text.Trim();
        ClientRemindinfo.提醒日期 = DateTime.Parse(txtDateTime1.Text.Trim());
        ClientRemindinfo.是否完成 = Int32.Parse(rblIsEnd.SelectedValue);
        ClientRemindinfo.完成日期 = DateTime.Parse(txtDateTime2.Text.Trim());
        ClientRemindinfo.创建日期 = DateTime.Parse(DateTime.Now.ToString());
        ClientRemindinfo.业务员 = Int32.Parse(Session["LoginID"].ToString());

        ClientRemind clientRemind = new ClientRemind();
        clientRemind.ClientRemindAdd(ClientRemindinfo);

        Label1.Text = "添加成功";
    }

    protected void Button2_Click(object sender, EventArgs e)
    {
        ClientRemindInfo ClientRemindinfo = new ClientRemindInfo();

        ClientRemindinfo.提醒内容 = txtContent.Text.Trim();
        ClientRemindinfo.提醒日期 = DateTime.Parse(txtDateTime1.Text.Trim());
        ClientRemindinfo.是否完成 = Int32.Parse(rblIsEnd.SelectedValue);
        ClientRemindinfo.完成日期 = DateTime.Parse(txtDateTime2.Text.Trim());
        ClientRemindinfo.创建日期 = DateTime.Parse(DateTime.Now.ToString());
        ClientRemindinfo.ID = Int32.Parse(Request.QueryString["ClientRemindID"].ToString());

        ClientRemind clientRemind = new ClientRemind();
        clientRemind.ClientRemindEdit(ClientRemindinfo);

        Label1.Text = "修改成功！";
    }

    protected void rblIsEnd_TextChanged(object sender, EventArgs e)
    {
        if (rblIsEnd.SelectedValue == "0")
        {
            Panel1.Visible = false;
        }
        else
        {
            Panel1.Visible = true;
        }

    }
    
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            HyperLink1.NavigateUrl = "ClientRemind.aspx?ClientID=" + Request.QueryString["ClientID"] + "&ClientName=" + Request.QueryString["ClientName"] + "&SelectedIndex=" + Request.QueryString["SelectedIndex"];
            Init_Data();
            Bind();
        }
    }
}
