﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;
using CRM.BLL;
using CRM.Model;
using CRM.Common;

public partial class Pages_Client_ClientStepClientInfo : System.Web.UI.Page
{
    protected void Bind()
    {
        ClientInfo1.InitData();
        #region
        if (!String.IsNullOrEmpty(Request.QueryString["ClientID"]))
        {
            IList<ClientBasicInfo> clientbasicinfo = new List<ClientBasicInfo>();

            ClientBasic clientBasic = new ClientBasic();
            clientbasicinfo = clientBasic.GetClientBasicById(Request.QueryString["ClientID"].ToString());

            if (clientbasicinfo.Count > 0)
            {
                ((TextBox)ClientInfo1.FindControl("txtClientName")).Text = clientbasicinfo[0].客户名称;
                ((TextBox)ClientInfo1.FindControl("txtClientTel")).Text = clientbasicinfo[0].客户电话;
                ((TextBox)ClientInfo1.FindControl("txtClientSax")).Text = clientbasicinfo[0].客户传真;
                ((TextBox)ClientInfo1.FindControl("txtContacter")).Text = clientbasicinfo[0].主联系人;
                ((TextBox)ClientInfo1.FindControl("txtContactMobile")).Text = clientbasicinfo[0].联系手机;
                ((TextBox)ClientInfo1.FindControl("txtAddr")).Text = clientbasicinfo[0].详细地址;
                ((TextBox)ClientInfo1.FindControl("txtClientEmail")).Text = clientbasicinfo[0].电子邮箱;
                ((TextBox)ClientInfo1.FindControl("txtBz")).Text = clientbasicinfo[0].备注;
                ((DropDownList)ClientInfo1.FindControl("ddlSales")).SelectedValue = clientbasicinfo[0].业务员.ToString();
                ((DropDownList)ClientInfo1.FindControl("ddlSales")).Enabled = false;

                ((DropDownList)ClientInfo1.FindControl("ddlClientPhase")).SelectedValue = clientbasicinfo[0].客户阶段.ToString();
                ((DropDownList)ClientInfo1.FindControl("ddlClientType")).SelectedValue = clientbasicinfo[0].客户类型.ToString();
                ((DropDownList)ClientInfo1.FindControl("ddlClientStatus")).SelectedValue = clientbasicinfo[0].客户状态.ToString();
                ((DropDownList)ClientInfo1.FindControl("ddlClientRank")).SelectedValue = clientbasicinfo[0].客户级别.ToString();

                DropDownList ddlProvince = ((DropDownList)ClientInfo1.FindControl("ddlProvince"));
                ddlProvince.Items.Clear();
                ddlProvince.Items.Add(new ListItem("请选择", "-1"));
                DataTable dtProvince = CRM.Common.InitData.GetProvinceByCid(Session["CID"].ToString());
                if (dtProvince.Rows.Count > 0)
                {
                    for (int i = 0; i < dtProvince.Rows.Count; i++)
                    {
                        ddlProvince.Items.Add(new ListItem(dtProvince.Rows[i]["名称"].ToString(), dtProvince.Rows[i]["id"].ToString()));
                    }
                }

                ddlProvince.SelectedValue = clientbasicinfo[0].省份.ToString();

                ((DropDownList)ClientInfo1.FindControl("ddlCity")).DataSource = CRM.Common.InitData.GetCityByProvince(clientbasicinfo[0].省份.ToString());
                ((DropDownList)ClientInfo1.FindControl("ddlCity")).DataTextField = "名称";
                ((DropDownList)ClientInfo1.FindControl("ddlCity")).DataValueField = "id";
                ((DropDownList)ClientInfo1.FindControl("ddlCity")).DataBind();

                ((DropDownList)ClientInfo1.FindControl("ddlCity")).SelectedValue = clientbasicinfo[0].地区.ToString();
                ((TextBox)ClientInfo1.FindControl("txtContactDepartment")).Text = clientbasicinfo[0].部门;
                ((TextBox)ClientInfo1.FindControl("txtContactRole")).Text = clientbasicinfo[0].职务;

            }
        }
        #endregion
        ((Button)ClientInfo1.FindControl("Button1")).Visible = false;
        ((Button)ClientInfo1.FindControl("Button2")).Visible = false;
        ((DropDownList)ClientInfo1.FindControl("ddlSales")).Enabled = false;
        ((HyperLink)ClientInfo1.FindControl("HyperLink1")).Visible = false;
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack)
        {
            Bind();
        }
    }
}
