﻿using System;
using System.Data;
using System.Web;
using System.Web.UI;
using System.Web.UI.WebControls;
using System.Collections.Generic;

using CRM.BLL;
using CRM.Model;
using CRM.Common;


public partial class Pages_Client_ClientStepTop : System.Web.UI.Page
{
    protected void Init_Data()
    {
        ddlProvince.Items.Clear();
        ddlProvince.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtProvince = CRM.Common.InitData.GetProvinceByCid(Session["CID"].ToString());
        if (dtProvince.Rows.Count > 0)
        {
            for (int i = 0; i < dtProvince.Rows.Count; i++)
            {
                ddlProvince.Items.Add(new ListItem(dtProvince.Rows[i]["名称"].ToString(), dtProvince.Rows[i]["id"].ToString()));
            }
        }

        ddlCity.Items.Clear();
        ddlCity.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtCity = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        if (dtCity.Rows.Count > 0)
        {
            for (int i = 0; i < dtCity.Rows.Count; i++)
            {
                ddlCity.Items.Add(new ListItem(dtCity.Rows[i]["名称"].ToString(), dtCity.Rows[i]["id"].ToString()));
            }
        }

        ddlSales.Items.Clear();
        ddlSales.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtSales = CRM.Common.InitData.GetSalesByCid(Session["CID"].ToString());
        if (dtSales.Rows.Count > 0)
        {
            for (int i = 0; i < dtSales.Rows.Count; i++)
            {
                ddlSales.Items.Add(new ListItem(dtSales.Rows[i]["姓名"].ToString(), dtSales.Rows[i]["eid"].ToString()));
            }
        }
    }
    protected void Bind()
    {
        string[] eids = CRM.Common.InitData.GetEmployeesLookRightEids(Session["LoginID"].ToString(), Session["CID"].ToString());

        GridView1.DataSource = CRM.Common.InitData.GetClientStep(eids, txtClientName.Text.Trim(), txtCantactName.Text.Trim(), ddlProvince.SelectedValue.ToString(), ddlCity.SelectedValue.ToString(), ddlSales.SelectedValue.ToString());
        GridView1.DataKeyNames = new string[] { "id" };
        GridView1.DataBind();

    }
    protected void GridView1_SelectedIndexChanged(object sender,EventArgs e) {
        string id = GridView1.DataKeys[GridView1.SelectedIndex].Values["id"].ToString();
        if (!ClientScript.IsClientScriptBlockRegistered("ClientID"))
            RegisterClientScriptBlock("ClientID", "<script language=javascript>window.parent.Client_Menu.location.href='ClientStepMenu.aspx?ClientID="+id+"';window.parent.Client_Bottom.location.href='ClientStepClientInfo.aspx?ClientID=" + id + "';</script>");
    }
    protected void GridView1_PageIndexChanging(object sender, GridViewPageEventArgs e)
    {
        GridView1.PageIndex = e.NewPageIndex;
        Bind();
    }
    protected void ddlProvince_TextChanged(object sender, EventArgs e)
    {
        ddlCity.Items.Clear();
        ddlCity.Items.Add(new ListItem("请选择", "-1"));
        DataTable dtCity = CRM.Common.InitData.GetCityByProvince(ddlProvince.SelectedValue.ToString());
        if (dtCity.Rows.Count > 0)
        {
            for (int i = 0; i < dtCity.Rows.Count; i++)
            {
                ddlCity.Items.Add(new ListItem(dtCity.Rows[i]["名称"].ToString(), dtCity.Rows[i]["id"].ToString()));
            }
        }
    }
    protected void Button1_Click(object sender, EventArgs e)
    {
        Bind();
    }
    protected void Page_Load(object sender, EventArgs e)
    {
        if (!IsPostBack) {
            Init_Data();
            Bind();
        }
            
    }
}
